/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.model;

import io.jans.orm.annotation.AttributeEnum;
import java.util.HashMap;
import java.util.Map;

public enum SortOrder implements AttributeEnum
{
    ASCENDING("ascending", "asc"),
    DESCENDING("descending", "desc"),
    DEFAULT("default", "def");

    private String value;
    private String shortValue;
    private static Map<String, SortOrder> MAP_BY_VALUES;

    private SortOrder(String value, String shortValue) {
        this.value = value;
        this.shortValue = shortValue;
    }

    public String getValue() {
        return this.value;
    }

    public String getShortValue() {
        return this.shortValue;
    }

    public static SortOrder getByValue(String value) {
        return MAP_BY_VALUES.get(value);
    }

    public SortOrder resolveByValue(String value) {
        return SortOrder.getByValue(value);
    }

    static {
        MAP_BY_VALUES = new HashMap<String, SortOrder>();
        for (SortOrder enumType : SortOrder.values()) {
            MAP_BY_VALUES.put(enumType.getValue(), enumType);
        }
    }
}

