/*
 * Decompiled with CFR 0.152.
 */
package io.jans.eleven.client;

import com.google.common.base.Strings;
import io.jans.eleven.client.BaseClient;
import io.jans.eleven.client.SignRequest;
import io.jans.eleven.client.SignResponse;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;

public class SignClient
extends BaseClient<SignRequest, SignResponse> {
    public SignClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "POST";
    }

    @Override
    public SignRequest getRequest() {
        if (this.request instanceof SignRequest) {
            return (SignRequest)this.request;
        }
        return null;
    }

    @Override
    public void setRequest(SignRequest request) {
        this.request = request;
    }

    @Override
    public SignResponse getResponse() {
        if (this.response instanceof SignResponse) {
            return (SignResponse)this.response;
        }
        return null;
    }

    @Override
    public void setResponse(SignResponse response) {
        this.response = response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SignResponse exec() throws Exception {
        ResteasyClient resteasyClient = (ResteasyClient)ClientBuilder.newClient();
        ResteasyWebTarget webTarget = resteasyClient.target(this.url);
        Invocation.Builder clientRequest = webTarget.request();
        clientRequest.header("Content-Type", (Object)this.getRequest().getMediaType());
        if (!Strings.isNullOrEmpty((String)this.getRequest().getAccessToken())) {
            clientRequest.header("Authorization", (Object)("Bearer " + this.getRequest().getAccessToken()));
        }
        if ("POST".equals(this.request.getHttpMethod())) {
            String body = "{}";
            if (this.getRequest().getSignRequestParam() != null) {
                body = SignClient.toPrettyJson(this.getRequest().getSignRequestParam());
            }
            this.clientResponse = clientRequest.buildPost(Entity.entity((Object)body, (String)this.getRequest().getMediaType())).invoke();
        } else {
            this.clientResponse = clientRequest.buildGet().invoke();
        }
        try {
            this.setResponse(new SignResponse(this.clientResponse));
        }
        finally {
            this.clientResponse.close();
        }
        return this.getResponse();
    }
}

