/*
 * Decompiled with CFR 0.152.
 */
package io.jans.eleven.client;

import io.jans.eleven.client.BaseResponse;
import io.jans.eleven.util.StringUtils;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class GenerateKeyResponse
extends BaseResponse {
    private String keyId;
    private String keyType;
    private String keyUse;
    private String algorithm;
    private Long expirationTime;
    private String modulus;
    private String exponent;
    private String curve;
    private String x;
    private String y;
    private List<String> x5c;

    public GenerateKeyResponse(Response clientResponse) {
        super(clientResponse);
        JSONObject jsonObject = this.getJSONEntity();
        if (jsonObject != null) {
            this.keyType = jsonObject.optString("kty");
            this.keyId = jsonObject.optString("kid");
            this.keyUse = jsonObject.optString("use");
            this.algorithm = jsonObject.optString("alg");
            this.modulus = jsonObject.optString("n");
            this.exponent = jsonObject.optString("e");
            this.curve = jsonObject.optString("crv");
            this.x = jsonObject.optString("x");
            this.y = jsonObject.optString("y");
            this.expirationTime = jsonObject.optLong("exp");
            this.x5c = StringUtils.toList((JSONArray)jsonObject.optJSONArray("x5c"));
        }
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public String getKeyUse() {
        return this.keyUse;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public Long getExpirationTime() {
        return this.expirationTime;
    }

    public String getModulus() {
        return this.modulus;
    }

    public String getExponent() {
        return this.exponent;
    }

    public String getCurve() {
        return this.curve;
    }

    public String getX() {
        return this.x;
    }

    public String getY() {
        return this.y;
    }

    public List<String> getX5c() {
        return this.x5c;
    }
}

