/*
 * Decompiled with CFR 0.152.
 */
package io.jans.eleven.client;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseResponse {
    protected int status;
    protected String location;
    protected String entity;
    protected MultivaluedMap<String, Object> headers;

    public BaseResponse(Response clientResponse) {
        if (clientResponse != null) {
            this.status = clientResponse.getStatus();
            this.entity = (String)clientResponse.readEntity(String.class);
            this.headers = clientResponse.getHeaders();
            if (clientResponse.getLocation() != null) {
                this.location = clientResponse.getLocation().toString();
            }
        }
    }

    public int getStatus() {
        return this.status;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEntity() {
        return this.entity;
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.headers;
    }

    public JSONObject getJSONEntity() {
        if (this.entity != null && this.entity.length() > 0) {
            try {
                JSONObject jsonObject = new JSONObject(this.entity);
                return jsonObject;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

