/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.cache;

import io.jans.service.cache.AbstractRedisProvider;
import io.jans.service.cache.RedisConfiguration;
import io.jans.service.cache.RedisProviderFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

public class RedisShardedProvider
extends AbstractRedisProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RedisShardedProvider.class);
    private ShardedJedisPool pool;

    public RedisShardedProvider(RedisConfiguration redisConfiguration) {
        super(redisConfiguration);
    }

    @Override
    public void create() {
        try {
            LOG.debug("Starting RedisShardedProvider ... configuration:" + this.redisConfiguration);
            GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
            poolConfig.setMaxTotal(this.redisConfiguration.getMaxTotalConnections());
            poolConfig.setMaxIdle(this.redisConfiguration.getMaxIdleConnections());
            poolConfig.setMinIdle(2);
            this.pool = new ShardedJedisPool(poolConfig, RedisShardedProvider.shards(this.redisConfiguration));
            this.testConnection();
            LOG.debug("RedisShardedProvider started.");
        }
        catch (Exception e) {
            LOG.error("Failed to start RedisShardedProvider.", (Throwable)e);
            throw new IllegalStateException("Error starting RedisShardedProvider", e);
        }
    }

    private static List<JedisShardInfo> shards(RedisConfiguration configuration) {
        String[] serverWithPorts = StringUtils.split((String)configuration.getServers().trim(), (String)",");
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        for (String serverWithPort : serverWithPorts) {
            if ((serverWithPort = serverWithPort.trim()).contains(":") && !serverWithPort.contains("@") && !configuration.getServers().contains("//")) {
                String[] split = serverWithPort.trim().split(":");
                String host = split[0];
                int port = Integer.parseInt(split[1].trim());
                try {
                    JedisShardInfo shardInfo = configuration.getUseSSL().booleanValue() ? (StringUtils.isNotBlank((String)configuration.getSslTrustStoreFilePath()) && StringUtils.isNotBlank((String)configuration.getSslKeyStoreFilePath()) ? new JedisShardInfo(host, port, true, RedisProviderFactory.createSslSocketFactory(configuration), new SSLParameters(), (HostnameVerifier)new DefaultHostnameVerifier()) : new JedisShardInfo(host, port, true)) : new JedisShardInfo(host, port);
                    shards.add(shardInfo);
                }
                catch (Exception e) {
                    LOG.error("Failed to create shard info.", (Throwable)e);
                }
                continue;
            }
            shards.add(new JedisShardInfo(serverWithPort));
        }
        return shards;
    }

    @Override
    public void destroy() {
        LOG.debug("Destroying RedisShardedProvider");
        this.pool.close();
        LOG.debug("Destroyed RedisShardedProvider");
    }

    public ShardedJedisPool getDelegate() {
        return this.pool;
    }

    @Override
    public boolean hasKey(String key) {
        try (ShardedJedis resource = this.pool.getResource();){
            Boolean hasKey = resource.exists(key);
            boolean bl = Boolean.TRUE.equals(hasKey);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String key) {
        try (ShardedJedis jedis = this.pool.getResource();){
            byte[] value = jedis.get(key.getBytes());
            Object deserialized = null;
            if (value != null && value.length > 0) {
                deserialized = SerializationUtils.deserialize((byte[])value);
            }
            Object object = deserialized;
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(int expirationInSeconds, String key, Object object) {
        try (ShardedJedis jedis = this.pool.getResource();){
            String status = jedis.setex(key.getBytes(), expirationInSeconds, SerializationUtils.serialize((Serializable)((Serializable)object)));
            LOG.trace("put - key: " + key + ", status: " + status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, Object object) {
        try (ShardedJedis jedis = this.pool.getResource();){
            String status = jedis.set(key.getBytes(), SerializationUtils.serialize((Serializable)((Serializable)object)));
            LOG.trace("put - key: " + key + ", status: " + status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String key) {
        try (ShardedJedis jedis = this.pool.getResource();){
            Long entriesRemoved = jedis.del(key.getBytes());
            LOG.trace("remove - key: " + key + ", entriesRemoved: " + entriesRemoved);
        }
    }

    @Override
    public void clear() {
        LOG.trace("clear not supported by sharded implemented");
    }
}

