/*
 * Decompiled with CFR 0.152.
 */
package io.jans.service.cache;

import io.jans.service.cache.AbstractRedisProvider;
import io.jans.service.cache.RedisClusterProvider;
import io.jans.service.cache.RedisConfiguration;
import io.jans.service.cache.RedisProviderFactory;
import java.io.Serializable;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;

public class RedisSentinelProvider
extends AbstractRedisProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RedisSentinelProvider.class);
    private JedisSentinelPool pool;

    public RedisSentinelProvider(RedisConfiguration redisConfiguration) {
        super(redisConfiguration);
    }

    @Override
    public void create() {
        try {
            DefaultJedisClientConfig jedisClientConfig;
            LOG.debug("Starting RedisSentinelProvider ... configuration:" + this.getRedisConfiguration());
            JedisPoolConfig poolConfig = this.createPoolConfig();
            String password = this.redisConfiguration.getPassword();
            if (this.redisConfiguration.getUseSSL().booleanValue()) {
                RedisProviderFactory.setSSLSystemProperties(this.redisConfiguration);
                jedisClientConfig = DefaultJedisClientConfig.builder().ssl(true).password(password).build();
            } else {
                jedisClientConfig = DefaultJedisClientConfig.builder().ssl(false).password(password).build();
            }
            this.pool = new JedisSentinelPool(this.getRedisConfiguration().getSentinelMasterGroupName(), RedisClusterProvider.hosts(this.getRedisConfiguration().getServers()), (GenericObjectPoolConfig)poolConfig, (JedisClientConfig)jedisClientConfig, (JedisClientConfig)jedisClientConfig);
            this.testConnection();
            LOG.debug("RedisSentinelProvider started.");
        }
        catch (Exception e) {
            LOG.error("Failed to start RedisSentinelProvider.", (Throwable)e);
            throw new IllegalStateException("Error starting RedisSentinelProvider", e);
        }
    }

    @Override
    public void destroy() {
        LOG.debug("Destroying RedisSentinelProvider");
        try {
            this.pool.close();
        }
        catch (Exception e) {
            LOG.error("Failed to destroy RedisSentinelProvider", (Throwable)e);
            return;
        }
        LOG.debug("Destroyed RedisSentinelProvider");
    }

    public JedisSentinelPool getDelegate() {
        return this.pool;
    }

    @Override
    public boolean hasKey(String key) {
        try (Jedis resource = this.pool.getResource();){
            Boolean hasKey = resource.exists(key);
            boolean bl = Boolean.TRUE.equals(hasKey);
            return bl;
        }
    }

    @Override
    public Object get(String key) {
        try (Jedis resource = this.pool.getResource();){
            byte[] value = resource.get(key.getBytes());
            Object deserialized = null;
            if (value != null && value.length > 0) {
                deserialized = SerializationUtils.deserialize((byte[])value);
            }
            Object object = deserialized;
            return object;
        }
    }

    @Override
    public void put(int expirationInSeconds, String key, Object object) {
        try (Jedis resource = this.pool.getResource();){
            String status = resource.setex(key.getBytes(), expirationInSeconds, SerializationUtils.serialize((Serializable)((Serializable)object)));
            LOG.trace("put - key: " + key + ", status: " + status);
        }
    }

    @Override
    public void put(String key, Object object) {
        try (Jedis resource = this.pool.getResource();){
            String status = resource.set(key.getBytes(), SerializationUtils.serialize((Serializable)((Serializable)object)));
            LOG.trace("put - key: " + key + ", status: " + status);
        }
    }

    @Override
    public void remove(String key) {
        try (Jedis resource = this.pool.getResource();){
            Long entriesRemoved = resource.del(key.getBytes());
            LOG.trace("remove - key: " + key + ", entriesRemoved: " + entriesRemoved);
        }
    }

    @Override
    public void clear() {
        try (Jedis resource = this.pool.getResource();){
            resource.flushAll();
            LOG.trace("clear");
        }
    }
}

