---
tags:
- administration
- reference
- json
- feature-flags
---

# Janssen Auth Server Feature Flags

| Feature Flag Name | Description |  | 
|-----|-----|-----|
| ACTIVE_SESSION | Enable/Disable active session endpoint | [Details](#active_session) |
| CIBA | Enable/Disable OpenID Connect Client Initiated Backchannel Authentication Flow(CIBA) flow support | [Details](#ciba) |
| CLIENTINFO | Enable/Disable client info endpoint | [Details](#clientinfo) |
| DEVICE_AUTHZ | Enable/Disable support for device authorization | [Details](#device_authz) |
| END_SESSION | Enable/Disable end session endpoint | [Details](#end_session) |
| HEALTH_CHECK | Enable/Disable health-check endpoint | [Details](#health_check) |
| ID_GENERATION | Enable/Disable ID Generation endpoint | [Details](#id_generation) |
| INTROSPECTION | Enable/Disable token introspection endpoint | [Details](#introspection) |
| JANS_CONFIGURATION | Enable/Disable *.well-known* configuration endpoint | [Details](#jans_configuration) |
| METRIC | Enable/Disable metric reporter feature | [Details](#metric) |
| PAR | Enable/Disable Pushed Authorization Requests(PAR) feature | [Details](#par) |
| REGISTRATION | Enable/Disable client registration endpoint | [Details](#registration) |
| REVOKE_SESSION | Enable/Disable session revocation endpoint | [Details](#revoke_session) |
| REVOKE_TOKEN | Enable/Disable token revocation endpoint | [Details](#revoke_token) |
| SSA | Enable/Disable Software Statement Assertion(SSA) feature | [Details](#ssa) |
| STAT | Enable/Disable Stat service | [Details](#stat) |
| STATUS_SESSION | Enable/Disable session status check endpoint | [Details](#status_session) |
| U2F | Enable/Disable support for Universal 2nd Factor(U2F) protocol | [Details](#u2f) |
| UMA | Enable/Disable support for User-Managed Access (UMA) | [Details](#uma) |
| USERINFO | Enable/Disable OpenID Connect [userinfo endpoint](https://openid.net/specs/openid-connect-core-1_0.html#UserInfo) | [Details](#userinfo) |


### ACTIVE_SESSION

- Description: Enable/Disable active session endpoint

- Required: No

- Default value: None


### CIBA

- Description: Enable/Disable OpenID Connect Client Initiated Backchannel Authentication Flow(CIBA) flow support

- Required: No

- Default value: None


### CLIENTINFO

- Description: Enable/Disable client info endpoint

- Required: No

- Default value: None


### DEVICE_AUTHZ

- Description: Enable/Disable support for device authorization

- Required: No

- Default value: None


### END_SESSION

- Description: Enable/Disable end session endpoint

- Required: No

- Default value: None


### HEALTH_CHECK

- Description: Enable/Disable health-check endpoint

- Required: No

- Default value: None


### ID_GENERATION

- Description: Enable/Disable ID Generation endpoint

- Required: No

- Default value: None


### INTROSPECTION

- Description: Enable/Disable token introspection endpoint

- Required: No

- Default value: None


### JANS_CONFIGURATION

- Description: Enable/Disable *.well-known* configuration endpoint

- Required: No

- Default value: None


### METRIC

- Description: Enable/Disable metric reporter feature

- Required: No

- Default value: None


### PAR

- Description: Enable/Disable Pushed Authorization Requests(PAR) feature

- Required: No

- Default value: None


### REGISTRATION

- Description: Enable/Disable client registration endpoint

- Required: No

- Default value: None


### REVOKE_SESSION

- Description: Enable/Disable session revocation endpoint

- Required: No

- Default value: None


### REVOKE_TOKEN

- Description: Enable/Disable token revocation endpoint

- Required: No

- Default value: None


### SSA

- Description: Enable/Disable Software Statement Assertion(SSA) feature

- Required: No

- Default value: None


### STAT

- Description: Enable/Disable Stat service

- Required: No

- Default value: None


### STATUS_SESSION

- Description: Enable/Disable session status check endpoint

- Required: No

- Default value: None


### U2F

- Description: Enable/Disable support for Universal 2nd Factor(U2F) protocol

- Required: No

- Default value: None


### UMA

- Description: Enable/Disable support for User-Managed Access (UMA)

- Required: No

- Default value: None


### USERINFO

- Description: Enable/Disable OpenID Connect [userinfo endpoint](https://openid.net/specs/openid-connect-core-1_0.html#UserInfo)

- Required: No

- Default value: None


