/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.util;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class URLPatternList {
    private static final Logger LOG = Logger.getLogger(URLPatternList.class);
    private static final String URL_PATTERN_PARTS_1 = "^((\\*|[A-Za-z-]+):(//)?)?";
    private static final String URL_PATTERN_PARTS_2 = "(\\*|((\\*\\.)?[^*/:]+))?(:(\\d+))?(/.*)?";
    private List<URLPattern> patternList = new ArrayList<URLPattern>();

    public URLPatternList() {
    }

    public URLPatternList(List<String> patternList) {
        this();
        if (patternList != null) {
            for (String urlPattern : patternList) {
                this.addListEntry(urlPattern);
            }
        }
    }

    public boolean isUrlListed(String uri) {
        if (this.patternList == null) {
            return true;
        }
        URI parsedUri = URI.create(uri);
        for (URLPattern pattern : this.patternList) {
            if (!pattern.matches(parsedUri)) continue;
            return true;
        }
        return false;
    }

    public void addListEntry(String urlPattern) {
        if (this.patternList == null) {
            return;
        }
        if (urlPattern.compareTo("*") == 0) {
            LOG.debug((Object)"Unlimited access to network resources");
            this.patternList = null;
            return;
        }
        try {
            Pattern parts = Pattern.compile("^((\\*|[A-Za-z-]+):(//)?)?(\\*|((\\*\\.)?[^*/:]+))?(:(\\d+))?(/.*)?");
            Matcher m = parts.matcher(urlPattern);
            this.addOriginURLMatcher(m);
        }
        catch (Exception e) {
            LOG.debug((Object)("Failed to add origin " + urlPattern));
        }
    }

    private void addOriginURLMatcher(Matcher m) throws MalformedURLException {
        if (m != null && m.matches()) {
            String scheme = m.group(2);
            String host = m.group(4);
            if (("file".equals(scheme) || "content".equals(scheme)) && host == null) {
                host = "*";
            }
            String port = m.group(8);
            String path = m.group(9);
            if (scheme == null) {
                this.patternList.add(new URLPattern("http", host, port, path));
                this.patternList.add(new URLPattern("https", host, port, path));
            } else {
                this.patternList.add(new URLPattern(scheme, host, port, path));
            }
        }
    }

    private static class URLPattern {
        Pattern scheme;
        Pattern host;
        Integer port;
        Pattern path;

        public URLPattern(String scheme, String host, String port, String path) throws MalformedURLException {
            try {
                this.scheme = scheme == null || "*".equals(scheme) ? null : Pattern.compile(this.regexFromPattern(scheme, false), 2);
                this.host = "*".equals(host) ? null : (host.startsWith("*.") ? Pattern.compile("([a-z0-9.-]*\\.)?" + this.regexFromPattern(host.substring(2), false), 2) : Pattern.compile(this.regexFromPattern(host, false), 2));
                this.port = port == null || "*".equals(port) ? null : Integer.valueOf(Integer.parseInt(port, 10));
                this.path = path == null || "/*".equals(path) ? null : Pattern.compile(this.regexFromPattern(path, true));
            }
            catch (NumberFormatException e) {
                throw new MalformedURLException("Port must be a number");
            }
        }

        public boolean matches(URI uri) {
            try {
                return !(this.scheme != null && !this.scheme.matcher(uri.getScheme()).matches() || this.host != null && !this.host.matcher(uri.getHost()).matches() || this.port != null && !this.port.equals(uri.getPort()) || this.path != null && !this.path.matcher(uri.getPath()).matches());
            }
            catch (Exception e) {
                LOG.debug((Object)e.toString());
                return false;
            }
        }

        private String regexFromPattern(String pattern, boolean allowWildcards) {
            String toReplace = "\\.[]{}()^$?+|";
            StringBuilder regex = new StringBuilder();
            for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                if (c == '*' && allowWildcards) {
                    regex.append(".");
                } else if ("\\.[]{}()^$?+|".indexOf(c) > -1) {
                    regex.append('\\');
                }
                regex.append(c);
            }
            return regex.toString();
        }
    }
}

