/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.util;

import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.util.BCStyleExtended;
import io.jans.as.model.util.Base64Util;
import java.io.ByteArrayInputStream;
import java.net.URLDecoder;
import java.security.AlgorithmParameters;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.util.encoders.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertUtils {
    private static final Logger log = LoggerFactory.getLogger(CertUtils.class);

    private CertUtils() {
    }

    public static SignatureAlgorithm getSignatureAlgorithm(X509Certificate cert) {
        String signAlgName = cert.getSigAlgName();
        for (SignatureAlgorithm sa : SignatureAlgorithm.values()) {
            if (!signAlgName.equalsIgnoreCase(sa.getAlgorithm())) continue;
            return sa;
        }
        if ("RSASSA-PSS".equals(signAlgName)) {
            AlgorithmParameters algorithmParameters = CertUtils.getAlgorithmParameters(cert);
            if (algorithmParameters == null) {
                return null;
            }
            String algParamString = algorithmParameters.toString();
            if (algParamString.contains("SHA-256")) {
                return SignatureAlgorithm.PS256;
            }
            if (algParamString.contains("SHA-384")) {
                return SignatureAlgorithm.PS384;
            }
            if (algParamString.contains("SHA-512")) {
                return SignatureAlgorithm.PS512;
            }
        }
        return null;
    }

    public static AlgorithmParameters getAlgorithmParameters(X509Certificate cert) {
        try {
            AlgorithmParameters result = AlgorithmParameters.getInstance(cert.getSigAlgName());
            result.init(cert.getSigAlgParams());
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static X509Certificate x509CertificateFromBytes(byte[] cert) {
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(cert);
            return (X509Certificate)certFactory.generateCertificate(bais);
        }
        catch (Exception ex) {
            log.error("Failed to parse X.509 certificates from bytes", (Throwable)ex);
            return null;
        }
    }

    public static X509Certificate x509CertificateFromPem(String pem) {
        try {
            X509Certificate result = CertUtils.x509CertificateFromPemInternal(pem);
            if (result != null) {
                return result;
            }
        }
        catch (Exception e) {
            log.trace("Failed to parse pem. {}, trying to url decode it.", (Object)e.getMessage());
        }
        try {
            return CertUtils.x509CertificateFromPemInternal(URLDecoder.decode(pem, "UTF-8"));
        }
        catch (Exception e) {
            log.error("Failed to parse pem", (Throwable)e);
            return null;
        }
    }

    private static X509Certificate x509CertificateFromPemInternal(String pem) {
        pem = StringUtils.remove((String)pem, (String)"-----BEGIN CERTIFICATE-----");
        pem = StringUtils.remove((String)pem, (String)"-----END CERTIFICATE-----");
        return CertUtils.x509CertificateFromBytes(Base64.decode((String)pem));
    }

    public static String confirmationMethodHashS256(String certificateAsPem) {
        if (StringUtils.isBlank((String)certificateAsPem)) {
            return "";
        }
        try {
            return CertUtils.confirmationMethodHashS256Internal(certificateAsPem);
        }
        catch (Exception e) {
            try {
                return CertUtils.confirmationMethodHashS256Internal(URLDecoder.decode(certificateAsPem, "UTF-8"));
            }
            catch (Exception ex) {
                log.error("Failed to hash certificate: " + certificateAsPem, (Throwable)ex);
                return "";
            }
        }
    }

    private static String confirmationMethodHashS256Internal(String certificateAsPem) {
        certificateAsPem = StringUtils.remove((String)certificateAsPem, (String)"-----BEGIN CERTIFICATE-----");
        certificateAsPem = StringUtils.remove((String)certificateAsPem, (String)"-----END CERTIFICATE-----");
        certificateAsPem = StringUtils.replace((String)certificateAsPem, (String)"\n", (String)"");
        return Base64Util.base64urlencode(DigestUtils.sha256((byte[])Base64.decode((String)certificateAsPem)));
    }

    @NotNull
    public static String getCN(@Nullable X509Certificate cert) {
        return CertUtils.getAttr(cert, BCStyle.CN);
    }

    @NotNull
    public static String getAttr(@Nullable X509Certificate cert, ASN1ObjectIdentifier attrName) {
        try {
            if (cert == null) {
                return "";
            }
            X500Name x500name = new JcaX509CertificateHolder(cert).getSubject();
            RDN[] rdns = x500name.getRDNs(attrName);
            if (rdns == null || rdns.length == 0) {
                return "";
            }
            RDN cn = rdns[0];
            if (cn != null && cn.getFirst() != null && cn.getFirst().getValue() != null) {
                return IETFUtils.valueToString((ASN1Encodable)cn.getFirst().getValue());
            }
        }
        catch (CertificateEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return "";
    }

    public static boolean equalsRdn(String rdn1, String rdn2) {
        if (StringUtils.isBlank((String)rdn1) || StringUtils.isBlank((String)rdn2)) {
            return false;
        }
        X500Name n1 = new X500Name(BCStyleExtended.INSTANCE, rdn1);
        X500Name n2 = new X500Name(BCStyleExtended.INSTANCE, rdn2);
        return n1.equals((Object)n2);
    }
}

