/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.util;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;

public class Base64Util {
    private Base64Util() {
    }

    public static String base64urlencode(byte[] arg) {
        String s = Base64.encodeBase64String((byte[])arg);
        s = s.split("=")[0];
        s = s.replace('+', '-');
        s = s.replace('/', '_');
        return s;
    }

    public static byte[] base64urldecode(String arg) throws IllegalArgumentException {
        String s = Base64Util.removePadding(arg);
        return Base64.decodeBase64((String)s);
    }

    public static String base64urldecodeToString(String arg) throws IllegalArgumentException {
        byte[] decoded = Base64Util.base64urldecode(arg);
        return new String(decoded, StandardCharsets.UTF_8);
    }

    public static String removePadding(String base64UrlEncoded) {
        Object s = base64UrlEncoded;
        s = ((String)s).replace('-', '+');
        s = ((String)s).replace('_', '/');
        switch (((String)s).length() % 4) {
            case 0: {
                break;
            }
            case 2: {
                s = (String)s + "==";
                break;
            }
            case 3: {
                s = (String)s + "=";
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal base64url string.");
            }
        }
        return s;
    }

    public static String base64urlencodeUnsignedBigInt(BigInteger bigInteger) {
        return Base64Util.base64urlencode(Base64Util.bigIntegerToUnsignedByteArray(bigInteger));
    }

    public static byte[] unsignedToBytes(int[] plaintextUnsignedBytes) {
        byte[] bytes = new byte[plaintextUnsignedBytes.length];
        for (int i = 0; i < plaintextUnsignedBytes.length; ++i) {
            bytes[i] = (byte)plaintextUnsignedBytes[i];
        }
        return bytes;
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte aByte : bytes) {
            result.append(String.format("%02x", aByte));
        }
        return result.toString();
    }

    public static byte[] bigIntegerToUnsignedByteArray(BigInteger bigInteger) {
        byte[] array = bigInteger.toByteArray();
        if (array[0] == 0) {
            byte[] tmp = new byte[array.length - 1];
            System.arraycopy(array, 1, tmp, 0, tmp.length);
            array = tmp;
        }
        return array;
    }
}

