/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.uma;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class JsonLogic {
    private static final Logger LOG = Logger.getLogger(JsonLogic.class);
    private static final JsonLogic INSTANCE = new JsonLogic();
    private final ScriptEngine engine;

    private JsonLogic() {
        ScriptEngineManager factory = new ScriptEngineManager();
        this.engine = factory.getEngineByName("nashorn");
        Preconditions.checkNotNull((Object)this.engine);
        this.loadScript("json_logic.js");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadScript(String scriptName) {
        Preconditions.checkState((boolean)StringUtils.isNotBlank((String)scriptName));
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(scriptName);
        Preconditions.checkNotNull((Object)stream);
        try {
            String script = IOUtils.toString((InputStream)stream);
            this.engine.eval(script);
            LOG.trace((Object)("Loaded script, name: " + scriptName));
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to load JavaScript script, name: " + scriptName), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    public static JsonLogic getInstance() {
        return INSTANCE;
    }

    public ScriptEngine getEngine() {
        return this.engine;
    }

    public Invocable getInvocable() {
        return (Invocable)((Object)this.engine);
    }

    public static Object eval(String script) throws ScriptException {
        return JsonLogic.getInstance().getEngine().eval(script);
    }

    public static Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return JsonLogic.getInstance().getInvocable().invokeFunction(name, args);
    }

    public static boolean apply(String rule) throws ScriptException {
        return JsonLogic.applyObject(rule).equals(Boolean.TRUE);
    }

    public static boolean apply(String rule, String data) throws ScriptException {
        return JsonLogic.applyObject(rule, data).equals(Boolean.TRUE);
    }

    public static Object applyObject(String rule) throws ScriptException {
        return JsonLogic.eval("jsonLogic.apply( " + rule + " );");
    }

    public static Object applyObject(String rule, String data) throws ScriptException {
        return JsonLogic.eval("jsonLogic.apply( " + rule + ", " + data + " );");
    }
}

