/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.jws;

import io.jans.as.model.crypto.Certificate;
import io.jans.as.model.crypto.signature.RSAPrivateKey;
import io.jans.as.model.crypto.signature.RSAPublicKey;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.jws.AbstractJwsSigner;
import io.jans.as.model.util.Base64Util;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class RSASigner
extends AbstractJwsSigner {
    private RSAPrivateKey rsaPrivateKey;
    private RSAPublicKey rsaPublicKey;

    public RSASigner(SignatureAlgorithm signatureAlgorithm, RSAPrivateKey rsaPrivateKey) {
        super(signatureAlgorithm);
        this.rsaPrivateKey = rsaPrivateKey;
    }

    public RSASigner(SignatureAlgorithm signatureAlgorithm, RSAPublicKey rsaPublicKey) {
        super(signatureAlgorithm);
        this.rsaPublicKey = rsaPublicKey;
    }

    public RSASigner(SignatureAlgorithm signatureAlgorithm, Certificate certificate) {
        super(signatureAlgorithm);
        this.rsaPublicKey = certificate.getRsaPublicKey();
    }

    @Override
    public String generateSignature(String signingInput) throws SignatureException {
        if (this.getSignatureAlgorithm() == null) {
            throw new SignatureException("The signature algorithm is null");
        }
        if (this.rsaPrivateKey == null) {
            throw new SignatureException("The RSA private key is null");
        }
        if (signingInput == null) {
            throw new SignatureException("The signing input is null");
        }
        try {
            RSAPrivateKeySpec rsaPrivateKeySpec = new RSAPrivateKeySpec(this.rsaPrivateKey.getModulus(), this.rsaPrivateKey.getPrivateExponent());
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
            PrivateKey privateKey = keyFactory.generatePrivate(rsaPrivateKeySpec);
            Signature signature = Signature.getInstance(this.getSignatureAlgorithm().getAlgorithm(), "BC");
            signature.initSign(privateKey);
            signature.update(signingInput.getBytes(StandardCharsets.UTF_8));
            return Base64Util.base64urlencode(signature.sign());
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
    }

    @Override
    public boolean validateSignature(String signingInput, String signature) throws SignatureException {
        if (this.getSignatureAlgorithm() == null) {
            throw new SignatureException("The signature algorithm is null");
        }
        if (this.rsaPublicKey == null) {
            throw new SignatureException("The RSA public key is null");
        }
        if (signingInput == null) {
            throw new SignatureException("The signing input is null");
        }
        try {
            byte[] sigBytes = Base64Util.base64urldecode(signature);
            byte[] sigInBytes = signingInput.getBytes(StandardCharsets.UTF_8);
            RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(this.rsaPublicKey.getModulus(), this.rsaPublicKey.getPublicExponent());
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
            PublicKey publicKey = keyFactory.generatePublic(rsaPublicKeySpec);
            Signature sign = Signature.getInstance(this.getSignatureAlgorithm().getAlgorithm(), "BC");
            sign.initVerify(publicKey);
            sign.update(sigInBytes);
            return sign.verify(sigBytes);
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
    }
}

