/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.jws;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.crypto.impl.ECDSA;
import io.jans.as.model.crypto.Certificate;
import io.jans.as.model.crypto.signature.AlgorithmFamily;
import io.jans.as.model.crypto.signature.ECDSAPrivateKey;
import io.jans.as.model.crypto.signature.ECDSAPublicKey;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.jws.AbstractJwsSigner;
import io.jans.as.model.util.Base64Util;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.KeySpec;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;

public class ECDSASigner
extends AbstractJwsSigner {
    private ECDSAPrivateKey ecdsaPrivateKey;
    private ECDSAPublicKey ecdsaPublicKey;

    public ECDSASigner(SignatureAlgorithm signatureAlgorithm, ECDSAPrivateKey ecdsaPrivateKey) {
        super(signatureAlgorithm);
        this.ecdsaPrivateKey = ecdsaPrivateKey;
    }

    public ECDSASigner(SignatureAlgorithm signatureAlgorithm, ECDSAPublicKey ecdsaPublicKey) {
        super(signatureAlgorithm);
        this.ecdsaPublicKey = ecdsaPublicKey;
    }

    public ECDSASigner(SignatureAlgorithm signatureAlgorithm, Certificate certificate) {
        super(signatureAlgorithm);
        this.ecdsaPublicKey = certificate.getEcdsaPublicKey();
    }

    @Override
    public String generateSignature(String signingInput) throws SignatureException {
        if (this.getSignatureAlgorithm() == null) {
            throw new SignatureException("The signature algorithm is null");
        }
        if (this.ecdsaPrivateKey == null) {
            throw new SignatureException("The ECDSA private key is null");
        }
        if (signingInput == null) {
            throw new SignatureException("The signing input is null");
        }
        try {
            ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)this.getSignatureAlgorithm().getCurve().getName());
            ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(this.ecdsaPrivateKey.getD(), (ECParameterSpec)ecSpec);
            KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", "BC");
            PrivateKey privateKey = keyFactory.generatePrivate((KeySpec)privateKeySpec);
            Signature signer = Signature.getInstance(this.getSignatureAlgorithm().getAlgorithm(), "BC");
            signer.initSign(privateKey);
            signer.update(signingInput.getBytes(StandardCharsets.UTF_8));
            byte[] signature = signer.sign();
            if (AlgorithmFamily.EC.equals((Object)this.getSignatureAlgorithm().getFamily())) {
                int signatureLenght = ECDSA.getSignatureByteArrayLength((JWSAlgorithm)JWSAlgorithm.parse((String)this.getSignatureAlgorithm().getName()));
                signature = ECDSA.transcodeSignatureToConcat((byte[])signature, (int)signatureLenght);
            }
            return Base64Util.base64urlencode(signature);
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
    }

    @Override
    public boolean validateSignature(String signingInput, String signature) throws SignatureException {
        if (this.getSignatureAlgorithm() == null) {
            throw new SignatureException("The signature algorithm is null");
        }
        if (this.ecdsaPublicKey == null) {
            throw new SignatureException("The ECDSA public key is null");
        }
        if (signingInput == null) {
            throw new SignatureException("The signing input is null");
        }
        SignatureAlgorithm signatureAlgorithm = this.getSignatureAlgorithm();
        try {
            byte[] sigBytes = Base64Util.base64urldecode(signature);
            if (AlgorithmFamily.EC.equals((Object)this.getSignatureAlgorithm().getFamily())) {
                sigBytes = ECDSA.transcodeSignatureToDER((byte[])sigBytes);
            }
            byte[] sigInBytes = signingInput.getBytes(StandardCharsets.UTF_8);
            ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)signatureAlgorithm.getCurve().getAlias());
            ECPoint pointQ = ecSpec.getCurve().createPoint(this.ecdsaPublicKey.getX(), this.ecdsaPublicKey.getY());
            ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(pointQ, (ECParameterSpec)ecSpec);
            KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", "BC");
            PublicKey publicKey = keyFactory.generatePublic((KeySpec)publicKeySpec);
            Signature sig = Signature.getInstance(signatureAlgorithm.getAlgorithm(), "BC");
            sig.initVerify(publicKey);
            sig.update(sigInBytes);
            return sig.verify(sigBytes);
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
    }
}

