/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.jwk;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import io.jans.as.model.jwk.JSONWebKey;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONWebKeySet {
    @JsonIgnore
    private static final Logger LOG = LoggerFactory.getLogger(JSONWebKeySet.class);
    private List<JSONWebKey> keys = new ArrayList<JSONWebKey>();

    public List<JSONWebKey> getKeys() {
        return this.keys;
    }

    public void setKeys(List<JSONWebKey> keys) {
        this.keys = keys;
    }

    public JSONWebKey getKey(String keyId) {
        for (JSONWebKey jsonWebKey : this.keys) {
            if (!jsonWebKey.getKid().equals(keyId)) continue;
            return jsonWebKey;
        }
        return null;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObj = new JSONObject();
        JSONArray keyArray = new JSONArray();
        for (JSONWebKey key : this.getKeys()) {
            JSONObject jsonKeyValue = key.toJSONObject();
            keyArray.put((Object)jsonKeyValue);
        }
        jsonObj.put("keys", (Object)keyArray);
        return jsonObj;
    }

    public String toString() {
        try {
            JSONObject jwks = this.toJSONObject();
            return this.toPrettyJson(jwks).replace("\\/", "/");
        }
        catch (JsonProcessingException | JSONException e) {
            LOG.error(e.getMessage(), e);
            return "";
        }
    }

    private String toPrettyJson(JSONObject jsonObject) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JsonOrgModule());
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject);
    }

    public static JSONWebKeySet fromJSONObject(JSONObject jwksJSONObject) throws JSONException {
        JSONWebKeySet jwks = new JSONWebKeySet();
        JSONArray jwksJsonArray = jwksJSONObject.getJSONArray("keys");
        for (int i = 0; i < jwksJsonArray.length(); ++i) {
            JSONObject jwkJsonObject = jwksJsonArray.getJSONObject(i);
            JSONWebKey jwk = JSONWebKey.fromJSONObject(jwkJsonObject);
            jwks.getKeys().add(jwk);
        }
        return jwks;
    }
}

