/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.jwe;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.AESEncrypter;
import com.nimbusds.jose.crypto.RSAEncrypter;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.SignedJWT;
import io.jans.as.model.crypto.encryption.BlockEncryptionAlgorithm;
import io.jans.as.model.crypto.encryption.KeyEncryptionAlgorithm;
import io.jans.as.model.exception.InvalidJweException;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jwe.AbstractJweEncrypter;
import io.jans.as.model.jwe.Jwe;
import io.jans.as.model.jwt.JwtHeader;
import io.jans.as.model.jwt.JwtType;
import io.jans.as.model.util.Base64Util;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Arrays;

public class JweEncrypterImpl
extends AbstractJweEncrypter {
    private PublicKey publicKey;
    private byte[] sharedSymmetricKey;

    public JweEncrypterImpl(KeyEncryptionAlgorithm keyEncryptionAlgorithm, BlockEncryptionAlgorithm blockEncryptionAlgorithm, byte[] sharedSymmetricKey) {
        super(keyEncryptionAlgorithm, blockEncryptionAlgorithm);
        if (sharedSymmetricKey != null) {
            this.sharedSymmetricKey = (byte[])sharedSymmetricKey.clone();
        }
    }

    public JweEncrypterImpl(KeyEncryptionAlgorithm keyEncryptionAlgorithm, BlockEncryptionAlgorithm blockEncryptionAlgorithm, PublicKey publicKey) {
        super(keyEncryptionAlgorithm, blockEncryptionAlgorithm);
        this.publicKey = publicKey;
    }

    public JWEEncrypter createJweEncrypter() throws JOSEException, InvalidJweException, NoSuchAlgorithmException {
        KeyEncryptionAlgorithm keyEncryptionAlgorithm = this.getKeyEncryptionAlgorithm();
        if (keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA1_5 || keyEncryptionAlgorithm == KeyEncryptionAlgorithm.RSA_OAEP) {
            return new RSAEncrypter(new RSAKey.Builder((RSAPublicKey)this.publicKey).build());
        }
        if (keyEncryptionAlgorithm == KeyEncryptionAlgorithm.A128KW || keyEncryptionAlgorithm == KeyEncryptionAlgorithm.A256KW) {
            if (this.sharedSymmetricKey == null) {
                throw new InvalidJweException("The shared symmetric key is null");
            }
            int keyLength = 16;
            if (keyEncryptionAlgorithm == KeyEncryptionAlgorithm.A256KW) {
                keyLength = 32;
            }
            if (this.sharedSymmetricKey.length != keyLength) {
                MessageDigest sha = MessageDigest.getInstance("SHA-256");
                this.sharedSymmetricKey = sha.digest(this.sharedSymmetricKey);
                this.sharedSymmetricKey = Arrays.copyOf(this.sharedSymmetricKey, keyLength);
            }
            return new AESEncrypter(this.sharedSymmetricKey);
        }
        throw new InvalidJweException("The key encryption algorithm is not supported");
    }

    public static Payload createPayload(Jwe jwe) throws ParseException, InvalidJwtException {
        if (jwe.getSignedJWTPayload() != null) {
            return new Payload(SignedJWT.parse((String)jwe.getSignedJWTPayload().toString()));
        }
        return new Payload(Base64Util.base64urlencode(jwe.getClaims().toJsonString().getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public Jwe encrypt(Jwe jwe) throws InvalidJweException {
        try {
            JWEEncrypter encrypter = this.createJweEncrypter();
            if (jwe.getSignedJWTPayload() != null) {
                jwe.getHeader().setContentType(JwtType.JWT);
            }
            JWEObject jweObject = new JWEObject(JWEHeader.parse((String)jwe.getHeader().toJsonObject().toString()), JweEncrypterImpl.createPayload(jwe));
            jweObject.encrypt(encrypter);
            String encryptedJwe = jweObject.serialize();
            String[] jweParts = encryptedJwe.split("\\.");
            if (jweParts.length != 5) {
                throw new InvalidJwtException("Invalid JWS format.");
            }
            String encodedHeader = jweParts[0];
            String encodedEncryptedKey = jweParts[1];
            String encodedInitializationVector = jweParts[2];
            String encodedCipherText = jweParts[3];
            String encodedIntegrityValue = jweParts[4];
            jwe.setEncodedHeader(encodedHeader);
            jwe.setEncodedEncryptedKey(encodedEncryptedKey);
            jwe.setEncodedInitializationVector(encodedInitializationVector);
            jwe.setEncodedCiphertext(encodedCipherText);
            jwe.setEncodedIntegrityValue(encodedIntegrityValue);
            jwe.setHeader(new JwtHeader(encodedHeader));
            return jwe;
        }
        catch (Exception e) {
            throw new InvalidJweException(e);
        }
    }
}

