/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.error;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class ErrorResponse {
    private static final Logger log = Logger.getLogger(ErrorResponse.class);
    private int status;
    private String errorCode;
    private String errorDescription;
    private String errorUri;
    private String reason;
    private String state;

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public String getErrorUri() {
        return this.errorUri;
    }

    public void setErrorUri(String errorUri) {
        this.errorUri = errorUri;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String toQueryString() {
        StringBuilder queryStringBuilder = new StringBuilder();
        try {
            queryStringBuilder.append("error=").append(this.getErrorCode());
            if (this.errorDescription != null && !this.errorDescription.isEmpty()) {
                queryStringBuilder.append("&error_description=").append(URLEncoder.encode(this.errorDescription, StandardCharsets.UTF_8.name()));
            }
            if (this.errorUri != null && !this.errorUri.isEmpty()) {
                queryStringBuilder.append("&error_uri=").append(URLEncoder.encode(this.errorUri, StandardCharsets.UTF_8.name()));
            }
            if (StringUtils.isNotBlank((String)this.reason)) {
                queryStringBuilder.append("&reason=").append(URLEncoder.encode(this.reason, StandardCharsets.UTF_8.name()));
            }
            if (this.getState() != null && !this.getState().isEmpty()) {
                queryStringBuilder.append("&state=").append(this.getState());
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return queryStringBuilder.toString();
    }

    public String toJSonString() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("error", (Object)this.getErrorCode());
            if (this.errorDescription != null && !this.errorDescription.isEmpty()) {
                jsonObj.put("error_description", (Object)this.errorDescription);
            }
            if (this.errorUri != null && !this.errorUri.isEmpty()) {
                jsonObj.put("error_uri", (Object)this.errorUri);
            }
            if (StringUtils.isNotBlank((String)this.reason)) {
                jsonObj.put("reason", (Object)this.reason);
            }
            if (this.getState() != null && !this.getState().isEmpty()) {
                jsonObj.put("state", (Object)this.getState());
            }
            return jsonObj.toString(4).replace("\\/", "/");
        }
        catch (JSONException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

