/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.crypto.signature;

import io.jans.as.model.crypto.PublicKey;
import io.jans.as.model.util.Base64Util;
import java.math.BigInteger;
import org.json.JSONException;
import org.json.JSONObject;

public class RSAPublicKey
extends PublicKey {
    private BigInteger modulus;
    private BigInteger publicExponent;

    public RSAPublicKey(BigInteger modulus, BigInteger publicExponent) {
        this.modulus = modulus;
        this.publicExponent = publicExponent;
    }

    public RSAPublicKey(String modulus, String publicExponent) {
        this(new BigInteger(1, Base64Util.base64urldecode(modulus)), new BigInteger(1, Base64Util.base64urldecode(publicExponent)));
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public void setModulus(BigInteger modulus) {
        this.modulus = modulus;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public void setPublicExponent(BigInteger publicExponent) {
        this.publicExponent = publicExponent;
    }

    @Override
    public JSONObject toJSONObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("n", (Object)Base64Util.base64urlencodeUnsignedBigInt(this.modulus));
        jsonObject.put("e", (Object)Base64Util.base64urlencodeUnsignedBigInt(this.publicExponent));
        jsonObject.put("x", JSONObject.NULL);
        jsonObject.put("y", JSONObject.NULL);
        return jsonObject;
    }

    public String toString() {
        try {
            return this.toJSONObject().toString(4);
        }
        catch (Exception e) {
            return "";
        }
    }
}

