/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.crypto.signature;

import io.jans.as.model.crypto.Certificate;
import io.jans.as.model.crypto.KeyFactory;
import io.jans.as.model.crypto.signature.RSAPrivateKey;
import io.jans.as.model.crypto.signature.RSAPublicKey;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.jwk.JSONWebKey;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.GregorianCalendar;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import org.bouncycastle.x509.X509V1CertificateGenerator;

@Deprecated
public class RSAKeyFactory
extends KeyFactory<RSAPrivateKey, RSAPublicKey> {
    public static final int DEF_KEYLENGTH = 2048;
    private final RSAPrivateKey rsaPrivateKey;
    private final RSAPublicKey rsaPublicKey;
    private Certificate certificate;

    @Deprecated
    public RSAKeyFactory(SignatureAlgorithm signatureAlgorithm, String dnName) throws InvalidParameterException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidKeyException, CertificateEncodingException {
        if (signatureAlgorithm == null) {
            throw new InvalidParameterException("The signature algorithm cannot be null");
        }
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", "BC");
        keyGen.initialize(2048, new SecureRandom());
        KeyPair keyPair = keyGen.generateKeyPair();
        BCRSAPrivateCrtKey jcersaPrivateCrtKey = (BCRSAPrivateCrtKey)keyPair.getPrivate();
        BCRSAPublicKey jcersaPublicKey = (BCRSAPublicKey)keyPair.getPublic();
        this.rsaPrivateKey = new RSAPrivateKey(signatureAlgorithm, jcersaPrivateCrtKey.getModulus(), jcersaPrivateCrtKey.getPrivateExponent());
        this.rsaPublicKey = new RSAPublicKey(jcersaPublicKey.getModulus(), jcersaPublicKey.getPublicExponent());
        if (StringUtils.isNotBlank((String)dnName)) {
            GregorianCalendar startDate = new GregorianCalendar();
            GregorianCalendar expiryDate = new GregorianCalendar();
            expiryDate.add(1, 1);
            BigInteger serialNumber = new BigInteger(1024, new SecureRandom());
            X509V1CertificateGenerator certGen = new X509V1CertificateGenerator();
            X500Principal principal = new X500Principal(dnName);
            certGen.setSerialNumber(serialNumber);
            certGen.setIssuerDN(principal);
            certGen.setNotBefore(startDate.getTime());
            certGen.setNotAfter(expiryDate.getTime());
            certGen.setSubjectDN(principal);
            certGen.setPublicKey(keyPair.getPublic());
            certGen.setSignatureAlgorithm(signatureAlgorithm.getAlgorithm());
            X509Certificate x509Certificate = certGen.generate((PrivateKey)jcersaPrivateCrtKey, "BC");
            this.certificate = new Certificate(signatureAlgorithm, x509Certificate);
        }
    }

    @Deprecated
    public RSAKeyFactory(JSONWebKey key) {
        if (key == null) {
            throw new IllegalArgumentException("Key value must not be null.");
        }
        this.rsaPrivateKey = new RSAPrivateKey(null, key.getN(), key.getE());
        this.rsaPublicKey = new RSAPublicKey(key.getN(), key.getE());
        this.certificate = null;
    }

    public static RSAKeyFactory valueOf(JSONWebKey key) {
        return new RSAKeyFactory(key);
    }

    @Override
    public RSAPrivateKey getPrivateKey() {
        return this.rsaPrivateKey;
    }

    @Override
    public RSAPublicKey getPublicKey() {
        return this.rsaPublicKey;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }
}

