/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.crypto.signature;

import io.jans.as.model.crypto.Certificate;
import io.jans.as.model.crypto.KeyFactory;
import io.jans.as.model.crypto.signature.AlgorithmFamily;
import io.jans.as.model.crypto.signature.EDDSAPrivateKey;
import io.jans.as.model.crypto.signature.EDDSAPublicKey;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v1CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;
import org.bouncycastle.jcajce.spec.EdDSAParameterSpec;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.encoders.Hex;

public class EDDSAKeyFactory
extends KeyFactory<EDDSAPrivateKey, EDDSAPublicKey> {
    protected static final byte[] Ed448Prefix = Hex.decode((String)"3043300506032b6571033a00");
    protected static final byte[] Ed25519Prefix = Hex.decode((String)"302a300506032b6570032100");
    private final SignatureAlgorithm signatureAlgorithm;
    private final KeyPair keyPair;
    private final EDDSAPrivateKey eddsaPrivateKey;
    private final EDDSAPublicKey eddsaPublicKey;
    private Certificate certificate;

    public EDDSAKeyFactory(SignatureAlgorithm signatureAlgorithm, String dnName) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, OperatorCreationException, CertificateException {
        if (signatureAlgorithm == null) {
            throw new InvalidParameterException("The signature algorithm cannot be null");
        }
        if (!AlgorithmFamily.ED.equals((Object)signatureAlgorithm.getFamily())) {
            throw new InvalidParameterException("Wrong value of the family of the SignatureAlgorithm");
        }
        this.signatureAlgorithm = signatureAlgorithm;
        EdDSAParameterSpec edSpec = new EdDSAParameterSpec(signatureAlgorithm.getCurve().getName());
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(signatureAlgorithm.getName(), "BC");
        keyGen.initialize((AlgorithmParameterSpec)edSpec, new SecureRandom());
        this.keyPair = keyGen.generateKeyPair();
        BCEdDSAPrivateKey privateKey = (BCEdDSAPrivateKey)this.keyPair.getPrivate();
        BCEdDSAPublicKey publicKey = (BCEdDSAPublicKey)this.keyPair.getPublic();
        byte[] privateKeyData = privateKey.getEncoded();
        byte[] publicKeyData = publicKey.getEncoded();
        this.eddsaPrivateKey = new EDDSAPrivateKey(signatureAlgorithm, privateKeyData, publicKeyData);
        this.eddsaPublicKey = new EDDSAPublicKey(signatureAlgorithm, publicKeyData);
        if (StringUtils.isNotBlank((String)dnName)) {
            GregorianCalendar startDate = new GregorianCalendar();
            GregorianCalendar expiryDate = new GregorianCalendar();
            expiryDate.add(1, 1);
            BigInteger serialNumber = new BigInteger(1024, new SecureRandom());
            X500Name name = new X500Name(dnName);
            JcaX509v1CertificateBuilder certGen = new JcaX509v1CertificateBuilder(name, serialNumber, startDate.getTime(), expiryDate.getTime(), name, (PublicKey)publicKey);
            X509CertificateHolder certHolder = certGen.build(new JcaContentSignerBuilder(signatureAlgorithm.getAlgorithm()).setProvider("BC").build(this.keyPair.getPrivate()));
            X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
            this.certificate = new Certificate(signatureAlgorithm, cert);
        }
    }

    public Certificate generateV3Certificate(Date startDate, Date expirationDate, String dnName) throws SignatureException {
        Certificate resCertificate = null;
        try {
            BCEdDSAPublicKey publicKey = (BCEdDSAPublicKey)this.keyPair.getPublic();
            BigInteger serialNumber = new BigInteger(1024, new SecureRandom());
            X500Name name = new X500Name(dnName);
            JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(name, serialNumber, startDate, expirationDate, name, (PublicKey)publicKey);
            X509CertificateHolder certHolder = certGen.build(new JcaContentSignerBuilder(this.signatureAlgorithm.getAlgorithm()).setProvider("BC").build(this.keyPair.getPrivate()));
            X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
            resCertificate = new Certificate(this.signatureAlgorithm, cert);
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
        return resCertificate;
    }

    @Override
    public EDDSAPrivateKey getPrivateKey() {
        return this.eddsaPrivateKey;
    }

    @Override
    public EDDSAPublicKey getPublicKey() {
        return this.eddsaPublicKey;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }

    public static EDDSAPublicKey createEDDSAPublicKeyFromDecodedKey(SignatureAlgorithm signatureAlgorithm, byte[] decodedPublicKey) throws SignatureException {
        byte[] encodedPubKey = EDDSAKeyFactory.getEncodedPubKey(signatureAlgorithm, decodedPublicKey);
        return new EDDSAPublicKey(signatureAlgorithm, encodedPubKey);
    }

    public static EDDSAPrivateKey createEDDSAPrivateKeyFromDecodedKey(SignatureAlgorithm signatureAlgorithm, byte[] decodedPrivateKey, byte[] decodedPublicKey) throws SignatureException, IOException {
        byte[] encodedPubKey = EDDSAKeyFactory.getEncodedPubKey(signatureAlgorithm, decodedPublicKey);
        Ed25519PrivateKeyParameters privKeysParams = new Ed25519PrivateKeyParameters(decodedPrivateKey);
        PrivateKeyInfo privKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)privKeysParams, null);
        return new EDDSAPrivateKey(signatureAlgorithm, privKeyInfo.getEncoded(), encodedPubKey);
    }

    private static byte[] getEncodedPubKey(SignatureAlgorithm signatureAlgorithm, byte[] decodedPublicKey) throws SignatureException {
        byte[] encodedPubKey = null;
        if (signatureAlgorithm != SignatureAlgorithm.EDDSA) {
            throw new SignatureException(String.format("Wrong type of the signature algorithm (SignatureAlgorithm): %s", signatureAlgorithm.toString()));
        }
        encodedPubKey = new byte[Ed25519Prefix.length + 32];
        System.arraycopy(Ed25519Prefix, 0, encodedPubKey, 0, Ed25519Prefix.length);
        System.arraycopy(decodedPublicKey, 0, encodedPubKey, Ed25519Prefix.length, decodedPublicKey.length);
        return encodedPubKey;
    }
}

