/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.crypto.signature;

import io.jans.as.model.crypto.Certificate;
import io.jans.as.model.crypto.KeyFactory;
import io.jans.as.model.crypto.signature.ECDSAPrivateKey;
import io.jans.as.model.crypto.signature.ECDSAPublicKey;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v1CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class ECDSAKeyFactory
extends KeyFactory<ECDSAPrivateKey, ECDSAPublicKey> {
    private final SignatureAlgorithm signatureAlgorithm;
    private final KeyPair keyPair;
    private final ECDSAPrivateKey ecdsaPrivateKey;
    private final ECDSAPublicKey ecdsaPublicKey;
    private Certificate certificate;

    public ECDSAKeyFactory(SignatureAlgorithm signatureAlgorithm, String dnName) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, OperatorCreationException, CertificateException {
        if (signatureAlgorithm == null) {
            throw new InvalidParameterException("The signature algorithm cannot be null");
        }
        this.signatureAlgorithm = signatureAlgorithm;
        ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)signatureAlgorithm.getCurve().getAlias());
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("ECDSA", "BC");
        keyGen.initialize((AlgorithmParameterSpec)ecSpec, new SecureRandom());
        this.keyPair = keyGen.generateKeyPair();
        BCECPrivateKey privateKeySpec = (BCECPrivateKey)this.keyPair.getPrivate();
        BCECPublicKey publicKeySpec = (BCECPublicKey)this.keyPair.getPublic();
        BigInteger x = publicKeySpec.getQ().getXCoord().toBigInteger();
        BigInteger y = publicKeySpec.getQ().getYCoord().toBigInteger();
        BigInteger d = privateKeySpec.getD();
        this.ecdsaPrivateKey = new ECDSAPrivateKey(signatureAlgorithm, d);
        this.ecdsaPublicKey = new ECDSAPublicKey(signatureAlgorithm, x, y);
        if (StringUtils.isNotBlank((String)dnName)) {
            GregorianCalendar startDate = new GregorianCalendar();
            GregorianCalendar expiryDate = new GregorianCalendar();
            expiryDate.add(1, 1);
            BigInteger serialNumber = new BigInteger(1024, new SecureRandom());
            X500Name name = new X500Name(dnName);
            JcaX509v1CertificateBuilder certGen = new JcaX509v1CertificateBuilder(name, serialNumber, startDate.getTime(), expiryDate.getTime(), name, this.keyPair.getPublic());
            X509CertificateHolder certHolder = certGen.build(new JcaContentSignerBuilder(signatureAlgorithm.getAlgorithm()).setProvider("BC").build(this.keyPair.getPrivate()));
            X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
            this.certificate = new Certificate(signatureAlgorithm, cert);
        }
    }

    public Certificate generateV3Certificate(Date startDate, Date expirationDate, String dnName) throws OperatorCreationException, CertificateException {
        Certificate resCertificate = null;
        BCEdDSAPublicKey publicKey = (BCEdDSAPublicKey)this.keyPair.getPublic();
        BigInteger serialNumber = new BigInteger(1024, new SecureRandom());
        X500Name name = new X500Name(dnName);
        JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(name, serialNumber, startDate, expirationDate, name, (PublicKey)publicKey);
        X509CertificateHolder certHolder = certGen.build(new JcaContentSignerBuilder(this.signatureAlgorithm.getAlgorithm()).setProvider("BC").build(this.keyPair.getPrivate()));
        X509Certificate cert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certHolder);
        resCertificate = new Certificate(this.signatureAlgorithm, cert);
        return resCertificate;
    }

    @Override
    public ECDSAPrivateKey getPrivateKey() {
        return this.ecdsaPrivateKey;
    }

    @Override
    public ECDSAPublicKey getPublicKey() {
        return this.ecdsaPublicKey;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }
}

