/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.crypto;

import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.exception.CryptoProviderException;
import io.jans.as.model.jwk.Algorithm;
import io.jans.as.model.jwk.KeyOpsType;
import io.jans.eleven.client.DeleteKeyClient;
import io.jans.eleven.client.DeleteKeyRequest;
import io.jans.eleven.client.DeleteKeyResponse;
import io.jans.eleven.client.GenerateKeyClient;
import io.jans.eleven.client.GenerateKeyRequest;
import io.jans.eleven.client.GenerateKeyResponse;
import io.jans.eleven.client.SignClient;
import io.jans.eleven.client.SignRequest;
import io.jans.eleven.client.SignResponse;
import io.jans.eleven.client.VerifySignatureClient;
import io.jans.eleven.client.VerifySignatureRequest;
import io.jans.eleven.client.VerifySignatureResponse;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.json.JSONObject;

public class ElevenCryptoProvider
extends AbstractCryptoProvider {
    private final String generateKeyEndpoint;
    private final String signEndpoint;
    private final String verifySignatureEndpoint;
    private final String deleteKeyEndpoint;
    private final String accessToken;

    public ElevenCryptoProvider(String generateKeyEndpoint, String signEndpoint, String verifySignatureEndpoint, String deleteKeyEndpoint, String accessToken) {
        this.generateKeyEndpoint = generateKeyEndpoint;
        this.signEndpoint = signEndpoint;
        this.verifySignatureEndpoint = verifySignatureEndpoint;
        this.deleteKeyEndpoint = deleteKeyEndpoint;
        this.accessToken = accessToken;
    }

    @Override
    public boolean containsKey(String keyId) {
        return false;
    }

    @Override
    public JSONObject generateKey(Algorithm algorithm, Long expirationTime, int keyLength) throws CryptoProviderException {
        GenerateKeyRequest request = new GenerateKeyRequest();
        request.setSignatureAlgorithm(algorithm.toString());
        request.setExpirationTime(expirationTime);
        request.setAccessToken(this.accessToken);
        GenerateKeyClient client = new GenerateKeyClient(this.generateKeyEndpoint);
        client.setRequest(request);
        GenerateKeyResponse response = null;
        try {
            response = client.exec();
        }
        catch (Exception e) {
            throw new CryptoProviderException(e);
        }
        if (response.getStatus() == 200 && response.getKeyId() != null) {
            return response.getJSONEntity();
        }
        throw new CryptoProviderException(response.getEntity());
    }

    @Override
    public JSONObject generateKey(Algorithm algorithm, Long expirationTime, int keyLength, KeyOpsType keyOpsType) throws CryptoProviderException {
        return this.generateKey(algorithm, expirationTime, keyLength, KeyOpsType.CONNECT);
    }

    @Override
    public JSONObject generateKey(Algorithm algorithm, Long expirationTime) throws CryptoProviderException {
        return this.generateKey(algorithm, expirationTime, 2048);
    }

    @Override
    public String sign(String signingInput, String keyId, String shardSecret, SignatureAlgorithm signatureAlgorithm) throws CryptoProviderException {
        SignRequest request = new SignRequest();
        request.getSignRequestParam().setSigningInput(signingInput);
        request.getSignRequestParam().setAlias(keyId);
        request.getSignRequestParam().setSharedSecret(shardSecret);
        request.getSignRequestParam().setSignatureAlgorithm(signatureAlgorithm.getName());
        request.setAccessToken(this.accessToken);
        SignClient client = new SignClient(this.signEndpoint);
        client.setRequest(request);
        SignResponse response = null;
        try {
            response = client.exec();
        }
        catch (Exception e) {
            throw new CryptoProviderException(e);
        }
        if (response.getStatus() == 200 && response.getSignature() != null) {
            return response.getSignature();
        }
        throw new CryptoProviderException(response.getEntity());
    }

    @Override
    public boolean verifySignature(String signingInput, String encodedSignature, String keyId, JSONObject jwks, String sharedSecret, SignatureAlgorithm signatureAlgorithm) throws CryptoProviderException {
        VerifySignatureRequest request = new VerifySignatureRequest();
        request.getVerifySignatureRequestParam().setSigningInput(signingInput);
        request.getVerifySignatureRequestParam().setSignature(encodedSignature);
        request.getVerifySignatureRequestParam().setAlias(keyId);
        request.getVerifySignatureRequestParam().setSharedSecret(sharedSecret);
        request.getVerifySignatureRequestParam().setSignatureAlgorithm(signatureAlgorithm.getName());
        request.setAccessToken(this.accessToken);
        if (jwks != null) {
            request.getVerifySignatureRequestParam().setJwksRequestParam(this.getJwksRequestParam(jwks));
        }
        VerifySignatureClient client = new VerifySignatureClient(this.verifySignatureEndpoint);
        client.setRequest(request);
        VerifySignatureResponse response = null;
        try {
            response = client.exec();
        }
        catch (Exception e) {
            throw new CryptoProviderException(e);
        }
        if (response.getStatus() == 200) {
            return response.isVerified();
        }
        throw new CryptoProviderException(response.getEntity());
    }

    @Override
    public boolean deleteKey(String keyId) throws CryptoProviderException {
        DeleteKeyRequest request = new DeleteKeyRequest();
        request.setAlias(keyId);
        request.setAccessToken(this.accessToken);
        DeleteKeyClient client = new DeleteKeyClient(this.deleteKeyEndpoint);
        client.setRequest(request);
        DeleteKeyResponse response = null;
        try {
            response = client.exec();
        }
        catch (Exception e) {
            throw new CryptoProviderException(e);
        }
        if (response.getStatus() == 200) {
            return response.isDeleted();
        }
        throw new CryptoProviderException(response.getEntity());
    }

    @Override
    public PrivateKey getPrivateKey(String keyId) {
        throw new UnsupportedOperationException("Method not implemented.");
    }

    @Override
    public PublicKey getPublicKey(String keyId) {
        throw new UnsupportedOperationException("Method not implemented.");
    }
}

