/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.crypto;

import io.jans.as.model.common.WebKeyStorage;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.AuthCryptoProvider;
import io.jans.as.model.crypto.ElevenCryptoProvider;
import java.security.KeyStoreException;
import org.apache.commons.lang.StringUtils;

public class CryptoProviderFactory {
    private static AuthCryptoProvider keyStoreProvider = null;

    private CryptoProviderFactory() {
    }

    public static AbstractCryptoProvider getCryptoProvider(AppConfiguration configuration) throws KeyStoreException {
        AbstractCryptoProvider cryptoProvider = null;
        WebKeyStorage webKeyStorage = configuration.getWebKeysStorage();
        if (webKeyStorage == null) {
            return null;
        }
        if (webKeyStorage == WebKeyStorage.KEYSTORE) {
            cryptoProvider = CryptoProviderFactory.getKeyStoreProvider(configuration);
        } else if (webKeyStorage == WebKeyStorage.PKCS11) {
            cryptoProvider = new ElevenCryptoProvider(configuration.getJansElevenGenerateKeyEndpoint(), configuration.getJansElevenSignEndpoint(), configuration.getJansElevenVerifySignatureEndpoint(), configuration.getJansElevenDeleteKeyEndpoint(), configuration.getJansElevenTestModeToken());
        }
        if (cryptoProvider != null && configuration.getKeyRegenerationEnabled().booleanValue()) {
            cryptoProvider.setKeyRegenerationIntervalInDays(configuration.getKeyRegenerationInterval() / 24);
        }
        return cryptoProvider;
    }

    private static AbstractCryptoProvider getKeyStoreProvider(AppConfiguration configuration) throws KeyStoreException {
        if (keyStoreProvider != null && StringUtils.isNotBlank((String)keyStoreProvider.getKeyStoreFile()) && StringUtils.isNotBlank((String)keyStoreProvider.getKeyStoreSecret()) && StringUtils.isNotBlank((String)keyStoreProvider.getDnName()) && keyStoreProvider.getKeyStoreFile().equals(configuration.getKeyStoreFile()) && keyStoreProvider.getKeyStoreSecret().equals(configuration.getKeyStoreSecret()) && keyStoreProvider.getDnName().equals(configuration.getDnName())) {
            return keyStoreProvider;
        }
        keyStoreProvider = new AuthCryptoProvider(configuration.getKeyStoreFile(), configuration.getKeyStoreSecret(), configuration.getDnName(), configuration.getRejectJwtWithNoneAlg(), configuration.getKeySelectionStrategy());
        return keyStoreProvider;
    }

    public static void reset() {
        keyStoreProvider = null;
    }
}

