/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.crypto;

import io.jans.as.model.crypto.PublicKey;
import io.jans.as.model.crypto.signature.ECDSAPublicKey;
import io.jans.as.model.crypto.signature.EDDSAPublicKey;
import io.jans.as.model.crypto.signature.RSAPublicKey;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import java.io.StringWriter;
import java.io.Writer;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.util.Arrays;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.json.JSONArray;
import org.json.JSONException;

public class Certificate {
    private final SignatureAlgorithm signatureAlgorithm;
    private final X509Certificate x509Certificate;

    public Certificate(SignatureAlgorithm signatureAlgorithm, X509Certificate x509Certificate) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.x509Certificate = x509Certificate;
    }

    public PublicKey getPublicKey() {
        if (this.x509Certificate == null) {
            return null;
        }
        PublicKey publicKey = null;
        if (this.x509Certificate.getPublicKey() instanceof BCRSAPublicKey) {
            BCRSAPublicKey jcersaPublicKey = (BCRSAPublicKey)this.x509Certificate.getPublicKey();
            publicKey = new RSAPublicKey(jcersaPublicKey.getModulus(), jcersaPublicKey.getPublicExponent());
        } else if (this.x509Certificate.getPublicKey() instanceof BCECPublicKey) {
            BCECPublicKey jceecPublicKey = (BCECPublicKey)this.x509Certificate.getPublicKey();
            publicKey = new ECDSAPublicKey(this.signatureAlgorithm, jceecPublicKey.getQ().getXCoord().toBigInteger(), jceecPublicKey.getQ().getYCoord().toBigInteger());
        } else if (this.x509Certificate.getPublicKey() instanceof BCEdDSAPublicKey) {
            BCEdDSAPublicKey jceedPublicKey = (BCEdDSAPublicKey)this.x509Certificate.getPublicKey();
            publicKey = new EDDSAPublicKey(this.signatureAlgorithm, jceedPublicKey.getEncoded());
        }
        return publicKey;
    }

    public RSAPublicKey getRsaPublicKey() {
        if (this.x509Certificate == null) {
            return null;
        }
        RSAPublicKey rsaPublicKey = null;
        if (this.x509Certificate.getPublicKey() instanceof BCRSAPublicKey) {
            BCRSAPublicKey publicKey = (BCRSAPublicKey)this.x509Certificate.getPublicKey();
            rsaPublicKey = new RSAPublicKey(publicKey.getModulus(), publicKey.getPublicExponent());
        } else if (this.x509Certificate.getPublicKey() instanceof java.security.interfaces.RSAPublicKey) {
            java.security.interfaces.RSAPublicKey publicKey = (java.security.interfaces.RSAPublicKey)this.x509Certificate.getPublicKey();
            rsaPublicKey = new RSAPublicKey(publicKey.getModulus(), publicKey.getPublicExponent());
        }
        return rsaPublicKey;
    }

    public ECDSAPublicKey getEcdsaPublicKey() {
        if (this.x509Certificate == null) {
            return null;
        }
        ECDSAPublicKey ecdsaPublicKey = null;
        if (this.x509Certificate.getPublicKey() instanceof BCECPublicKey) {
            BCECPublicKey publicKey = (BCECPublicKey)this.x509Certificate.getPublicKey();
            ecdsaPublicKey = new ECDSAPublicKey(this.signatureAlgorithm, publicKey.getQ().getXCoord().toBigInteger(), publicKey.getQ().getYCoord().toBigInteger());
        } else if (this.x509Certificate.getPublicKey() instanceof ECPublicKey) {
            ECPublicKey publicKey = (ECPublicKey)this.x509Certificate.getPublicKey();
            ecdsaPublicKey = new ECDSAPublicKey(this.signatureAlgorithm, publicKey.getW().getAffineX(), publicKey.getW().getAffineY());
        }
        return ecdsaPublicKey;
    }

    public EDDSAPublicKey getEddsaPublicKey() {
        EDDSAPublicKey eddsaPublicKey = null;
        if (this.x509Certificate != null && this.x509Certificate.getPublicKey() instanceof BCEdDSAPublicKey) {
            BCEdDSAPublicKey publicKey = (BCEdDSAPublicKey)this.x509Certificate.getPublicKey();
            eddsaPublicKey = new EDDSAPublicKey(this.signatureAlgorithm, publicKey.getEncoded());
        }
        return eddsaPublicKey;
    }

    public JSONArray toJSONArray() throws JSONException {
        String cert = this.toString();
        cert = cert.replace("\n", "");
        cert = cert.replace("-----BEGIN CERTIFICATE-----", "");
        cert = cert.replace("-----END CERTIFICATE-----", "");
        return new JSONArray(Arrays.asList(cert));
    }

    public String toString() {
        String string;
        StringWriter stringWriter = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);
        try {
            pemWriter.writeObject((Object)this.x509Certificate);
            pemWriter.flush();
            string = stringWriter.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    pemWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return "";
            }
        }
        pemWriter.close();
        return string;
    }
}

