/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.configuration;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import io.jans.agama.model.EngineConfig;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.common.ResponseMode;
import io.jans.as.model.common.ResponseType;
import io.jans.as.model.common.SoftwareStatementValidationType;
import io.jans.as.model.common.WebKeyStorage;
import io.jans.as.model.configuration.AuthenticationFilter;
import io.jans.as.model.configuration.AuthenticationProtectionConfiguration;
import io.jans.as.model.configuration.AuthorizationRequestCustomParameter;
import io.jans.as.model.configuration.CIBAEndUserNotificationConfig;
import io.jans.as.model.configuration.ClientAuthenticationFilter;
import io.jans.as.model.configuration.Configuration;
import io.jans.as.model.configuration.CorsConfigurationFilter;
import io.jans.as.model.error.ErrorHandlingMethod;
import io.jans.as.model.jwk.KeySelectionStrategy;
import io.jans.as.model.ssa.SsaConfiguration;
import io.jans.as.model.ssa.SsaValidationConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AppConfiguration
implements Configuration {
    public static final int DEFAULT_SESSION_ID_LIFETIME = 86400;
    public static final KeySelectionStrategy DEFAULT_KEY_SELECTION_STRATEGY = KeySelectionStrategy.OLDER;
    public static final String DEFAULT_STAT_SCOPE = "jans_stat";
    private String issuer;
    private String baseEndpoint;
    private String authorizationEndpoint;
    private String tokenEndpoint;
    private String tokenRevocationEndpoint;
    private String userInfoEndpoint;
    private String clientInfoEndpoint;
    private String checkSessionIFrame;
    private String endSessionEndpoint;
    private String jwksUri;
    private String registrationEndpoint;
    private String openIdDiscoveryEndpoint;
    private String openIdConfigurationEndpoint;
    private String idGenerationEndpoint;
    private String introspectionEndpoint;
    private String parEndpoint;
    private Boolean requirePar = false;
    private String deviceAuthzEndpoint;
    private String mtlsAuthorizationEndpoint;
    private String mtlsTokenEndpoint;
    private String mtlsTokenRevocationEndpoint;
    private String mtlsUserInfoEndpoint;
    private String mtlsClientInfoEndpoint;
    private String mtlsCheckSessionIFrame;
    private String mtlsEndSessionEndpoint;
    private String mtlsJwksUri;
    private String mtlsRegistrationEndpoint;
    private String mtlsIdGenerationEndpoint;
    private String mtlsIntrospectionEndpoint;
    private String mtlsParEndpoint;
    private String mtlsDeviceAuthzEndpoint;
    private Boolean requireRequestObjectEncryption = false;
    private Boolean requirePkce = false;
    private Boolean allowAllValueForRevokeEndpoint = false;
    private int sectorIdentifierCacheLifetimeInMinutes = 1440;
    private String umaConfigurationEndpoint;
    private Boolean umaRptAsJwt = false;
    private int umaRptLifetime;
    private int umaTicketLifetime;
    private int umaPctLifetime;
    private int umaResourceLifetime;
    private Boolean umaAddScopesAutomatically;
    private Boolean umaValidateClaimToken = false;
    private Boolean umaGrantAccessIfNoPolicies = false;
    private Boolean umaRestrictResourceToAssociatedClient = false;
    private int statTimerIntervalInSeconds;
    private String statAuthorizationScope;
    private Boolean allowSpontaneousScopes;
    private int spontaneousScopeLifetime;
    private String openidSubAttribute;
    private Boolean publicSubjectIdentifierPerClientEnabled = false;
    private List<String> subjectIdentifiersPerClientSupported;
    private Set<Set<ResponseType>> responseTypesSupported;
    private Set<ResponseMode> responseModesSupported;
    private Set<GrantType> grantTypesSupported;
    private List<String> subjectTypesSupported;
    private String defaultSubjectType;
    private List<String> authorizationSigningAlgValuesSupported;
    private List<String> authorizationEncryptionAlgValuesSupported;
    private List<String> authorizationEncryptionEncValuesSupported;
    private List<String> userInfoSigningAlgValuesSupported;
    private List<String> userInfoEncryptionAlgValuesSupported;
    private List<String> userInfoEncryptionEncValuesSupported;
    private List<String> idTokenSigningAlgValuesSupported;
    private List<String> idTokenEncryptionAlgValuesSupported;
    private List<String> idTokenEncryptionEncValuesSupported;
    private List<String> accessTokenSigningAlgValuesSupported;
    private Boolean forceSignedRequestObject = false;
    private List<String> requestObjectSigningAlgValuesSupported;
    private List<String> requestObjectEncryptionAlgValuesSupported;
    private List<String> requestObjectEncryptionEncValuesSupported;
    private List<String> tokenEndpointAuthMethodsSupported;
    private List<String> tokenEndpointAuthSigningAlgValuesSupported;
    private List<String> dynamicRegistrationCustomAttributes;
    private JsonNode dynamicRegistrationDefaultCustomAttributes;
    private List<String> displayValuesSupported;
    private List<String> claimTypesSupported;
    private List<String> jwksAlgorithmsSupported;
    private String serviceDocumentation;
    private List<String> claimsLocalesSupported;
    private List<String> idTokenTokenBindingCnfValuesSupported;
    private List<String> uiLocalesSupported;
    private Boolean claimsParameterSupported;
    private Boolean requestParameterSupported;
    private Boolean requestUriParameterSupported;
    private Boolean requestUriHashVerificationEnabled;
    private Boolean requireRequestUriRegistration;
    private List<String> requestUriBlockList;
    private String opPolicyUri;
    private String opTosUri;
    private int authorizationCodeLifetime;
    private int refreshTokenLifetime;
    private int idTokenLifetime;
    private Boolean idTokenFilterClaimsBasedOnAccessToken;
    private int accessTokenLifetime;
    private int cleanServiceInterval;
    private int cleanServiceBatchChunkSize = 100;
    private Boolean keyRegenerationEnabled;
    private int keyRegenerationInterval;
    private String defaultSignatureAlgorithm;
    private String jansOpenIdConnectVersion;
    private String jansId;
    private int dynamicRegistrationExpirationTime = -1;
    private Boolean dynamicRegistrationPersistClientAuthorizations;
    private Boolean trustedClientEnabled;
    private Boolean skipAuthorizationForOpenIdScopeAndPairwiseId = false;
    private Boolean dynamicRegistrationScopesParamEnabled;
    private Boolean dynamicRegistrationPasswordGrantTypeEnabled = false;
    private List<String> dynamicRegistrationAllowedPasswordGrantScopes;
    private String dynamicRegistrationCustomObjectClass;
    private List<String> personCustomObjectClassList;
    private Boolean persistIdToken = false;
    private Boolean persistRefreshToken = true;
    private Boolean allowPostLogoutRedirectWithoutValidation = false;
    private Boolean invalidateSessionCookiesAfterAuthorizationFlow = false;
    private Boolean returnClientSecretOnRead = false;
    private Boolean rotateClientRegistrationAccessTokenOnUsage = false;
    private Boolean rejectJwtWithNoneAlg = true;
    private Boolean expirationNotificatorEnabled = false;
    private Boolean useNestedJwtDuringEncryption = true;
    private int expirationNotificatorMapSizeLimit = 100000;
    private int expirationNotificatorIntervalInSeconds = 600;
    private Boolean redirectUrisRegexEnabled = false;
    private Boolean useHighestLevelScriptIfAcrScriptNotFound;
    private Boolean authenticationFiltersEnabled;
    private Boolean clientAuthenticationFiltersEnabled;
    private Boolean clientRegDefaultToCodeFlowWithRefresh;
    private Boolean grantTypesAndResponseTypesAutofixEnabled;
    private List<AuthenticationFilter> authenticationFilters;
    private List<ClientAuthenticationFilter> clientAuthenticationFilters;
    private List<CorsConfigurationFilter> corsConfigurationFilters;
    private int sessionIdUnusedLifetime;
    private int sessionIdUnauthenticatedUnusedLifetime = 7200;
    private Boolean sessionIdPersistOnPromptNone;
    private Boolean sessionIdRequestParameterEnabled = false;
    private Boolean changeSessionIdOnAuthentication = true;
    private Boolean sessionIdPersistInCache = false;
    private Boolean includeSidInResponse = false;
    private Boolean disablePromptLogin = false;
    private Boolean disablePromptConsent = false;
    private Integer sessionIdLifetime;
    private Integer serverSessionIdLifetime = this.sessionIdLifetime = Integer.valueOf(86400);
    private String activeSessionAuthorizationScope;
    private int configurationUpdateInterval;
    private Boolean enableClientGrantTypeUpdate;
    private Set<GrantType> dynamicGrantTypeDefault;
    private String cssLocation;
    private String jsLocation;
    private String imgLocation;
    private int metricReporterInterval;
    private int metricReporterKeepDataDays;
    private String pairwiseIdType;
    private String pairwiseCalculationKey;
    private String pairwiseCalculationSalt;
    private Boolean shareSubjectIdBetweenClientsWithSameSectorId = false;
    private WebKeyStorage webKeysStorage;
    private String dnName;
    private String keyStoreFile;
    private String keyStoreSecret;
    private KeySelectionStrategy keySelectionStrategy = DEFAULT_KEY_SELECTION_STRATEGY;
    private List<String> keyAlgsAllowedForGeneration = new ArrayList<String>();
    private Boolean keySignWithSameKeyButDiffAlg;
    private String staticKid;
    private String staticDecryptionKid;
    private String jansElevenTestModeToken;
    private String jansElevenGenerateKeyEndpoint;
    private String jansElevenSignEndpoint;
    private String jansElevenVerifySignatureEndpoint;
    private String jansElevenDeleteKeyEndpoint;
    private Boolean introspectionAccessTokenMustHaveUmaProtectionScope = false;
    private Boolean introspectionAccessTokenMustHaveIntrospectionScope = false;
    private Boolean introspectionSkipAuthorization;
    private Boolean endSessionWithAccessToken;
    private String cookieDomain;
    private Boolean enabledOAuthAuditLogging;
    private Set<String> jmsBrokerURISet;
    private String jmsUserName;
    private String jmsPassword;
    private List<String> externalUriWhiteList;
    private List<String> clientWhiteList;
    private List<String> clientBlackList;
    private Boolean legacyIdTokenClaims;
    private Boolean customHeadersWithAuthorizationResponse;
    private Boolean frontChannelLogoutSessionSupported;
    private String loggingLevel;
    private String loggingLayout;
    private Boolean updateUserLastLogonTime;
    private Boolean updateClientAccessTime;
    private Boolean logClientIdOnClientAuthentication;
    private Boolean logClientNameOnClientAuthentication;
    private Boolean disableJdkLogger = true;
    private Set<AuthorizationRequestCustomParameter> authorizationRequestCustomAllowedParameters;
    private Boolean openidScopeBackwardCompatibility = false;
    private Boolean disableU2fEndpoint = false;
    private Boolean rotateDeviceSecret = false;
    private Boolean returnDeviceSecretFromAuthzEndpoint = false;
    private Boolean dcrSignatureValidationEnabled = false;
    private String dcrSignatureValidationSharedSecret;
    private String dcrSignatureValidationSoftwareStatementJwksURIClaim;
    private String dcrSignatureValidationSoftwareStatementJwksClaim;
    private String dcrSignatureValidationJwks;
    private String dcrSignatureValidationJwksUri;
    private Boolean dcrAuthorizationWithClientCredentials = false;
    private Boolean dcrAuthorizationWithMTLS = false;
    private List<String> dcrIssuers = new ArrayList<String>();
    private Boolean useLocalCache = false;
    private Boolean fapiCompatibility = false;
    private Boolean forceIdTokenHintPrecense = false;
    private Boolean rejectEndSessionIfIdTokenExpired = false;
    private Boolean allowEndSessionWithUnmatchedSid = false;
    private Boolean forceOfflineAccessScopeToEnableRefreshToken = true;
    private Boolean errorReasonEnabled = false;
    private Boolean removeRefreshTokensForClientOnLogout = true;
    private Boolean skipRefreshTokenDuringRefreshing = false;
    private Boolean refreshTokenExtendLifetimeOnRotation = false;
    private Boolean checkUserPresenceOnRefreshToken = false;
    private Boolean consentGatheringScriptBackwardCompatibility = false;
    private Boolean introspectionScriptBackwardCompatibility = false;
    private Boolean introspectionResponseScopesBackwardCompatibility = false;
    private String softwareStatementValidationType = SoftwareStatementValidationType.DEFAULT.getValue();
    private String softwareStatementValidationClaimName;
    private AuthenticationProtectionConfiguration authenticationProtectionConfiguration;
    private ErrorHandlingMethod errorHandlingMethod = ErrorHandlingMethod.REMOTE;
    private Boolean disableAuthnForMaxAgeZero;
    private Boolean keepAuthenticatorAttributesOnAcrChange = false;
    private int deviceAuthzRequestExpiresIn;
    private int deviceAuthzTokenPollInterval;
    private String deviceAuthzResponseTypeToProcessAuthz;
    private String deviceAuthzAcr;
    private String backchannelClientId;
    private String backchannelRedirectUri;
    private String backchannelAuthenticationEndpoint;
    private String backchannelDeviceRegistrationEndpoint;
    private List<String> backchannelTokenDeliveryModesSupported;
    private List<String> backchannelAuthenticationRequestSigningAlgValuesSupported;
    private Boolean backchannelUserCodeParameterSupported;
    private String backchannelBindingMessagePattern;
    private int backchannelAuthenticationResponseExpiresIn;
    private int backchannelAuthenticationResponseInterval;
    private List<String> backchannelLoginHintClaims;
    private CIBAEndUserNotificationConfig cibaEndUserNotificationConfig;
    private int backchannelRequestsProcessorJobIntervalSec;
    private int backchannelRequestsProcessorJobChunkSize;
    private int cibaGrantLifeExtraTimeSec;
    private int cibaMaxExpirationTimeAllowedSec;
    private List<String> dpopSigningAlgValuesSupported;
    private int dpopTimeframe = 5;
    private int dpopJtiCacheTime = 3600;
    private Boolean allowIdTokenWithoutImplicitGrantType;
    private int discoveryCacheLifetimeInMinutes = 60;
    private List<String> discoveryAllowedKeys;
    private List<String> discoveryDenyKeys;
    private List<String> featureFlags;
    private Boolean httpLoggingEnabled;
    private Set<String> httpLoggingExcludePaths;
    private String externalLoggerConfiguration;
    private EngineConfig agamaConfiguration;
    private List<SsaValidationConfig> dcrSsaValidationConfigs;
    private SsaConfiguration ssaConfiguration;
    private Boolean blockWebviewAuthorizationEnabled = false;
    private Map<String, String> dateFormatterPatterns = new HashMap<String, String>();
    private Boolean httpLoggingResponseBodyContent = false;

    public Map<String, String> getDateFormatterPatterns() {
        return this.dateFormatterPatterns;
    }

    public void setDateFormatterPatterns(Map<String, String> dateFormatterPatterns) {
        this.dateFormatterPatterns = dateFormatterPatterns;
    }

    public List<SsaValidationConfig> getDcrSsaValidationConfigs() {
        if (this.dcrSsaValidationConfigs == null) {
            this.dcrSsaValidationConfigs = new ArrayList<SsaValidationConfig>();
        }
        return this.dcrSsaValidationConfigs;
    }

    public Boolean getRequireRequestObjectEncryption() {
        if (this.requireRequestObjectEncryption == null) {
            this.requireRequestObjectEncryption = false;
        }
        return this.requireRequestObjectEncryption;
    }

    public void setRequireRequestObjectEncryption(Boolean requireRequestObjectEncryption) {
        this.requireRequestObjectEncryption = requireRequestObjectEncryption;
    }

    public Boolean getAllowAllValueForRevokeEndpoint() {
        if (this.allowAllValueForRevokeEndpoint == null) {
            this.allowAllValueForRevokeEndpoint = false;
        }
        return this.allowAllValueForRevokeEndpoint;
    }

    public void setAllowAllValueForRevokeEndpoint(Boolean allowAllValueForRevokeEndpoint) {
        this.allowAllValueForRevokeEndpoint = allowAllValueForRevokeEndpoint;
    }

    public Boolean getReturnDeviceSecretFromAuthzEndpoint() {
        return this.returnDeviceSecretFromAuthzEndpoint;
    }

    public void setReturnDeviceSecretFromAuthzEndpoint(Boolean returnDeviceSecretFromAuthzEndpoint) {
        this.returnDeviceSecretFromAuthzEndpoint = returnDeviceSecretFromAuthzEndpoint;
    }

    public Boolean getRotateDeviceSecret() {
        if (this.rotateDeviceSecret == null) {
            this.rotateDeviceSecret = false;
        }
        return this.rotateDeviceSecret;
    }

    public void setRotateDeviceSecret(Boolean rotateDeviceSecret) {
        this.rotateDeviceSecret = rotateDeviceSecret;
    }

    public Boolean getRequirePkce() {
        if (this.requirePkce == null) {
            this.requirePkce = false;
        }
        return this.requirePkce;
    }

    public void setRequirePkce(Boolean requirePkce) {
        this.requirePkce = requirePkce;
    }

    public Boolean getAllowIdTokenWithoutImplicitGrantType() {
        if (this.allowIdTokenWithoutImplicitGrantType == null) {
            this.allowIdTokenWithoutImplicitGrantType = false;
        }
        return this.allowIdTokenWithoutImplicitGrantType;
    }

    public void setAllowIdTokenWithoutImplicitGrantType(Boolean allowIdTokenWithoutImplicitGrantType) {
        this.allowIdTokenWithoutImplicitGrantType = allowIdTokenWithoutImplicitGrantType;
    }

    public List<String> getDiscoveryDenyKeys() {
        if (this.discoveryDenyKeys == null) {
            this.discoveryDenyKeys = new ArrayList<String>();
        }
        return this.discoveryDenyKeys;
    }

    public void setDiscoveryDenyKeys(List<String> discoveryDenyKeys) {
        this.discoveryDenyKeys = discoveryDenyKeys;
    }

    public List<String> getDiscoveryAllowedKeys() {
        if (this.discoveryAllowedKeys == null) {
            this.discoveryAllowedKeys = new ArrayList<String>();
        }
        return this.discoveryAllowedKeys;
    }

    public void setDiscoveryAllowedKeys(List<String> discoveryAllowedKeys) {
        this.discoveryAllowedKeys = discoveryAllowedKeys;
    }

    public Boolean getCheckUserPresenceOnRefreshToken() {
        if (this.checkUserPresenceOnRefreshToken == null) {
            this.checkUserPresenceOnRefreshToken = false;
        }
        return this.checkUserPresenceOnRefreshToken;
    }

    public void setCheckUserPresenceOnRefreshToken(Boolean checkUserPresenceOnRefreshToken) {
        this.checkUserPresenceOnRefreshToken = checkUserPresenceOnRefreshToken;
    }

    public boolean isFeatureEnabled(FeatureFlagType flagType) {
        Set<FeatureFlagType> flags = FeatureFlagType.from(this);
        if (flags.isEmpty()) {
            return true;
        }
        return flags.contains((Object)flagType);
    }

    public List<String> getFeatureFlags() {
        if (this.featureFlags == null) {
            this.featureFlags = new ArrayList<String>();
        }
        return this.featureFlags;
    }

    public void setFeatureFlags(List<String> featureFlags) {
        this.featureFlags = featureFlags;
    }

    public Boolean isUseNestedJwtDuringEncryption() {
        if (this.useNestedJwtDuringEncryption == null) {
            this.useNestedJwtDuringEncryption = true;
        }
        return this.useNestedJwtDuringEncryption;
    }

    public void setUseNestedJwtDuringEncryption(Boolean useNestedJwtDuringEncryption) {
        this.useNestedJwtDuringEncryption = useNestedJwtDuringEncryption;
    }

    public KeySelectionStrategy getKeySelectionStrategy() {
        if (this.keySelectionStrategy == null) {
            this.keySelectionStrategy = DEFAULT_KEY_SELECTION_STRATEGY;
        }
        return this.keySelectionStrategy;
    }

    public void setKeySelectionStrategy(KeySelectionStrategy keySelectionStrategy) {
        this.keySelectionStrategy = keySelectionStrategy;
    }

    public Boolean getKeySignWithSameKeyButDiffAlg() {
        if (this.keySignWithSameKeyButDiffAlg == null) {
            this.keySignWithSameKeyButDiffAlg = false;
        }
        return this.keySignWithSameKeyButDiffAlg;
    }

    public void setKeySignWithSameKeyButDiffAlg(Boolean keySignWithSameKeyButDiffAlg) {
        this.keySignWithSameKeyButDiffAlg = keySignWithSameKeyButDiffAlg;
    }

    public String getStaticKid() {
        return this.staticKid;
    }

    public void setStaticKid(String staticKid) {
        this.staticKid = staticKid;
    }

    public String getStaticDecryptionKid() {
        return this.staticDecryptionKid;
    }

    public void setStaticDecryptionKid(String staticDecryptionKid) {
        this.staticDecryptionKid = staticDecryptionKid;
    }

    public List<String> getKeyAlgsAllowedForGeneration() {
        if (this.keyAlgsAllowedForGeneration == null) {
            this.keyAlgsAllowedForGeneration = new ArrayList<String>();
        }
        return this.keyAlgsAllowedForGeneration;
    }

    public void setKeyAlgsAllowedForGeneration(List<String> keyAlgsAllowedForGeneration) {
        this.keyAlgsAllowedForGeneration = keyAlgsAllowedForGeneration;
    }

    public int getDiscoveryCacheLifetimeInMinutes() {
        return this.discoveryCacheLifetimeInMinutes;
    }

    public void setDiscoveryCacheLifetimeInMinutes(int discoveryCacheLifetimeInMinutes) {
        this.discoveryCacheLifetimeInMinutes = discoveryCacheLifetimeInMinutes;
    }

    public String getSoftwareStatementValidationType() {
        if (this.softwareStatementValidationType == null) {
            this.softwareStatementValidationType = SoftwareStatementValidationType.DEFAULT.getValue();
            return this.softwareStatementValidationType;
        }
        return this.softwareStatementValidationType;
    }

    public String getSoftwareStatementValidationClaimName() {
        return this.softwareStatementValidationClaimName;
    }

    public void setSoftwareStatementValidationType(String softwareStatementValidationType) {
        this.softwareStatementValidationType = softwareStatementValidationType;
    }

    public void setSoftwareStatementValidationClaimName(String softwareStatementValidationClaimName) {
        this.softwareStatementValidationClaimName = softwareStatementValidationClaimName;
    }

    public Boolean getSkipRefreshTokenDuringRefreshing() {
        if (this.skipRefreshTokenDuringRefreshing == null) {
            this.skipRefreshTokenDuringRefreshing = false;
        }
        return this.skipRefreshTokenDuringRefreshing;
    }

    public void setSkipRefreshTokenDuringRefreshing(Boolean skipRefreshTokenDuringRefreshing) {
        this.skipRefreshTokenDuringRefreshing = skipRefreshTokenDuringRefreshing;
    }

    public Boolean getRefreshTokenExtendLifetimeOnRotation() {
        if (this.refreshTokenExtendLifetimeOnRotation == null) {
            this.refreshTokenExtendLifetimeOnRotation = false;
        }
        return this.refreshTokenExtendLifetimeOnRotation;
    }

    public void setRefreshTokenExtendLifetimeOnRotation(Boolean refreshTokenExtendLifetimeOnRotation) {
        this.refreshTokenExtendLifetimeOnRotation = refreshTokenExtendLifetimeOnRotation;
    }

    public int getSectorIdentifierCacheLifetimeInMinutes() {
        return this.sectorIdentifierCacheLifetimeInMinutes;
    }

    public void setSectorIdentifierCacheLifetimeInMinutes(int sectorIdentifierCacheLifetimeInMinutes) {
        this.sectorIdentifierCacheLifetimeInMinutes = sectorIdentifierCacheLifetimeInMinutes;
    }

    public Boolean getExpirationNotificatorEnabled() {
        if (this.expirationNotificatorEnabled == null) {
            this.expirationNotificatorEnabled = false;
        }
        return this.expirationNotificatorEnabled;
    }

    public void setExpirationNotificatorEnabled(Boolean expirationNotificatorEnabled) {
        this.expirationNotificatorEnabled = expirationNotificatorEnabled;
    }

    public int getExpirationNotificatorMapSizeLimit() {
        if (this.expirationNotificatorMapSizeLimit == 0) {
            this.expirationNotificatorMapSizeLimit = 100000;
        }
        return this.expirationNotificatorMapSizeLimit;
    }

    public void setExpirationNotificatorMapSizeLimit(int expirationNotificatorMapSizeLimit) {
        this.expirationNotificatorMapSizeLimit = expirationNotificatorMapSizeLimit;
    }

    public int getExpirationNotificatorIntervalInSeconds() {
        return this.expirationNotificatorIntervalInSeconds;
    }

    public void setExpirationNotificatorIntervalInSeconds(int expirationNotificatorIntervalInSeconds) {
        this.expirationNotificatorIntervalInSeconds = expirationNotificatorIntervalInSeconds;
    }

    public Boolean getRejectJwtWithNoneAlg() {
        if (this.rejectJwtWithNoneAlg == null) {
            this.rejectJwtWithNoneAlg = true;
        }
        return this.rejectJwtWithNoneAlg;
    }

    public void setRejectJwtWithNoneAlg(Boolean rejectJwtWithNoneAlg) {
        this.rejectJwtWithNoneAlg = rejectJwtWithNoneAlg;
    }

    public Boolean getIntrospectionScriptBackwardCompatibility() {
        if (this.introspectionScriptBackwardCompatibility == null) {
            this.introspectionScriptBackwardCompatibility = false;
        }
        return this.introspectionScriptBackwardCompatibility;
    }

    public void setIntrospectionScriptBackwardCompatibility(Boolean introspectionScriptBackwardCompatibility) {
        this.introspectionScriptBackwardCompatibility = introspectionScriptBackwardCompatibility;
    }

    public Boolean getIntrospectionResponseScopesBackwardCompatibility() {
        if (this.introspectionResponseScopesBackwardCompatibility == null) {
            this.introspectionResponseScopesBackwardCompatibility = false;
        }
        return this.introspectionScriptBackwardCompatibility;
    }

    public void setIntrospectionResponseScopesBackwardCompatibility(Boolean introspectionResponseScopesBackwardCompatibility) {
        this.introspectionResponseScopesBackwardCompatibility = introspectionResponseScopesBackwardCompatibility;
    }

    public Boolean getConsentGatheringScriptBackwardCompatibility() {
        if (this.consentGatheringScriptBackwardCompatibility == null) {
            this.consentGatheringScriptBackwardCompatibility = false;
        }
        return this.consentGatheringScriptBackwardCompatibility;
    }

    public void setConsentGatheringScriptBackwardCompatibility(Boolean consentGatheringScriptBackwardCompatibility) {
        this.consentGatheringScriptBackwardCompatibility = consentGatheringScriptBackwardCompatibility;
    }

    public Boolean getErrorReasonEnabled() {
        if (this.errorReasonEnabled == null) {
            this.errorReasonEnabled = false;
        }
        return this.errorReasonEnabled;
    }

    public void setErrorReasonEnabled(Boolean errorReasonEnabled) {
        this.errorReasonEnabled = errorReasonEnabled;
    }

    public Boolean getForceOfflineAccessScopeToEnableRefreshToken() {
        if (this.forceOfflineAccessScopeToEnableRefreshToken == null) {
            this.forceOfflineAccessScopeToEnableRefreshToken = true;
        }
        return this.forceOfflineAccessScopeToEnableRefreshToken;
    }

    public void setForceOfflineAccessScopeToEnableRefreshToken(Boolean forceOfflineAccessScopeToEnableRefreshToken) {
        this.forceOfflineAccessScopeToEnableRefreshToken = forceOfflineAccessScopeToEnableRefreshToken;
    }

    public Boolean getDisablePromptLogin() {
        if (this.disablePromptLogin == null) {
            this.disablePromptLogin = false;
        }
        return this.disablePromptLogin;
    }

    public void setDisablePromptLogin(Boolean disablePromptLogin) {
        this.disablePromptLogin = disablePromptLogin;
    }

    public Boolean getDisablePromptConsent() {
        if (this.disablePromptConsent == null) {
            this.disablePromptConsent = false;
        }
        return this.disablePromptConsent;
    }

    public void setDisablePromptConsent(Boolean disablePromptConsent) {
        this.disablePromptConsent = disablePromptConsent;
    }

    public Boolean getIncludeSidInResponse() {
        if (this.includeSidInResponse == null) {
            this.includeSidInResponse = false;
        }
        return this.includeSidInResponse;
    }

    public void setIncludeSidInResponse(Boolean includeSidInResponse) {
        this.includeSidInResponse = includeSidInResponse;
    }

    public Boolean getSessionIdPersistInCache() {
        if (this.sessionIdPersistInCache == null) {
            this.sessionIdPersistInCache = false;
        }
        return this.sessionIdPersistInCache;
    }

    public void setSessionIdPersistInCache(Boolean sessionIdPersistInCache) {
        this.sessionIdPersistInCache = sessionIdPersistInCache;
    }

    public Boolean getChangeSessionIdOnAuthentication() {
        if (this.changeSessionIdOnAuthentication == null) {
            this.changeSessionIdOnAuthentication = true;
        }
        return this.changeSessionIdOnAuthentication;
    }

    public void setChangeSessionIdOnAuthentication(Boolean changeSessionIdOnAuthentication) {
        this.changeSessionIdOnAuthentication = changeSessionIdOnAuthentication;
    }

    public Boolean getRotateClientRegistrationAccessTokenOnUsage() {
        if (this.rotateClientRegistrationAccessTokenOnUsage == null) {
            this.rotateClientRegistrationAccessTokenOnUsage = false;
        }
        return this.rotateClientRegistrationAccessTokenOnUsage;
    }

    public void setRotateClientRegistrationAccessTokenOnUsage(Boolean rotateClientRegistrationAccessTokenOnUsage) {
        this.rotateClientRegistrationAccessTokenOnUsage = rotateClientRegistrationAccessTokenOnUsage;
    }

    public Boolean getReturnClientSecretOnRead() {
        if (this.returnClientSecretOnRead == null) {
            this.returnClientSecretOnRead = false;
        }
        return this.returnClientSecretOnRead;
    }

    public void setReturnClientSecretOnRead(Boolean returnClientSecretOnRead) {
        this.returnClientSecretOnRead = returnClientSecretOnRead;
    }

    public boolean isFapi() {
        return Boolean.TRUE.equals(this.getFapiCompatibility());
    }

    public Boolean getFapiCompatibility() {
        if (this.fapiCompatibility == null) {
            this.fapiCompatibility = false;
        }
        return this.fapiCompatibility;
    }

    public void setFapiCompatibility(Boolean fapiCompatibility) {
        this.fapiCompatibility = fapiCompatibility;
    }

    public Boolean getDcrAuthorizationWithClientCredentials() {
        if (this.dcrAuthorizationWithClientCredentials == null) {
            this.dcrAuthorizationWithClientCredentials = false;
        }
        return this.dcrAuthorizationWithClientCredentials;
    }

    public void setDcrAuthorizationWithClientCredentials(Boolean dcrAuthorizationWithClientCredentials) {
        this.dcrAuthorizationWithClientCredentials = dcrAuthorizationWithClientCredentials;
    }

    public String getDcrSignatureValidationSharedSecret() {
        return this.dcrSignatureValidationSharedSecret;
    }

    public void setDcrSignatureValidationSharedSecret(String dcrSignatureValidationSharedSecret) {
        this.dcrSignatureValidationSharedSecret = dcrSignatureValidationSharedSecret;
    }

    public Boolean getDcrSignatureValidationEnabled() {
        if (this.dcrSignatureValidationEnabled == null) {
            this.dcrSignatureValidationEnabled = false;
        }
        return this.dcrSignatureValidationEnabled;
    }

    public void setDcrSignatureValidationEnabled(Boolean dcrSignatureValidationEnabled) {
        this.dcrSignatureValidationEnabled = dcrSignatureValidationEnabled;
    }

    public String getDcrSignatureValidationSoftwareStatementJwksURIClaim() {
        return this.dcrSignatureValidationSoftwareStatementJwksURIClaim;
    }

    public void setDcrSignatureValidationSoftwareStatementJwksURIClaim(String dcrSignatureValidationSoftwareStatementJwksURIClaim) {
        this.dcrSignatureValidationSoftwareStatementJwksURIClaim = dcrSignatureValidationSoftwareStatementJwksURIClaim;
    }

    public String getDcrSignatureValidationSoftwareStatementJwksClaim() {
        return this.dcrSignatureValidationSoftwareStatementJwksClaim;
    }

    public void setDcrSignatureValidationSoftwareStatementJwksClaim(String dcrSignatureValidationSoftwareStatementJwksClaim) {
        this.dcrSignatureValidationSoftwareStatementJwksClaim = dcrSignatureValidationSoftwareStatementJwksClaim;
    }

    public String getDcrSignatureValidationJwks() {
        return this.dcrSignatureValidationJwks;
    }

    public void setDcrSignatureValidationJwks(String dcrSignatureValidationJwks) {
        this.dcrSignatureValidationJwks = dcrSignatureValidationJwks;
    }

    public String getDcrSignatureValidationJwksUri() {
        return this.dcrSignatureValidationJwksUri;
    }

    public void setDcrSignatureValidationJwksUri(String dcrSignatureValidationJwksUri) {
        this.dcrSignatureValidationJwksUri = dcrSignatureValidationJwksUri;
    }

    public Boolean getDcrAuthorizationWithMTLS() {
        if (this.dcrAuthorizationWithMTLS == null) {
            this.dcrAuthorizationWithMTLS = false;
        }
        return this.dcrAuthorizationWithMTLS;
    }

    public void setDcrAuthorizationWithMTLS(Boolean dcrAuthorizationWithMTLS) {
        this.dcrAuthorizationWithMTLS = dcrAuthorizationWithMTLS;
    }

    public List<String> getDcrIssuers() {
        if (this.dcrIssuers == null) {
            this.dcrIssuers = new ArrayList<String>();
        }
        return this.dcrIssuers;
    }

    public void setDcrIssuers(List<String> dcrIssuers) {
        this.dcrIssuers = dcrIssuers;
    }

    public Boolean getForceIdTokenHintPrecense() {
        if (this.forceIdTokenHintPrecense == null) {
            this.forceIdTokenHintPrecense = false;
        }
        return this.forceIdTokenHintPrecense;
    }

    public void setForceIdTokenHintPrecense(Boolean forceIdTokenHintPrecense) {
        this.forceIdTokenHintPrecense = forceIdTokenHintPrecense;
    }

    public Boolean getRejectEndSessionIfIdTokenExpired() {
        return this.rejectEndSessionIfIdTokenExpired;
    }

    public void setRejectEndSessionIfIdTokenExpired(Boolean rejectEndSessionIfIdTokenExpired) {
        this.rejectEndSessionIfIdTokenExpired = rejectEndSessionIfIdTokenExpired;
    }

    public Boolean getAllowEndSessionWithUnmatchedSid() {
        return this.allowEndSessionWithUnmatchedSid;
    }

    public void setAllowEndSessionWithUnmatchedSid(Boolean allowEndSessionWithUnmatchedSid) {
        this.allowEndSessionWithUnmatchedSid = allowEndSessionWithUnmatchedSid;
    }

    public Boolean getRemoveRefreshTokensForClientOnLogout() {
        if (this.removeRefreshTokensForClientOnLogout == null) {
            this.removeRefreshTokensForClientOnLogout = true;
        }
        return this.removeRefreshTokensForClientOnLogout;
    }

    public void setRemoveRefreshTokensForClientOnLogout(Boolean removeRefreshTokensForClientOnLogout) {
        this.removeRefreshTokensForClientOnLogout = removeRefreshTokensForClientOnLogout;
    }

    public Boolean getDisableJdkLogger() {
        return this.disableJdkLogger;
    }

    public void setDisableJdkLogger(Boolean disableJdkLogger) {
        this.disableJdkLogger = disableJdkLogger;
    }

    public Boolean getFrontChannelLogoutSessionSupported() {
        return this.frontChannelLogoutSessionSupported;
    }

    public void setFrontChannelLogoutSessionSupported(Boolean frontChannelLogoutSessionSupported) {
        this.frontChannelLogoutSessionSupported = frontChannelLogoutSessionSupported;
    }

    public Boolean getIntrospectionAccessTokenMustHaveIntrospectionScope() {
        if (this.introspectionAccessTokenMustHaveIntrospectionScope == null) {
            this.introspectionAccessTokenMustHaveIntrospectionScope = false;
        }
        return this.introspectionAccessTokenMustHaveIntrospectionScope;
    }

    public void setIntrospectionAccessTokenMustHaveIntrospectionScope(Boolean introspectionAccessTokenMustHaveIntrospectionScope) {
        this.introspectionAccessTokenMustHaveIntrospectionScope = introspectionAccessTokenMustHaveIntrospectionScope;
    }

    public Boolean getIntrospectionAccessTokenMustHaveUmaProtectionScope() {
        return this.introspectionAccessTokenMustHaveUmaProtectionScope;
    }

    public void setIntrospectionAccessTokenMustHaveUmaProtectionScope(Boolean introspectionAccessTokenMustHaveUmaProtectionScope) {
        this.introspectionAccessTokenMustHaveUmaProtectionScope = introspectionAccessTokenMustHaveUmaProtectionScope;
    }

    public Boolean getIntrospectionSkipAuthorization() {
        if (this.introspectionSkipAuthorization == null) {
            this.introspectionSkipAuthorization = false;
        }
        return this.introspectionSkipAuthorization;
    }

    public void setIntrospectionSkipAuthorization(Boolean introspectionSkipAuthorization) {
        this.introspectionSkipAuthorization = introspectionSkipAuthorization;
    }

    public Boolean getUmaRptAsJwt() {
        return this.umaRptAsJwt;
    }

    public void setUmaRptAsJwt(Boolean umaRptAsJwt) {
        this.umaRptAsJwt = umaRptAsJwt;
    }

    public Boolean getUmaAddScopesAutomatically() {
        return this.umaAddScopesAutomatically;
    }

    public void setUmaAddScopesAutomatically(Boolean umaAddScopesAutomatically) {
        this.umaAddScopesAutomatically = umaAddScopesAutomatically;
    }

    public Boolean getUmaValidateClaimToken() {
        return this.umaValidateClaimToken;
    }

    public void setUmaValidateClaimToken(Boolean umaValidateClaimToken) {
        this.umaValidateClaimToken = umaValidateClaimToken;
    }

    public Boolean getUmaGrantAccessIfNoPolicies() {
        return this.umaGrantAccessIfNoPolicies;
    }

    public void setUmaGrantAccessIfNoPolicies(Boolean umaGrantAccessIfNoPolicies) {
        this.umaGrantAccessIfNoPolicies = umaGrantAccessIfNoPolicies;
    }

    public Boolean getUmaRestrictResourceToAssociatedClient() {
        return this.umaRestrictResourceToAssociatedClient;
    }

    public void setUmaRestrictResourceToAssociatedClient(Boolean umaRestrictResourceToAssociatedClient) {
        this.umaRestrictResourceToAssociatedClient = umaRestrictResourceToAssociatedClient;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getBaseEndpoint() {
        return this.baseEndpoint;
    }

    public void setBaseEndpoint(String baseEndpoint) {
        this.baseEndpoint = baseEndpoint;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public String getTokenRevocationEndpoint() {
        return this.tokenRevocationEndpoint;
    }

    public void setTokenRevocationEndpoint(String tokenRevocationEndpoint) {
        this.tokenRevocationEndpoint = tokenRevocationEndpoint;
    }

    public String getUserInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public void setUserInfoEndpoint(String userInfoEndpoint) {
        this.userInfoEndpoint = userInfoEndpoint;
    }

    public String getClientInfoEndpoint() {
        return this.clientInfoEndpoint;
    }

    public void setClientInfoEndpoint(String clientInfoEndpoint) {
        this.clientInfoEndpoint = clientInfoEndpoint;
    }

    public String getCheckSessionIFrame() {
        return this.checkSessionIFrame;
    }

    public void setCheckSessionIFrame(String checkSessionIFrame) {
        this.checkSessionIFrame = checkSessionIFrame;
    }

    public String getEndSessionEndpoint() {
        return this.endSessionEndpoint;
    }

    public void setEndSessionEndpoint(String endSessionEndpoint) {
        this.endSessionEndpoint = endSessionEndpoint;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public String getRegistrationEndpoint() {
        return this.registrationEndpoint;
    }

    public void setRegistrationEndpoint(String registrationEndpoint) {
        this.registrationEndpoint = registrationEndpoint;
    }

    public String getOpenIdDiscoveryEndpoint() {
        return this.openIdDiscoveryEndpoint;
    }

    public void setOpenIdDiscoveryEndpoint(String openIdDiscoveryEndpoint) {
        this.openIdDiscoveryEndpoint = openIdDiscoveryEndpoint;
    }

    public String getUmaConfigurationEndpoint() {
        return this.umaConfigurationEndpoint;
    }

    public void setUmaConfigurationEndpoint(String umaConfigurationEndpoint) {
        this.umaConfigurationEndpoint = umaConfigurationEndpoint;
    }

    public String getOpenidSubAttribute() {
        return this.openidSubAttribute;
    }

    public void setOpenidSubAttribute(String openidSubAttribute) {
        this.openidSubAttribute = openidSubAttribute;
    }

    public Boolean getPublicSubjectIdentifierPerClientEnabled() {
        if (this.publicSubjectIdentifierPerClientEnabled == null) {
            this.publicSubjectIdentifierPerClientEnabled = false;
        }
        return this.publicSubjectIdentifierPerClientEnabled;
    }

    public void setPublicSubjectIdentifierPerClientEnabled(Boolean publicSubjectIdentifierPerClientEnabled) {
        this.publicSubjectIdentifierPerClientEnabled = publicSubjectIdentifierPerClientEnabled;
    }

    public List<String> getSubjectIdentifiersPerClientSupported() {
        if (this.subjectIdentifiersPerClientSupported == null) {
            this.subjectIdentifiersPerClientSupported = new ArrayList<String>();
        }
        return this.subjectIdentifiersPerClientSupported;
    }

    public void setSubjectIdentifiersPerClientSupported(List<String> subjectIdentifiersPerClientSupported) {
        this.subjectIdentifiersPerClientSupported = subjectIdentifiersPerClientSupported;
    }

    public String getIdGenerationEndpoint() {
        return this.idGenerationEndpoint;
    }

    public void setIdGenerationEndpoint(String idGenerationEndpoint) {
        this.idGenerationEndpoint = idGenerationEndpoint;
    }

    public String getIntrospectionEndpoint() {
        return this.introspectionEndpoint;
    }

    public void setIntrospectionEndpoint(String introspectionEndpoint) {
        this.introspectionEndpoint = introspectionEndpoint;
    }

    public String getParEndpoint() {
        return this.parEndpoint;
    }

    public void setParEndpoint(String parEndpoint) {
        this.parEndpoint = parEndpoint;
    }

    public Boolean getRequirePar() {
        if (this.requirePar == null) {
            this.requirePar = false;
        }
        return this.requirePar;
    }

    public void setRequirePar(Boolean requirePar) {
        this.requirePar = requirePar;
    }

    public String getOpenIdConfigurationEndpoint() {
        return this.openIdConfigurationEndpoint;
    }

    public void setOpenIdConfigurationEndpoint(String openIdConfigurationEndpoint) {
        this.openIdConfigurationEndpoint = openIdConfigurationEndpoint;
    }

    public Set<Set<ResponseType>> getResponseTypesSupported() {
        return this.responseTypesSupported;
    }

    public Set<ResponseType> getAllResponseTypesSupported() {
        HashSet<ResponseType> types = new HashSet<ResponseType>();
        if (this.responseTypesSupported != null) {
            for (Set<ResponseType> set : this.responseTypesSupported) {
                types.addAll(set);
            }
        }
        return types;
    }

    public void setResponseTypesSupported(Set<Set<ResponseType>> responseTypesSupported) {
        this.responseTypesSupported = responseTypesSupported;
    }

    public Set<ResponseMode> getResponseModesSupported() {
        return this.responseModesSupported;
    }

    public void setResponseModesSupported(Set<ResponseMode> responseModesSupported) {
        this.responseModesSupported = responseModesSupported;
    }

    public Set<GrantType> getGrantTypesSupported() {
        return this.grantTypesSupported;
    }

    public void setGrantTypesSupported(Set<GrantType> grantTypesSupported) {
        this.grantTypesSupported = grantTypesSupported;
    }

    public List<String> getSubjectTypesSupported() {
        return this.subjectTypesSupported;
    }

    public void setSubjectTypesSupported(List<String> subjectTypesSupported) {
        this.subjectTypesSupported = subjectTypesSupported;
    }

    public String getDefaultSubjectType() {
        return this.defaultSubjectType;
    }

    public void setDefaultSubjectType(String defaultSubjectType) {
        this.defaultSubjectType = defaultSubjectType;
    }

    public List<String> getAuthorizationSigningAlgValuesSupported() {
        return this.authorizationSigningAlgValuesSupported;
    }

    public void setAuthorizationSigningAlgValuesSupported(List<String> authorizationSigningAlgValuesSupported) {
        this.authorizationSigningAlgValuesSupported = authorizationSigningAlgValuesSupported;
    }

    public List<String> getAuthorizationEncryptionAlgValuesSupported() {
        return this.authorizationEncryptionAlgValuesSupported;
    }

    public void setAuthorizationEncryptionAlgValuesSupported(List<String> authorizationEncryptionAlgValuesSupported) {
        this.authorizationEncryptionAlgValuesSupported = authorizationEncryptionAlgValuesSupported;
    }

    public List<String> getAuthorizationEncryptionEncValuesSupported() {
        return this.authorizationEncryptionEncValuesSupported;
    }

    public void setAuthorizationEncryptionEncValuesSupported(List<String> authorizationEncryptionEncValuesSupported) {
        this.authorizationEncryptionEncValuesSupported = authorizationEncryptionEncValuesSupported;
    }

    public List<String> getUserInfoSigningAlgValuesSupported() {
        return this.userInfoSigningAlgValuesSupported;
    }

    public void setUserInfoSigningAlgValuesSupported(List<String> userInfoSigningAlgValuesSupported) {
        this.userInfoSigningAlgValuesSupported = userInfoSigningAlgValuesSupported;
    }

    public List<String> getUserInfoEncryptionAlgValuesSupported() {
        return this.userInfoEncryptionAlgValuesSupported;
    }

    public void setUserInfoEncryptionAlgValuesSupported(List<String> userInfoEncryptionAlgValuesSupported) {
        this.userInfoEncryptionAlgValuesSupported = userInfoEncryptionAlgValuesSupported;
    }

    public int getStatTimerIntervalInSeconds() {
        return this.statTimerIntervalInSeconds;
    }

    public void setStatTimerIntervalInSeconds(int statTimerIntervalInSeconds) {
        this.statTimerIntervalInSeconds = statTimerIntervalInSeconds;
    }

    public String getStatAuthorizationScope() {
        if (this.statAuthorizationScope == null) {
            this.statAuthorizationScope = DEFAULT_STAT_SCOPE;
        }
        return this.statAuthorizationScope;
    }

    public void setStatAuthorizationScope(String statAuthorizationScope) {
        this.statAuthorizationScope = statAuthorizationScope;
    }

    public List<String> getUserInfoEncryptionEncValuesSupported() {
        return this.userInfoEncryptionEncValuesSupported;
    }

    public void setUserInfoEncryptionEncValuesSupported(List<String> userInfoEncryptionEncValuesSupported) {
        this.userInfoEncryptionEncValuesSupported = userInfoEncryptionEncValuesSupported;
    }

    public List<String> getIdTokenSigningAlgValuesSupported() {
        return this.idTokenSigningAlgValuesSupported;
    }

    public void setIdTokenSigningAlgValuesSupported(List<String> idTokenSigningAlgValuesSupported) {
        this.idTokenSigningAlgValuesSupported = idTokenSigningAlgValuesSupported;
    }

    public List<String> getIdTokenEncryptionAlgValuesSupported() {
        return this.idTokenEncryptionAlgValuesSupported;
    }

    public void setIdTokenEncryptionAlgValuesSupported(List<String> idTokenEncryptionAlgValuesSupported) {
        this.idTokenEncryptionAlgValuesSupported = idTokenEncryptionAlgValuesSupported;
    }

    public List<String> getIdTokenEncryptionEncValuesSupported() {
        return this.idTokenEncryptionEncValuesSupported;
    }

    public void setIdTokenEncryptionEncValuesSupported(List<String> idTokenEncryptionEncValuesSupported) {
        this.idTokenEncryptionEncValuesSupported = idTokenEncryptionEncValuesSupported;
    }

    public List<String> getAccessTokenSigningAlgValuesSupported() {
        return this.accessTokenSigningAlgValuesSupported;
    }

    public void setAccessTokenSigningAlgValuesSupported(List<String> accessTokenSigningAlgValuesSupported) {
        this.accessTokenSigningAlgValuesSupported = accessTokenSigningAlgValuesSupported;
    }

    public Boolean getForceSignedRequestObject() {
        if (this.forceSignedRequestObject == null) {
            return false;
        }
        return this.forceSignedRequestObject;
    }

    public void setForceSignedRequestObject(Boolean forceSignedRequestObject) {
        this.forceSignedRequestObject = forceSignedRequestObject;
    }

    public List<String> getRequestObjectSigningAlgValuesSupported() {
        return this.requestObjectSigningAlgValuesSupported;
    }

    public void setRequestObjectSigningAlgValuesSupported(List<String> requestObjectSigningAlgValuesSupported) {
        this.requestObjectSigningAlgValuesSupported = requestObjectSigningAlgValuesSupported;
    }

    public List<String> getRequestObjectEncryptionAlgValuesSupported() {
        return this.requestObjectEncryptionAlgValuesSupported;
    }

    public void setRequestObjectEncryptionAlgValuesSupported(List<String> requestObjectEncryptionAlgValuesSupported) {
        this.requestObjectEncryptionAlgValuesSupported = requestObjectEncryptionAlgValuesSupported;
    }

    public List<String> getRequestObjectEncryptionEncValuesSupported() {
        return this.requestObjectEncryptionEncValuesSupported;
    }

    public void setRequestObjectEncryptionEncValuesSupported(List<String> requestObjectEncryptionEncValuesSupported) {
        this.requestObjectEncryptionEncValuesSupported = requestObjectEncryptionEncValuesSupported;
    }

    public List<String> getTokenEndpointAuthMethodsSupported() {
        return this.tokenEndpointAuthMethodsSupported;
    }

    public void setTokenEndpointAuthMethodsSupported(List<String> tokenEndpointAuthMethodsSupported) {
        this.tokenEndpointAuthMethodsSupported = tokenEndpointAuthMethodsSupported;
    }

    public List<String> getTokenEndpointAuthSigningAlgValuesSupported() {
        return this.tokenEndpointAuthSigningAlgValuesSupported;
    }

    public void setTokenEndpointAuthSigningAlgValuesSupported(List<String> tokenEndpointAuthSigningAlgValuesSupported) {
        this.tokenEndpointAuthSigningAlgValuesSupported = tokenEndpointAuthSigningAlgValuesSupported;
    }

    public JsonNode getDynamicRegistrationDefaultCustomAttributes() {
        return this.dynamicRegistrationDefaultCustomAttributes;
    }

    public void setDynamicRegistrationDefaultCustomAttributes(JsonNode dynamicRegistrationDefaultCustomAttributes) {
        this.dynamicRegistrationDefaultCustomAttributes = dynamicRegistrationDefaultCustomAttributes;
    }

    public List<String> getDynamicRegistrationCustomAttributes() {
        return this.dynamicRegistrationCustomAttributes;
    }

    public void setDynamicRegistrationCustomAttributes(List<String> dynamicRegistrationCustomAttributes) {
        this.dynamicRegistrationCustomAttributes = dynamicRegistrationCustomAttributes;
    }

    public List<String> getDisplayValuesSupported() {
        return this.displayValuesSupported;
    }

    public void setDisplayValuesSupported(List<String> displayValuesSupported) {
        this.displayValuesSupported = displayValuesSupported;
    }

    public List<String> getClaimTypesSupported() {
        return this.claimTypesSupported;
    }

    public void setClaimTypesSupported(List<String> claimTypesSupported) {
        this.claimTypesSupported = claimTypesSupported;
    }

    public List<String> getJwksAlgorithmsSupported() {
        return this.jwksAlgorithmsSupported;
    }

    public void setJwksAlgorithmsSupported(List<String> jwksAlgorithmsSupported) {
        this.jwksAlgorithmsSupported = jwksAlgorithmsSupported;
    }

    public String getServiceDocumentation() {
        return this.serviceDocumentation;
    }

    public void setServiceDocumentation(String serviceDocumentation) {
        this.serviceDocumentation = serviceDocumentation;
    }

    public List<String> getClaimsLocalesSupported() {
        return this.claimsLocalesSupported;
    }

    public void setClaimsLocalesSupported(List<String> claimsLocalesSupported) {
        this.claimsLocalesSupported = claimsLocalesSupported;
    }

    public List<String> getIdTokenTokenBindingCnfValuesSupported() {
        if (this.idTokenTokenBindingCnfValuesSupported == null) {
            this.idTokenTokenBindingCnfValuesSupported = new ArrayList<String>();
        }
        return this.idTokenTokenBindingCnfValuesSupported;
    }

    public void setIdTokenTokenBindingCnfValuesSupported(List<String> idTokenTokenBindingCnfValuesSupported) {
        this.idTokenTokenBindingCnfValuesSupported = idTokenTokenBindingCnfValuesSupported;
    }

    public List<String> getUiLocalesSupported() {
        return this.uiLocalesSupported;
    }

    public void setUiLocalesSupported(List<String> uiLocalesSupported) {
        this.uiLocalesSupported = uiLocalesSupported;
    }

    public Boolean getClaimsParameterSupported() {
        return this.claimsParameterSupported;
    }

    public void setClaimsParameterSupported(Boolean claimsParameterSupported) {
        this.claimsParameterSupported = claimsParameterSupported;
    }

    public Boolean getRequestParameterSupported() {
        return this.requestParameterSupported;
    }

    public void setRequestParameterSupported(Boolean requestParameterSupported) {
        this.requestParameterSupported = requestParameterSupported;
    }

    public Boolean getRequestUriParameterSupported() {
        return this.requestUriParameterSupported;
    }

    public void setRequestUriParameterSupported(Boolean requestUriParameterSupported) {
        this.requestUriParameterSupported = requestUriParameterSupported;
    }

    public Boolean getRequireRequestUriRegistration() {
        return this.requireRequestUriRegistration;
    }

    public void setRequireRequestUriRegistration(Boolean requireRequestUriRegistration) {
        this.requireRequestUriRegistration = requireRequestUriRegistration;
    }

    public List<String> getRequestUriBlockList() {
        if (this.requestUriBlockList == null) {
            this.requestUriBlockList = Lists.newArrayList();
        }
        return this.requestUriBlockList;
    }

    public void setRequestUriBlockList(List<String> requestUriBlockList) {
        this.requestUriBlockList = requestUriBlockList;
    }

    public String getOpPolicyUri() {
        return this.opPolicyUri;
    }

    public void setOpPolicyUri(String opPolicyUri) {
        this.opPolicyUri = opPolicyUri;
    }

    public String getOpTosUri() {
        return this.opTosUri;
    }

    public void setOpTosUri(String opTosUri) {
        this.opTosUri = opTosUri;
    }

    public int getAuthorizationCodeLifetime() {
        return this.authorizationCodeLifetime;
    }

    public void setAuthorizationCodeLifetime(int authorizationCodeLifetime) {
        this.authorizationCodeLifetime = authorizationCodeLifetime;
    }

    public int getRefreshTokenLifetime() {
        return this.refreshTokenLifetime;
    }

    public void setRefreshTokenLifetime(int refreshTokenLifetime) {
        this.refreshTokenLifetime = refreshTokenLifetime;
    }

    public int getIdTokenLifetime() {
        return this.idTokenLifetime;
    }

    public void setIdTokenLifetime(int idTokenLifetime) {
        this.idTokenLifetime = idTokenLifetime;
    }

    public int getAccessTokenLifetime() {
        return this.accessTokenLifetime;
    }

    public void setAccessTokenLifetime(int accessTokenLifetime) {
        this.accessTokenLifetime = accessTokenLifetime;
    }

    public int getUmaRptLifetime() {
        return this.umaRptLifetime;
    }

    public void setUmaRptLifetime(int umaRptLifetime) {
        this.umaRptLifetime = umaRptLifetime;
    }

    public int getUmaTicketLifetime() {
        return this.umaTicketLifetime;
    }

    public void setUmaTicketLifetime(int umaTicketLifetime) {
        this.umaTicketLifetime = umaTicketLifetime;
    }

    public int getUmaResourceLifetime() {
        return this.umaResourceLifetime;
    }

    public void setUmaResourceLifetime(int umaResourceLifetime) {
        this.umaResourceLifetime = umaResourceLifetime;
    }

    public int getUmaPctLifetime() {
        return this.umaPctLifetime;
    }

    public void setUmaPctLifetime(int umaPctLifetime) {
        this.umaPctLifetime = umaPctLifetime;
    }

    public Boolean getAllowSpontaneousScopes() {
        if (this.allowSpontaneousScopes == null) {
            this.allowSpontaneousScopes = false;
        }
        return this.allowSpontaneousScopes;
    }

    public void setAllowSpontaneousScopes(Boolean allowSpontaneousScopes) {
        this.allowSpontaneousScopes = allowSpontaneousScopes;
    }

    public int getSpontaneousScopeLifetime() {
        return this.spontaneousScopeLifetime;
    }

    public void setSpontaneousScopeLifetime(int spontaneousScopeLifetime) {
        this.spontaneousScopeLifetime = spontaneousScopeLifetime;
    }

    public int getCleanServiceInterval() {
        return this.cleanServiceInterval;
    }

    public void setCleanServiceInterval(int cleanServiceInterval) {
        this.cleanServiceInterval = cleanServiceInterval;
    }

    public int getCleanServiceBatchChunkSize() {
        return this.cleanServiceBatchChunkSize;
    }

    public void setCleanServiceBatchChunkSize(int cleanServiceBatchChunkSize) {
        this.cleanServiceBatchChunkSize = cleanServiceBatchChunkSize;
    }

    public Boolean getKeyRegenerationEnabled() {
        return this.keyRegenerationEnabled;
    }

    public void setKeyRegenerationEnabled(Boolean keyRegenerationEnabled) {
        this.keyRegenerationEnabled = keyRegenerationEnabled;
    }

    public int getKeyRegenerationInterval() {
        return this.keyRegenerationInterval;
    }

    public void setKeyRegenerationInterval(int keyRegenerationInterval) {
        this.keyRegenerationInterval = keyRegenerationInterval;
    }

    public String getDefaultSignatureAlgorithm() {
        return this.defaultSignatureAlgorithm;
    }

    public void setDefaultSignatureAlgorithm(String defaultSignatureAlgorithm) {
        this.defaultSignatureAlgorithm = defaultSignatureAlgorithm;
    }

    public String getJansOpenIdConnectVersion() {
        return this.jansOpenIdConnectVersion;
    }

    public void setJansOpenIdConnectVersion(String jansOpenIdConnectVersion) {
        this.jansOpenIdConnectVersion = jansOpenIdConnectVersion;
    }

    public String getJansId() {
        return this.jansId;
    }

    public void setJansId(String jansId) {
        this.jansId = jansId;
    }

    public int getDynamicRegistrationExpirationTime() {
        return this.dynamicRegistrationExpirationTime;
    }

    public void setDynamicRegistrationExpirationTime(int dynamicRegistrationExpirationTime) {
        this.dynamicRegistrationExpirationTime = dynamicRegistrationExpirationTime;
    }

    public Boolean getDynamicRegistrationPersistClientAuthorizations() {
        return this.dynamicRegistrationPersistClientAuthorizations;
    }

    public void setDynamicRegistrationPersistClientAuthorizations(Boolean dynamicRegistrationPersistClientAuthorizations) {
        this.dynamicRegistrationPersistClientAuthorizations = dynamicRegistrationPersistClientAuthorizations;
    }

    public Boolean getTrustedClientEnabled() {
        return this.trustedClientEnabled;
    }

    public void setTrustedClientEnabled(Boolean trustedClientEnabled) {
        this.trustedClientEnabled = trustedClientEnabled;
    }

    public Boolean getSkipAuthorizationForOpenIdScopeAndPairwiseId() {
        return this.skipAuthorizationForOpenIdScopeAndPairwiseId;
    }

    public void setSkipAuthorizationForOpenIdScopeAndPairwiseId(Boolean skipAuthorizationForOpenIdScopeAndPairwiseId) {
        this.skipAuthorizationForOpenIdScopeAndPairwiseId = skipAuthorizationForOpenIdScopeAndPairwiseId;
    }

    public Boolean getDynamicRegistrationScopesParamEnabled() {
        return this.dynamicRegistrationScopesParamEnabled;
    }

    public void setDynamicRegistrationScopesParamEnabled(Boolean dynamicRegistrationScopesParamEnabled) {
        this.dynamicRegistrationScopesParamEnabled = dynamicRegistrationScopesParamEnabled;
    }

    public Boolean getPersistIdToken() {
        return this.persistIdToken;
    }

    public void setPersistIdToken(Boolean persistIdToken) {
        this.persistIdToken = persistIdToken;
    }

    public Boolean getPersistRefreshToken() {
        return this.persistRefreshToken;
    }

    public void setPersistRefreshToken(Boolean persistRefreshToken) {
        this.persistRefreshToken = persistRefreshToken;
    }

    public Boolean getAllowPostLogoutRedirectWithoutValidation() {
        if (this.allowPostLogoutRedirectWithoutValidation == null) {
            this.allowPostLogoutRedirectWithoutValidation = false;
        }
        return this.allowPostLogoutRedirectWithoutValidation;
    }

    public void setAllowPostLogoutRedirectWithoutValidation(Boolean allowPostLogoutRedirectWithoutValidation) {
        this.allowPostLogoutRedirectWithoutValidation = allowPostLogoutRedirectWithoutValidation;
    }

    public Boolean getInvalidateSessionCookiesAfterAuthorizationFlow() {
        if (this.invalidateSessionCookiesAfterAuthorizationFlow == null) {
            this.invalidateSessionCookiesAfterAuthorizationFlow = false;
        }
        return this.invalidateSessionCookiesAfterAuthorizationFlow;
    }

    public void setInvalidateSessionCookiesAfterAuthorizationFlow(Boolean invalidateSessionCookiesAfterAuthorizationFlow) {
        this.invalidateSessionCookiesAfterAuthorizationFlow = invalidateSessionCookiesAfterAuthorizationFlow;
    }

    public String getDynamicRegistrationCustomObjectClass() {
        return this.dynamicRegistrationCustomObjectClass;
    }

    public void setDynamicRegistrationCustomObjectClass(String dynamicRegistrationCustomObjectClass) {
        this.dynamicRegistrationCustomObjectClass = dynamicRegistrationCustomObjectClass;
    }

    public List<String> getPersonCustomObjectClassList() {
        return this.personCustomObjectClassList;
    }

    public void setPersonCustomObjectClassList(List<String> personCustomObjectClassList) {
        this.personCustomObjectClassList = personCustomObjectClassList;
    }

    public Boolean getAuthenticationFiltersEnabled() {
        return this.authenticationFiltersEnabled;
    }

    public void setAuthenticationFiltersEnabled(Boolean authenticationFiltersEnabled) {
        this.authenticationFiltersEnabled = authenticationFiltersEnabled;
    }

    public Boolean getClientAuthenticationFiltersEnabled() {
        return this.clientAuthenticationFiltersEnabled;
    }

    public void setClientAuthenticationFiltersEnabled(Boolean clientAuthenticationFiltersEnabled) {
        this.clientAuthenticationFiltersEnabled = clientAuthenticationFiltersEnabled;
    }

    public List<AuthenticationFilter> getAuthenticationFilters() {
        if (this.authenticationFilters == null) {
            this.authenticationFilters = new ArrayList<AuthenticationFilter>();
        }
        return this.authenticationFilters;
    }

    public List<ClientAuthenticationFilter> getClientAuthenticationFilters() {
        if (this.clientAuthenticationFilters == null) {
            this.clientAuthenticationFilters = new ArrayList<ClientAuthenticationFilter>();
        }
        return this.clientAuthenticationFilters;
    }

    public List<CorsConfigurationFilter> getCorsConfigurationFilters() {
        if (this.corsConfigurationFilters == null) {
            this.corsConfigurationFilters = new ArrayList<CorsConfigurationFilter>();
        }
        return this.corsConfigurationFilters;
    }

    public int getSessionIdUnusedLifetime() {
        return this.sessionIdUnusedLifetime;
    }

    public void setSessionIdUnusedLifetime(int sessionIdUnusedLifetime) {
        this.sessionIdUnusedLifetime = sessionIdUnusedLifetime;
    }

    public int getSessionIdUnauthenticatedUnusedLifetime() {
        return this.sessionIdUnauthenticatedUnusedLifetime;
    }

    public void setSessionIdUnauthenticatedUnusedLifetime(int sessionIdUnauthenticatedUnusedLifetime) {
        this.sessionIdUnauthenticatedUnusedLifetime = sessionIdUnauthenticatedUnusedLifetime;
    }

    public Boolean getSessionIdPersistOnPromptNone() {
        return this.sessionIdPersistOnPromptNone;
    }

    public void setSessionIdPersistOnPromptNone(Boolean sessionIdPersistOnPromptNone) {
        this.sessionIdPersistOnPromptNone = sessionIdPersistOnPromptNone;
    }

    public Boolean getSessionIdRequestParameterEnabled() {
        if (this.sessionIdRequestParameterEnabled == null) {
            this.sessionIdRequestParameterEnabled = false;
        }
        return this.sessionIdRequestParameterEnabled;
    }

    public void setSessionIdRequestParameterEnabled(Boolean sessionIdRequestParameterEnabled) {
        this.sessionIdRequestParameterEnabled = sessionIdRequestParameterEnabled;
    }

    public int getConfigurationUpdateInterval() {
        return this.configurationUpdateInterval;
    }

    public void setConfigurationUpdateInterval(int configurationUpdateInterval) {
        this.configurationUpdateInterval = configurationUpdateInterval;
    }

    public String getJsLocation() {
        return this.jsLocation;
    }

    public void setJsLocation(String jsLocation) {
        this.jsLocation = jsLocation;
    }

    public String getCssLocation() {
        return this.cssLocation;
    }

    public void setCssLocation(String cssLocation) {
        this.cssLocation = cssLocation;
    }

    public String getImgLocation() {
        return this.imgLocation;
    }

    public void setImgLocation(String imgLocation) {
        this.imgLocation = imgLocation;
    }

    public int getMetricReporterInterval() {
        return this.metricReporterInterval;
    }

    public void setMetricReporterInterval(int metricReporterInterval) {
        this.metricReporterInterval = metricReporterInterval;
    }

    public int getMetricReporterKeepDataDays() {
        return this.metricReporterKeepDataDays;
    }

    public void setMetricReporterKeepDataDays(int metricReporterKeepDataDays) {
        this.metricReporterKeepDataDays = metricReporterKeepDataDays;
    }

    public String getPairwiseIdType() {
        return this.pairwiseIdType;
    }

    public void setPairwiseIdType(String pairwiseIdType) {
        this.pairwiseIdType = pairwiseIdType;
    }

    public String getPairwiseCalculationKey() {
        return this.pairwiseCalculationKey;
    }

    public void setPairwiseCalculationKey(String pairwiseCalculationKey) {
        this.pairwiseCalculationKey = pairwiseCalculationKey;
    }

    public String getPairwiseCalculationSalt() {
        return this.pairwiseCalculationSalt;
    }

    public void setPairwiseCalculationSalt(String pairwiseCalculationSalt) {
        this.pairwiseCalculationSalt = pairwiseCalculationSalt;
    }

    public Boolean isShareSubjectIdBetweenClientsWithSameSectorId() {
        return this.shareSubjectIdBetweenClientsWithSameSectorId;
    }

    public void setShareSubjectIdBetweenClientsWithSameSectorId(Boolean shareSubjectIdBetweenClientsWithSameSectorId) {
        this.shareSubjectIdBetweenClientsWithSameSectorId = shareSubjectIdBetweenClientsWithSameSectorId;
    }

    public WebKeyStorage getWebKeysStorage() {
        return this.webKeysStorage;
    }

    public void setWebKeysStorage(WebKeyStorage webKeysStorage) {
        this.webKeysStorage = webKeysStorage;
    }

    public String getDnName() {
        return this.dnName;
    }

    public void setDnName(String dnName) {
        this.dnName = dnName;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public String getKeyStoreSecret() {
        return this.keyStoreSecret;
    }

    public void setKeyStoreSecret(String keyStoreSecret) {
        this.keyStoreSecret = keyStoreSecret;
    }

    public String getJansElevenTestModeToken() {
        return this.jansElevenTestModeToken;
    }

    public void setJansElevenTestModeToken(String jansElevenTestModeToken) {
        this.jansElevenTestModeToken = jansElevenTestModeToken;
    }

    public String getJansElevenGenerateKeyEndpoint() {
        return this.jansElevenGenerateKeyEndpoint;
    }

    public void setJansElevenGenerateKeyEndpoint(String jansElevenGenerateKeyEndpoint) {
        this.jansElevenGenerateKeyEndpoint = jansElevenGenerateKeyEndpoint;
    }

    public String getJansElevenSignEndpoint() {
        return this.jansElevenSignEndpoint;
    }

    public void setJansElevenSignEndpoint(String jansElevenSignEndpoint) {
        this.jansElevenSignEndpoint = jansElevenSignEndpoint;
    }

    public String getJansElevenVerifySignatureEndpoint() {
        return this.jansElevenVerifySignatureEndpoint;
    }

    public void setJansElevenVerifySignatureEndpoint(String jansElevenVerifySignatureEndpoint) {
        this.jansElevenVerifySignatureEndpoint = jansElevenVerifySignatureEndpoint;
    }

    public String getJansElevenDeleteKeyEndpoint() {
        return this.jansElevenDeleteKeyEndpoint;
    }

    public void setJansElevenDeleteKeyEndpoint(String jansElevenDeleteKeyEndpoint) {
        this.jansElevenDeleteKeyEndpoint = jansElevenDeleteKeyEndpoint;
    }

    public Boolean getEndSessionWithAccessToken() {
        return this.endSessionWithAccessToken;
    }

    public void setEndSessionWithAccessToken(Boolean endSessionWithAccessToken) {
        this.endSessionWithAccessToken = endSessionWithAccessToken;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public Boolean getEnabledOAuthAuditLogging() {
        return this.enabledOAuthAuditLogging;
    }

    public void setEnabledOAuthAuditLogging(Boolean enabledOAuthAuditLogging) {
        this.enabledOAuthAuditLogging = enabledOAuthAuditLogging;
    }

    public Set<String> getJmsBrokerURISet() {
        return this.jmsBrokerURISet;
    }

    public void setJmsBrokerURISet(Set<String> jmsBrokerURISet) {
        this.jmsBrokerURISet = jmsBrokerURISet;
    }

    public String getJmsUserName() {
        return this.jmsUserName;
    }

    public void setJmsUserName(String jmsUserName) {
        this.jmsUserName = jmsUserName;
    }

    public String getJmsPassword() {
        return this.jmsPassword;
    }

    public void setJmsPassword(String jmsPassword) {
        this.jmsPassword = jmsPassword;
    }

    public List<String> getExternalUriWhiteList() {
        if (this.externalUriWhiteList == null) {
            this.externalUriWhiteList = new ArrayList<String>();
        }
        return this.externalUriWhiteList;
    }

    public void setExternalUriWhiteList(List<String> externalUriWhiteList) {
        this.externalUriWhiteList = externalUriWhiteList;
    }

    public List<String> getClientWhiteList() {
        return this.clientWhiteList;
    }

    public void setClientWhiteList(List<String> clientWhiteList) {
        this.clientWhiteList = clientWhiteList;
    }

    public List<String> getClientBlackList() {
        return this.clientBlackList;
    }

    public void setClientBlackList(List<String> clientBlackList) {
        this.clientBlackList = clientBlackList;
    }

    public Boolean getLegacyIdTokenClaims() {
        return this.legacyIdTokenClaims;
    }

    public void setLegacyIdTokenClaims(Boolean legacyIdTokenClaims) {
        this.legacyIdTokenClaims = legacyIdTokenClaims;
    }

    public Boolean getCustomHeadersWithAuthorizationResponse() {
        if (this.customHeadersWithAuthorizationResponse == null) {
            return false;
        }
        return this.customHeadersWithAuthorizationResponse;
    }

    public void setCustomHeadersWithAuthorizationResponse(Boolean customHeadersWithAuthorizationResponse) {
        this.customHeadersWithAuthorizationResponse = customHeadersWithAuthorizationResponse;
    }

    public Boolean getUpdateUserLastLogonTime() {
        return this.updateUserLastLogonTime != null && this.updateUserLastLogonTime != false;
    }

    public void setUpdateUserLastLogonTime(Boolean updateUserLastLogonTime) {
        this.updateUserLastLogonTime = updateUserLastLogonTime;
    }

    public Boolean getUpdateClientAccessTime() {
        return this.updateClientAccessTime != null && this.updateClientAccessTime != false;
    }

    public void setUpdateClientAccessTime(Boolean updateClientAccessTime) {
        this.updateClientAccessTime = updateClientAccessTime;
    }

    public Boolean getHttpLoggingEnabled() {
        return this.httpLoggingEnabled;
    }

    public void setHttpLoggingEnabled(Boolean httpLoggingEnabled) {
        this.httpLoggingEnabled = httpLoggingEnabled;
    }

    public Set<String> getHttpLoggingExcludePaths() {
        return this.httpLoggingExcludePaths;
    }

    public void setHttpLoggingExcludePaths(Set<String> httpLoggingExcludePaths) {
        this.httpLoggingExcludePaths = httpLoggingExcludePaths;
    }

    public String getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(String loggingLevel) {
        this.loggingLevel = loggingLevel;
    }

    public String getLoggingLayout() {
        return this.loggingLayout;
    }

    public void setLoggingLayout(String loggingLayout) {
        this.loggingLayout = loggingLayout;
    }

    public Boolean getEnableClientGrantTypeUpdate() {
        return this.enableClientGrantTypeUpdate;
    }

    public void setEnableClientGrantTypeUpdate(Boolean enableClientGrantTypeUpdate) {
        this.enableClientGrantTypeUpdate = enableClientGrantTypeUpdate;
    }

    public Set<GrantType> getDynamicGrantTypeDefault() {
        return this.dynamicGrantTypeDefault;
    }

    public void setDynamicGrantTypeDefault(Set<GrantType> dynamicGrantTypeDefault) {
        this.dynamicGrantTypeDefault = dynamicGrantTypeDefault;
    }

    public Integer getSessionIdLifetime() {
        return this.sessionIdLifetime;
    }

    public void setSessionIdLifetime(Integer sessionIdLifetime) {
        this.sessionIdLifetime = sessionIdLifetime;
    }

    public String getActiveSessionAuthorizationScope() {
        return this.activeSessionAuthorizationScope;
    }

    public void setActiveSessionAuthorizationScope(String activeSessionAuthorizationScope) {
        this.activeSessionAuthorizationScope = activeSessionAuthorizationScope;
    }

    public Integer getServerSessionIdLifetime() {
        return this.serverSessionIdLifetime;
    }

    public void setServerSessionIdLifetime(Integer serverSessionIdLifetime) {
        this.serverSessionIdLifetime = serverSessionIdLifetime;
    }

    public Boolean getLogClientIdOnClientAuthentication() {
        return this.logClientIdOnClientAuthentication;
    }

    public void setLogClientIdOnClientAuthentication(Boolean logClientIdOnClientAuthentication) {
        this.logClientIdOnClientAuthentication = logClientIdOnClientAuthentication;
    }

    public Boolean getLogClientNameOnClientAuthentication() {
        return this.logClientNameOnClientAuthentication;
    }

    public void setLogClientNameOnClientAuthentication(Boolean logClientNameOnClientAuthentication) {
        this.logClientNameOnClientAuthentication = logClientNameOnClientAuthentication;
    }

    public String getExternalLoggerConfiguration() {
        return this.externalLoggerConfiguration;
    }

    public void setExternalLoggerConfiguration(String externalLoggerConfiguration) {
        this.externalLoggerConfiguration = externalLoggerConfiguration;
    }

    public Set<AuthorizationRequestCustomParameter> getAuthorizationRequestCustomAllowedParameters() {
        return this.authorizationRequestCustomAllowedParameters;
    }

    public void setAuthorizationRequestCustomAllowedParameters(Set<AuthorizationRequestCustomParameter> authorizationRequestCustomAllowedParameters) {
        this.authorizationRequestCustomAllowedParameters = authorizationRequestCustomAllowedParameters;
    }

    public Boolean getOpenidScopeBackwardCompatibility() {
        return this.openidScopeBackwardCompatibility;
    }

    public void setOpenidScopeBackwardCompatibility(Boolean openidScopeBackwardCompatibility) {
        this.openidScopeBackwardCompatibility = openidScopeBackwardCompatibility;
    }

    public Boolean getDisableU2fEndpoint() {
        return this.disableU2fEndpoint;
    }

    public void setDisableU2fEndpoint(Boolean disableU2fEndpoint) {
        this.disableU2fEndpoint = disableU2fEndpoint;
    }

    public AuthenticationProtectionConfiguration getAuthenticationProtectionConfiguration() {
        return this.authenticationProtectionConfiguration;
    }

    public void setAuthenticationProtectionConfiguration(AuthenticationProtectionConfiguration authenticationProtectionConfiguration) {
        this.authenticationProtectionConfiguration = authenticationProtectionConfiguration;
    }

    public ErrorHandlingMethod getErrorHandlingMethod() {
        return this.errorHandlingMethod;
    }

    public void setErrorHandlingMethod(ErrorHandlingMethod errorHandlingMethod) {
        this.errorHandlingMethod = errorHandlingMethod;
    }

    public Boolean getUseLocalCache() {
        return this.useLocalCache;
    }

    public void setUseLocalCache(Boolean useLocalCache) {
        this.useLocalCache = useLocalCache;
    }

    public Boolean getKeepAuthenticatorAttributesOnAcrChange() {
        return this.keepAuthenticatorAttributesOnAcrChange;
    }

    public void setKeepAuthenticatorAttributesOnAcrChange(Boolean keepAuthenticatorAttributesOnAcrChange) {
        this.keepAuthenticatorAttributesOnAcrChange = keepAuthenticatorAttributesOnAcrChange;
    }

    public Boolean getDisableAuthnForMaxAgeZero() {
        return this.disableAuthnForMaxAgeZero;
    }

    public void setDisableAuthnForMaxAgeZero(Boolean disableAuthnForMaxAgeZero) {
        this.disableAuthnForMaxAgeZero = disableAuthnForMaxAgeZero;
    }

    public String getBackchannelClientId() {
        return this.backchannelClientId;
    }

    public void setBackchannelClientId(String backchannelClientId) {
        this.backchannelClientId = backchannelClientId;
    }

    public String getBackchannelRedirectUri() {
        return this.backchannelRedirectUri;
    }

    public void setBackchannelRedirectUri(String backchannelRedirectUri) {
        this.backchannelRedirectUri = backchannelRedirectUri;
    }

    public String getBackchannelAuthenticationEndpoint() {
        return this.backchannelAuthenticationEndpoint;
    }

    public void setBackchannelAuthenticationEndpoint(String backchannelAuthenticationEndpoint) {
        this.backchannelAuthenticationEndpoint = backchannelAuthenticationEndpoint;
    }

    public String getBackchannelDeviceRegistrationEndpoint() {
        return this.backchannelDeviceRegistrationEndpoint;
    }

    public void setBackchannelDeviceRegistrationEndpoint(String backchannelDeviceRegistrationEndpoint) {
        this.backchannelDeviceRegistrationEndpoint = backchannelDeviceRegistrationEndpoint;
    }

    public List<String> getBackchannelTokenDeliveryModesSupported() {
        if (this.backchannelTokenDeliveryModesSupported == null) {
            this.backchannelTokenDeliveryModesSupported = Lists.newArrayList();
        }
        return this.backchannelTokenDeliveryModesSupported;
    }

    public void setBackchannelTokenDeliveryModesSupported(List<String> backchannelTokenDeliveryModesSupported) {
        this.backchannelTokenDeliveryModesSupported = backchannelTokenDeliveryModesSupported;
    }

    public List<String> getBackchannelAuthenticationRequestSigningAlgValuesSupported() {
        if (this.backchannelAuthenticationRequestSigningAlgValuesSupported == null) {
            this.backchannelAuthenticationRequestSigningAlgValuesSupported = Lists.newArrayList();
        }
        return this.backchannelAuthenticationRequestSigningAlgValuesSupported;
    }

    public void setBackchannelAuthenticationRequestSigningAlgValuesSupported(List<String> backchannelAuthenticationRequestSigningAlgValuesSupported) {
        this.backchannelAuthenticationRequestSigningAlgValuesSupported = backchannelAuthenticationRequestSigningAlgValuesSupported;
    }

    public Boolean getBackchannelUserCodeParameterSupported() {
        return this.backchannelUserCodeParameterSupported;
    }

    public void setBackchannelUserCodeParameterSupported(Boolean backchannelUserCodeParameterSupported) {
        this.backchannelUserCodeParameterSupported = backchannelUserCodeParameterSupported;
    }

    public String getBackchannelBindingMessagePattern() {
        return this.backchannelBindingMessagePattern;
    }

    public void setBackchannelBindingMessagePattern(String backchannelBindingMessagePattern) {
        this.backchannelBindingMessagePattern = backchannelBindingMessagePattern;
    }

    public int getBackchannelAuthenticationResponseExpiresIn() {
        return this.backchannelAuthenticationResponseExpiresIn;
    }

    public void setBackchannelAuthenticationResponseExpiresIn(int backchannelAuthenticationResponseExpiresIn) {
        this.backchannelAuthenticationResponseExpiresIn = backchannelAuthenticationResponseExpiresIn;
    }

    public int getBackchannelAuthenticationResponseInterval() {
        return this.backchannelAuthenticationResponseInterval;
    }

    public void setBackchannelAuthenticationResponseInterval(int backchannelAuthenticationResponseInterval) {
        this.backchannelAuthenticationResponseInterval = backchannelAuthenticationResponseInterval;
    }

    public List<String> getBackchannelLoginHintClaims() {
        return this.backchannelLoginHintClaims;
    }

    public void setBackchannelLoginHintClaims(List<String> backchannelLoginHintClaims) {
        this.backchannelLoginHintClaims = backchannelLoginHintClaims;
    }

    public CIBAEndUserNotificationConfig getCibaEndUserNotificationConfig() {
        return this.cibaEndUserNotificationConfig;
    }

    public void setCibaEndUserNotificationConfig(CIBAEndUserNotificationConfig cibaEndUserNotificationConfig) {
        this.cibaEndUserNotificationConfig = cibaEndUserNotificationConfig;
    }

    public List<String> getDynamicRegistrationAllowedPasswordGrantScopes() {
        if (this.dynamicRegistrationAllowedPasswordGrantScopes == null) {
            this.dynamicRegistrationAllowedPasswordGrantScopes = Lists.newArrayList();
        }
        return this.dynamicRegistrationAllowedPasswordGrantScopes;
    }

    public void setDynamicRegistrationAllowedPasswordGrantScopes(List<String> dynamicRegistrationAllowedPasswordGrantScopes) {
        this.dynamicRegistrationAllowedPasswordGrantScopes = dynamicRegistrationAllowedPasswordGrantScopes;
    }

    public Boolean getDynamicRegistrationPasswordGrantTypeEnabled() {
        return this.dynamicRegistrationPasswordGrantTypeEnabled;
    }

    public void setDynamicRegistrationPasswordGrantTypeEnabled(Boolean dynamicRegistrationPasswordGrantTypeEnabled) {
        this.dynamicRegistrationPasswordGrantTypeEnabled = dynamicRegistrationPasswordGrantTypeEnabled;
    }

    public int getBackchannelRequestsProcessorJobIntervalSec() {
        return this.backchannelRequestsProcessorJobIntervalSec;
    }

    public void setBackchannelRequestsProcessorJobIntervalSec(int backchannelRequestsProcessorJobIntervalSec) {
        this.backchannelRequestsProcessorJobIntervalSec = backchannelRequestsProcessorJobIntervalSec;
    }

    public int getCibaGrantLifeExtraTimeSec() {
        return this.cibaGrantLifeExtraTimeSec;
    }

    public void setCibaGrantLifeExtraTimeSec(int cibaGrantLifeExtraTimeSec) {
        this.cibaGrantLifeExtraTimeSec = cibaGrantLifeExtraTimeSec;
    }

    public int getCibaMaxExpirationTimeAllowedSec() {
        return this.cibaMaxExpirationTimeAllowedSec;
    }

    public void setCibaMaxExpirationTimeAllowedSec(int cibaMaxExpirationTimeAllowedSec) {
        this.cibaMaxExpirationTimeAllowedSec = cibaMaxExpirationTimeAllowedSec;
    }

    public int getBackchannelRequestsProcessorJobChunkSize() {
        return this.backchannelRequestsProcessorJobChunkSize;
    }

    public void setBackchannelRequestsProcessorJobChunkSize(int backchannelRequestsProcessorJobChunkSize) {
        this.backchannelRequestsProcessorJobChunkSize = backchannelRequestsProcessorJobChunkSize;
    }

    public Boolean getClientRegDefaultToCodeFlowWithRefresh() {
        if (this.clientRegDefaultToCodeFlowWithRefresh == null) {
            this.clientRegDefaultToCodeFlowWithRefresh = false;
        }
        return this.clientRegDefaultToCodeFlowWithRefresh;
    }

    public void setClientRegDefaultToCodeFlowWithRefresh(Boolean clientRegDefaultToCodeFlowWithRefresh) {
        this.clientRegDefaultToCodeFlowWithRefresh = clientRegDefaultToCodeFlowWithRefresh;
    }

    public Boolean getGrantTypesAndResponseTypesAutofixEnabled() {
        if (this.grantTypesAndResponseTypesAutofixEnabled == null) {
            this.grantTypesAndResponseTypesAutofixEnabled = false;
        }
        return this.grantTypesAndResponseTypesAutofixEnabled;
    }

    public void setGrantTypesAndResponseTypesAutofixEnabled(Boolean grantTypesAndResponseTypesAutofixEnabled) {
        this.grantTypesAndResponseTypesAutofixEnabled = grantTypesAndResponseTypesAutofixEnabled;
    }

    public String getDeviceAuthzEndpoint() {
        return this.deviceAuthzEndpoint;
    }

    public void setDeviceAuthzEndpoint(String deviceAuthzEndpoint) {
        this.deviceAuthzEndpoint = deviceAuthzEndpoint;
    }

    public int getDeviceAuthzRequestExpiresIn() {
        return this.deviceAuthzRequestExpiresIn;
    }

    public void setDeviceAuthzRequestExpiresIn(int deviceAuthzRequestExpiresIn) {
        this.deviceAuthzRequestExpiresIn = deviceAuthzRequestExpiresIn;
    }

    public int getDeviceAuthzTokenPollInterval() {
        return this.deviceAuthzTokenPollInterval;
    }

    public void setDeviceAuthzTokenPollInterval(int deviceAuthzTokenPollInterval) {
        this.deviceAuthzTokenPollInterval = deviceAuthzTokenPollInterval;
    }

    public String getDeviceAuthzResponseTypeToProcessAuthz() {
        return this.deviceAuthzResponseTypeToProcessAuthz;
    }

    public void setDeviceAuthzResponseTypeToProcessAuthz(String deviceAuthzResponseTypeToProcessAuthz) {
        this.deviceAuthzResponseTypeToProcessAuthz = deviceAuthzResponseTypeToProcessAuthz;
    }

    public String getDeviceAuthzAcr() {
        return this.deviceAuthzAcr;
    }

    public void setDeviceAuthzAcr(String deviceAuthzAcr) {
        this.deviceAuthzAcr = deviceAuthzAcr;
    }

    public Boolean getRequestUriHashVerificationEnabled() {
        return this.requestUriHashVerificationEnabled != null && this.requestUriHashVerificationEnabled != false;
    }

    public void setRequestUriHashVerificationEnabled(Boolean requestUriHashVerificationEnabled) {
        this.requestUriHashVerificationEnabled = requestUriHashVerificationEnabled;
    }

    public Boolean getIdTokenFilterClaimsBasedOnAccessToken() {
        return this.idTokenFilterClaimsBasedOnAccessToken != null && this.idTokenFilterClaimsBasedOnAccessToken != false;
    }

    public void setIdTokenFilterClaimsBasedOnAccessToken(Boolean idTokenFilterClaimsBasedOnAccessToken) {
        this.idTokenFilterClaimsBasedOnAccessToken = idTokenFilterClaimsBasedOnAccessToken;
    }

    public String getMtlsAuthorizationEndpoint() {
        return this.mtlsAuthorizationEndpoint;
    }

    public void setMtlsAuthorizationEndpoint(String mtlsAuthorizationEndpoint) {
        this.mtlsAuthorizationEndpoint = mtlsAuthorizationEndpoint;
    }

    public String getMtlsTokenEndpoint() {
        return this.mtlsTokenEndpoint;
    }

    public void setMtlsTokenEndpoint(String mtlsTokenEndpoint) {
        this.mtlsTokenEndpoint = mtlsTokenEndpoint;
    }

    public String getMtlsTokenRevocationEndpoint() {
        return this.mtlsTokenRevocationEndpoint;
    }

    public void setMtlsTokenRevocationEndpoint(String mtlsTokenRevocationEndpoint) {
        this.mtlsTokenRevocationEndpoint = mtlsTokenRevocationEndpoint;
    }

    public String getMtlsUserInfoEndpoint() {
        return this.mtlsUserInfoEndpoint;
    }

    public void setMtlsUserInfoEndpoint(String mtlsUserInfoEndpoint) {
        this.mtlsUserInfoEndpoint = mtlsUserInfoEndpoint;
    }

    public String getMtlsClientInfoEndpoint() {
        return this.mtlsClientInfoEndpoint;
    }

    public void setMtlsClientInfoEndpoint(String mtlsClientInfoEndpoint) {
        this.mtlsClientInfoEndpoint = mtlsClientInfoEndpoint;
    }

    public String getMtlsCheckSessionIFrame() {
        return this.mtlsCheckSessionIFrame;
    }

    public void setMtlsCheckSessionIFrame(String mtlsCheckSessionIFrame) {
        this.mtlsCheckSessionIFrame = mtlsCheckSessionIFrame;
    }

    public String getMtlsEndSessionEndpoint() {
        return this.mtlsEndSessionEndpoint;
    }

    public void setMtlsEndSessionEndpoint(String mtlsEndSessionEndpoint) {
        this.mtlsEndSessionEndpoint = mtlsEndSessionEndpoint;
    }

    public String getMtlsJwksUri() {
        return this.mtlsJwksUri;
    }

    public void setMtlsJwksUri(String mtlsJwksUri) {
        this.mtlsJwksUri = mtlsJwksUri;
    }

    public String getMtlsRegistrationEndpoint() {
        return this.mtlsRegistrationEndpoint;
    }

    public void setMtlsRegistrationEndpoint(String mtlsRegistrationEndpoint) {
        this.mtlsRegistrationEndpoint = mtlsRegistrationEndpoint;
    }

    public String getMtlsIdGenerationEndpoint() {
        return this.mtlsIdGenerationEndpoint;
    }

    public void setMtlsIdGenerationEndpoint(String mtlsIdGenerationEndpoint) {
        this.mtlsIdGenerationEndpoint = mtlsIdGenerationEndpoint;
    }

    public String getMtlsIntrospectionEndpoint() {
        return this.mtlsIntrospectionEndpoint;
    }

    public void setMtlsIntrospectionEndpoint(String mtlsIntrospectionEndpoint) {
        this.mtlsIntrospectionEndpoint = mtlsIntrospectionEndpoint;
    }

    public String getMtlsParEndpoint() {
        return this.mtlsParEndpoint;
    }

    public void setMtlsParEndpoint(String mtlsParEndpoint) {
        this.mtlsParEndpoint = mtlsParEndpoint;
    }

    public String getMtlsDeviceAuthzEndpoint() {
        return this.mtlsDeviceAuthzEndpoint;
    }

    public void setMtlsDeviceAuthzEndpoint(String mtlsDeviceAuthzEndpoint) {
        this.mtlsDeviceAuthzEndpoint = mtlsDeviceAuthzEndpoint;
    }

    public List<String> getDpopSigningAlgValuesSupported() {
        if (this.dpopSigningAlgValuesSupported == null) {
            this.dpopSigningAlgValuesSupported = new ArrayList<String>();
        }
        return this.dpopSigningAlgValuesSupported;
    }

    public void setDpopSigningAlgValuesSupported(List<String> dpopSigningAlgValuesSupported) {
        this.dpopSigningAlgValuesSupported = dpopSigningAlgValuesSupported;
    }

    public int getDpopTimeframe() {
        return this.dpopTimeframe;
    }

    public void setDpopTimeframe(int dpopTimeframe) {
        this.dpopTimeframe = dpopTimeframe;
    }

    public int getDpopJtiCacheTime() {
        return this.dpopJtiCacheTime;
    }

    public void setDpopJtiCacheTime(int dpopJtiCacheTime) {
        this.dpopJtiCacheTime = dpopJtiCacheTime;
    }

    public Boolean getRedirectUrisRegexEnabled() {
        return this.redirectUrisRegexEnabled != null && this.redirectUrisRegexEnabled != false;
    }

    public void setRedirectUrisRegexEnabled(Boolean redirectUrisRegexEnabled) {
        this.redirectUrisRegexEnabled = redirectUrisRegexEnabled;
    }

    public Boolean getUseHighestLevelScriptIfAcrScriptNotFound() {
        return this.useHighestLevelScriptIfAcrScriptNotFound != null && this.useHighestLevelScriptIfAcrScriptNotFound != false;
    }

    public void setUseHighestLevelScriptIfAcrScriptNotFound(Boolean useHighestLevelScriptIfAcrScriptNotFound) {
        this.useHighestLevelScriptIfAcrScriptNotFound = useHighestLevelScriptIfAcrScriptNotFound;
    }

    public EngineConfig getAgamaConfiguration() {
        return this.agamaConfiguration;
    }

    public void setAgamaConfiguration(EngineConfig agamaConfiguration) {
        this.agamaConfiguration = agamaConfiguration;
    }

    public SsaConfiguration getSsaConfiguration() {
        return this.ssaConfiguration;
    }

    public void setSsaConfiguration(SsaConfiguration ssaConfiguration) {
        this.ssaConfiguration = ssaConfiguration;
    }

    public Boolean getBlockWebviewAuthorizationEnabled() {
        return this.blockWebviewAuthorizationEnabled;
    }

    public void setBlockWebviewAuthorizationEnabled(Boolean blockWebviewAuthorizationEnabled) {
        this.blockWebviewAuthorizationEnabled = blockWebviewAuthorizationEnabled;
    }

    public Boolean getHttpLoggingResponseBodyContent() {
        if (this.httpLoggingResponseBodyContent == null) {
            this.httpLoggingResponseBodyContent = false;
        }
        return this.httpLoggingResponseBodyContent;
    }

    public void setHttpLoggingResponseBodyContent(Boolean httpLoggingResponseBodyContent) {
        this.httpLoggingResponseBodyContent = httpLoggingResponseBodyContent;
    }
}

