/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.common.converter;

import com.fasterxml.jackson.databind.util.StdConverter;
import io.jans.as.model.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ListConverter
extends StdConverter<Object, List<String>> {
    public List<String> convert(Object obj) {
        if (obj != null) {
            if (List.class.isAssignableFrom(obj.getClass())) {
                Stream<Object> stream = ((List)obj).stream().filter(Objects::nonNull).map(Object::toString);
                return stream.collect(Collectors.toList());
            }
            if (String.class.equals(obj.getClass())) {
                return StringUtils.spaceSeparatedToList(obj.toString());
            }
        }
        return new ArrayList<String>();
    }
}

