/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Lists;
import io.jans.as.model.common.HasParamName;
import io.jans.orm.annotation.AttributeEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public enum ResponseType implements HasParamName,
AttributeEnum
{
    CODE("code", "Authorization Code Grant Type"),
    TOKEN("token", "Implicit Grant Type"),
    ID_TOKEN("id_token", "ID Token");

    private final String value;
    private final String displayName;
    private static final Map<String, ResponseType> mapByValues;

    private ResponseType(String value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    @JsonCreator
    public static ResponseType fromString(String param) {
        if (param != null) {
            for (ResponseType rt : ResponseType.values()) {
                if (!param.equals(rt.value)) continue;
                return rt;
            }
        }
        return null;
    }

    @Override
    public String getParamName() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getValue() {
        return this.value;
    }

    public static List<ResponseType> fromString(String paramList, String separator) {
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        if (paramList != null && !paramList.isEmpty()) {
            String[] params;
            for (String param : params = paramList.split(separator)) {
                for (ResponseType rt : ResponseType.values()) {
                    if (!param.equals(rt.value) || responseTypes.contains(rt)) continue;
                    responseTypes.add(rt);
                }
            }
        }
        return responseTypes;
    }

    public static boolean isImplicitFlow(String responseTypes) {
        if (StringUtils.isBlank((CharSequence)responseTypes)) {
            return false;
        }
        return !responseTypes.contains("code") && (responseTypes.contains("id_token") || responseTypes.contains("token"));
    }

    public static List<String> toStringList(List<ResponseType> responseTypes) {
        if (responseTypes == null) {
            return Lists.newArrayList();
        }
        return responseTypes.stream().map(ResponseType::getValue).collect(Collectors.toList());
    }

    public static String[] toStringArray(ResponseType[] responseTypes) {
        if (responseTypes == null) {
            return new String[0];
        }
        String[] resultResponseTypes = new String[responseTypes.length];
        for (int i = 0; i < responseTypes.length; ++i) {
            resultResponseTypes[i] = responseTypes[i].getValue();
        }
        return resultResponseTypes;
    }

    public static ResponseType getByValue(String value) {
        return mapByValues.get(value);
    }

    public Enum<? extends AttributeEnum> resolveByValue(String value) {
        return ResponseType.getByValue(value);
    }

    @JsonValue
    public String toString() {
        return this.value;
    }

    static {
        mapByValues = new HashMap<String, ResponseType>();
        for (ResponseType enumType : ResponseType.values()) {
            mapByValues.put(enumType.getValue(), enumType);
        }
    }
}

