/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.jans.as.model.common.HasParamName;
import io.jans.orm.annotation.AttributeEnum;
import java.util.HashMap;
import java.util.Map;

public enum GrantType implements HasParamName,
AttributeEnum
{
    NONE("none"),
    AUTHORIZATION_CODE("authorization_code"),
    IMPLICIT("implicit"),
    RESOURCE_OWNER_PASSWORD_CREDENTIALS("password"),
    CLIENT_CREDENTIALS("client_credentials"),
    REFRESH_TOKEN("refresh_token"),
    OXAUTH_UMA_TICKET("urn:ietf:params:oauth:grant-type:uma-ticket"),
    TOKEN_EXCHANGE("urn:ietf:params:oauth:grant-type:token-exchange"),
    CIBA("urn:openid:params:grant-type:ciba"),
    DEVICE_CODE("urn:ietf:params:oauth:grant-type:device_code");

    private final String value;
    private static final Map<String, GrantType> mapByValues;

    private GrantType() {
        this.value = null;
    }

    private GrantType(String value) {
        this.value = value;
    }

    @Override
    public String getParamName() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static GrantType fromString(String param) {
        if (param != null) {
            for (GrantType gt : GrantType.values()) {
                if (!param.equals(gt.value)) continue;
                return gt;
            }
        }
        return null;
    }

    public static String[] toStringArray(GrantType[] grantTypes) {
        if (grantTypes == null) {
            return new String[0];
        }
        String[] resultGrantTypes = new String[grantTypes.length];
        for (int i = 0; i < grantTypes.length; ++i) {
            resultGrantTypes[i] = grantTypes[i].getValue();
        }
        return resultGrantTypes;
    }

    public static GrantType getByValue(String value) {
        return mapByValues.get(value);
    }

    public Enum<? extends AttributeEnum> resolveByValue(String value) {
        return GrantType.getByValue(value);
    }

    @JsonValue
    public String toString() {
        return this.value;
    }

    static {
        mapByValues = new HashMap<String, GrantType>();
        for (GrantType enumType : GrantType.values()) {
            mapByValues.put(enumType.getValue(), enumType);
        }
    }
}

