/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.model.common;

import io.jans.as.model.configuration.AppConfiguration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public enum FeatureFlagType {
    UNKNOWN("unknown"),
    HEALTH_CHECK("health_check"),
    USERINFO("userinfo"),
    CLIENTINFO("clientinfo"),
    ID_GENERATION("id_generation"),
    REGISTRATION("registration"),
    INTROSPECTION("introspection"),
    REVOKE_TOKEN("revoke_token"),
    REVOKE_SESSION("revoke_session"),
    ACTIVE_SESSION("active_session"),
    END_SESSION("end_session"),
    STATUS_SESSION("status_session"),
    JANS_CONFIGURATION("jans_configuration"),
    CIBA("ciba"),
    UMA("uma"),
    U2F("u2f"),
    DEVICE_AUTHZ("device_authz"),
    METRIC("metric"),
    STAT("stat"),
    PAR("par"),
    SSA("ssa");

    private final String value;

    private FeatureFlagType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static FeatureFlagType fromValue(String v) {
        if (StringUtils.isBlank((CharSequence)v)) {
            return UNKNOWN;
        }
        for (FeatureFlagType t : FeatureFlagType.values()) {
            if (!t.getValue().equalsIgnoreCase(v)) continue;
            return t;
        }
        return UNKNOWN;
    }

    public static Set<FeatureFlagType> from(AppConfiguration appConfiguration) {
        return FeatureFlagType.fromValues(appConfiguration.getFeatureFlags());
    }

    public static Set<FeatureFlagType> fromValues(List<String> values) {
        HashSet<FeatureFlagType> result = new HashSet<FeatureFlagType>();
        if (values == null || values.isEmpty()) {
            return result;
        }
        for (String v : values) {
            FeatureFlagType t = FeatureFlagType.fromValue(v);
            if (t == UNKNOWN) continue;
            result.add(t);
        }
        return result;
    }
}

