/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang.StringUtils;

public class TestPropFile {
    private static final String TEST_PROP_FILE = "test_prop_file";
    private String propFile;
    private List<String> records = new ArrayList<String>();

    public TestPropFile(String propFile) {
        this.propFile = propFile;
    }

    public static TestPropFile create(CommandLine cmd) {
        if (cmd.hasOption(TEST_PROP_FILE)) {
            return new TestPropFile(cmd.getOptionValue(TEST_PROP_FILE));
        }
        return new TestPropFile(null);
    }

    public boolean isEmpty() {
        return StringUtils.isBlank((String)this.propFile);
    }

    public boolean shouldGenerate() {
        return StringUtils.isNotBlank((String)this.propFile);
    }

    public void add(String record) {
        if (this.shouldGenerate()) {
            this.records.add(record);
        }
    }

    public void generate() throws IOException {
        if (this.isEmpty()) {
            return;
        }
        try (FileOutputStream fosTestPropFile = new FileOutputStream(this.propFile);){
            for (String rec : this.records) {
                fosTestPropFile.write(rec.getBytes());
                fosTestPropFile.write("\n".getBytes());
            }
        }
    }
}

