/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client.util;

import io.jans.as.client.util.KeyGeneratorContext;
import io.jans.as.client.util.TestPropFile;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.AuthCryptoProvider;
import io.jans.as.model.crypto.ElevenCryptoProvider;
import io.jans.as.model.crypto.encryption.KeyEncryptionAlgorithm;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.exception.CryptoProviderException;
import io.jans.as.model.jwk.Algorithm;
import io.jans.as.model.jwk.JSONWebKey;
import io.jans.as.model.jwk.JSONWebKeySet;
import io.jans.as.model.jwk.KeyOpsType;
import io.jans.as.model.jwk.Use;
import io.jans.as.model.util.SecurityProviderUtility;
import io.jans.as.model.util.StringUtils;
import io.jans.util.StringHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusLogger;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public class KeyGenerator {
    private static final String SIGNING_KEYS = "sig_keys";
    private static final String ENCRYPTION_KEYS = "enc_keys";
    private static final String KEY_STORE_FILE = "keystore";
    private static final String KEY_STORE_PASSWORD = "keypasswd";
    private static final String DN_NAME = "dnname";
    private static final String OXELEVEN_ACCESS_TOKEN = "at";
    private static final String OXELEVEN_GENERATE_KEY_ENDPOINT = "ox11";
    private static final String EXPIRATION = "expiration";
    private static final String EXPIRATION_HOURS = "expiration_hours";
    private static final String KEY_LENGTH = "key_length";
    private static final String HELP = "h";
    private static final String TEST_PROP_FILE = "test_prop_file";
    private static final String KEY_OPS_TYPE = "key_ops_type";
    private static final String KEY_NAME_SUFFIX = "_keyId";
    private static final Logger log;

    public static void main(String[] args) {
        new Cli(args).parse();
    }

    static {
        StatusLogger.getLogger().setLevel(Level.OFF);
        log = Logger.getLogger(KeyGenerator.class);
    }

    public static class Cli {
        private String[] args = null;
        private final Options options = new Options();

        public Cli(String[] args) {
            this.args = args;
            Option signingKeysOption = new Option(KeyGenerator.SIGNING_KEYS, true, "Signature keys to generate (RS256 RS384 RS512 ES256 ES256K ES384 ES512 PS256 PS384 PS512 EdDSA).");
            signingKeysOption.setArgs(-2);
            Option encryptionKeysOption = new Option(KeyGenerator.ENCRYPTION_KEYS, true, "Encryption keys to generate (RSA1_5 RSA-OAEP RSA-OAEP-256 ECDH-ES ECDH-ES+A128KW ECDH-ES+A192KW ECDH-ES+A256KW).");
            encryptionKeysOption.setArgs(-2);
            this.options.addOption(signingKeysOption);
            this.options.addOption(encryptionKeysOption);
            this.options.addOption(KeyGenerator.KEY_STORE_FILE, true, "Key Store file.");
            this.options.addOption(KeyGenerator.KEY_STORE_PASSWORD, true, "Key Store password.");
            this.options.addOption(KeyGenerator.DN_NAME, true, "DN of certificate issuer.");
            this.options.addOption(KeyGenerator.OXELEVEN_ACCESS_TOKEN, true, "oxEleven Access Token");
            this.options.addOption(KeyGenerator.OXELEVEN_GENERATE_KEY_ENDPOINT, true, "oxEleven Generate Key Endpoint.");
            this.options.addOption(KeyGenerator.EXPIRATION, true, "Expiration in days.");
            this.options.addOption(KeyGenerator.EXPIRATION_HOURS, true, "Expiration in hours.");
            this.options.addOption(KeyGenerator.KEY_LENGTH, true, "Key length");
            this.options.addOption(KeyGenerator.KEY_OPS_TYPE, true, "Key Operations Type");
            this.options.addOption(KeyGenerator.TEST_PROP_FILE, true, "Tests property file.");
            this.options.addOption(KeyGenerator.HELP, false, "Show help.");
        }

        public void parse() {
            BasicParser parser = new BasicParser();
            try {
                List<Algorithm> encryptionAlgorithms;
                CommandLine cmd = parser.parse(this.options, this.args);
                if (cmd.hasOption(KeyGenerator.HELP)) {
                    this.help();
                }
                if (!cmd.hasOption(KeyGenerator.SIGNING_KEYS) && !cmd.hasOption(KeyGenerator.ENCRYPTION_KEYS) || !cmd.hasOption(KeyGenerator.EXPIRATION) && !cmd.hasOption(KeyGenerator.EXPIRATION_HOURS)) {
                    this.help();
                }
                KeyOpsType keyOpsType = this.parseKeyOps(cmd);
                String[] sigAlgorithms = cmd.getOptionValues(KeyGenerator.SIGNING_KEYS);
                String[] encAlgorithms = cmd.getOptionValues(KeyGenerator.ENCRYPTION_KEYS);
                List<Algorithm> signatureAlgorithms = cmd.hasOption(KeyGenerator.SIGNING_KEYS) ? Algorithm.fromString((String[])sigAlgorithms, (Use)Use.SIGNATURE) : new ArrayList();
                List list = encryptionAlgorithms = cmd.hasOption(KeyGenerator.ENCRYPTION_KEYS) ? Algorithm.fromString((String[])encAlgorithms, (Use)Use.ENCRYPTION) : new ArrayList();
                if (signatureAlgorithms.isEmpty() && encryptionAlgorithms.isEmpty()) {
                    this.help();
                }
                KeyGeneratorContext context = new KeyGeneratorContext();
                context.setKeyLength(StringHelper.toInt((String)cmd.getOptionValue(KeyGenerator.KEY_LENGTH), (int)2048));
                context.setExpirationDays(StringHelper.toInt((String)cmd.getOptionValue(KeyGenerator.EXPIRATION), (int)0));
                context.setExpirationHours(StringHelper.toInt((String)cmd.getOptionValue(KeyGenerator.EXPIRATION_HOURS), (int)0));
                context.calculateExpiration();
                context.setTestPropFile(TestPropFile.create(cmd));
                context.setKeyOpsType(keyOpsType);
                if (cmd.hasOption(KeyGenerator.OXELEVEN_ACCESS_TOKEN) && cmd.hasOption(KeyGenerator.OXELEVEN_GENERATE_KEY_ENDPOINT)) {
                    this.generateKeysWithEleven(cmd, signatureAlgorithms, encryptionAlgorithms, context);
                } else if (cmd.hasOption(KeyGenerator.KEY_STORE_FILE) && cmd.hasOption(KeyGenerator.KEY_STORE_PASSWORD) && cmd.hasOption(KeyGenerator.DN_NAME)) {
                    this.generateKeysWithJansAuth(cmd, signatureAlgorithms, encryptionAlgorithms, context);
                } else {
                    this.help();
                }
            }
            catch (ParseException e) {
                log.error((Object)"Failed to generate keys", (Throwable)e);
                this.help();
            }
        }

        @Nullable
        private KeyOpsType parseKeyOps(CommandLine cmd) {
            KeyOpsType keyOpsType;
            if (!cmd.hasOption(KeyGenerator.KEY_OPS_TYPE)) {
                this.help();
            }
            if ((keyOpsType = KeyOpsType.fromString((String)cmd.getOptionValue(KeyGenerator.KEY_OPS_TYPE))) == null) {
                this.help();
            }
            return keyOpsType;
        }

        private void generateKeysWithJansAuth(CommandLine cmd, List<Algorithm> signatureAlgorithms, List<Algorithm> encryptionAlgorithms, KeyGeneratorContext context) {
            String keystore = cmd.getOptionValue(KeyGenerator.KEY_STORE_FILE);
            String keypasswd = cmd.getOptionValue(KeyGenerator.KEY_STORE_PASSWORD);
            String dnName = cmd.getOptionValue(KeyGenerator.DN_NAME);
            try {
                SecurityProviderUtility.installBCProvider((boolean)true);
                context.setCryptoProvider((AbstractCryptoProvider)new AuthCryptoProvider(keystore, keypasswd, dnName));
                this.generateKeys(context, signatureAlgorithms, encryptionAlgorithms);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)"Failed to generate keys with `jans-auth` crypto", (Throwable)e);
                this.help();
            }
        }

        private void generateKeysWithEleven(CommandLine cmd, List<Algorithm> signatureAlgorithms, List<Algorithm> encryptionAlgorithms, KeyGeneratorContext context) {
            String accessToken = cmd.getOptionValue(KeyGenerator.OXELEVEN_ACCESS_TOKEN);
            String generateKeyEndpoint = cmd.getOptionValue(KeyGenerator.OXELEVEN_GENERATE_KEY_ENDPOINT);
            try {
                context.setCryptoProvider((AbstractCryptoProvider)new ElevenCryptoProvider(generateKeyEndpoint, null, null, null, accessToken));
                this.generateKeys(context, signatureAlgorithms, encryptionAlgorithms);
            }
            catch (Exception e) {
                log.error((Object)"Failed to generate keys with 'eleven' crypto", (Throwable)e);
                this.help();
            }
        }

        private void generateKeys(KeyGeneratorContext context, List<Algorithm> signatureAlgorithms, List<Algorithm> encryptionAlgorithms) throws CryptoProviderException, IOException {
            JSONWebKeySet jwks = new JSONWebKeySet();
            KeyOpsType keyOpsType = context.getKeyOpsType();
            if (keyOpsType == KeyOpsType.ALL) {
                this.generateSignatureKeys(context, signatureAlgorithms, jwks, KeyOpsType.CONNECT);
                this.generateSignatureKeys(context, signatureAlgorithms, jwks, KeyOpsType.SSA);
                this.generateEncryptionKeys(context, encryptionAlgorithms, jwks, KeyOpsType.CONNECT);
                this.generateEncryptionKeys(context, encryptionAlgorithms, jwks, KeyOpsType.SSA);
            } else {
                this.generateSignatureKeys(context, signatureAlgorithms, jwks, keyOpsType);
                this.generateEncryptionKeys(context, encryptionAlgorithms, jwks, keyOpsType);
            }
            context.getTestPropFile().generate();
            System.out.println(jwks);
        }

        private void generateEncryptionKeys(KeyGeneratorContext context, List<Algorithm> encryptionAlgorithms, JSONWebKeySet jwks, KeyOpsType keyOpsType) throws CryptoProviderException {
            for (Algorithm algorithm : encryptionAlgorithms) {
                KeyEncryptionAlgorithm encryptionAlgorithm = KeyEncryptionAlgorithm.fromName((String)algorithm.getParamName());
                JSONObject result = context.getCryptoProvider().generateKey(algorithm, Long.valueOf(context.getExpirationForKeyOpsType(keyOpsType)), context.getKeyLength(), keyOpsType);
                JSONWebKey key = new JSONWebKey();
                key.setName(algorithm.getOutName());
                key.setDescr(algorithm.getDescription());
                key.setKid(result.getString("kid"));
                key.setUse(Use.ENCRYPTION);
                key.setAlg(algorithm);
                key.setKty(encryptionAlgorithm.getFamily().getKeyType());
                key.setExp(Long.valueOf(result.optLong("exp")));
                key.setCrv(encryptionAlgorithm.getCurve());
                key.setN(result.optString("n"));
                key.setE(result.optString("e"));
                key.setX(result.optString("x"));
                key.setY(result.optString("y"));
                key.setKeyOpsType(Collections.singletonList(keyOpsType));
                JSONArray x5c = result.optJSONArray("x5c");
                key.setX5c(StringUtils.toList((JSONArray)x5c));
                jwks.getKeys().add(key);
                context.getTestPropFile().add(Cli.getKeyNameFromAlgorithm(algorithm) + "=" + result.getString("kid"));
            }
        }

        private void generateSignatureKeys(KeyGeneratorContext context, List<Algorithm> signatureAlgorithms, JSONWebKeySet jwks, KeyOpsType keyOpsType) throws CryptoProviderException {
            for (Algorithm algorithm : signatureAlgorithms) {
                SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromString((String)algorithm.getParamName());
                JSONObject result = context.getCryptoProvider().generateKey(algorithm, Long.valueOf(context.getExpirationForKeyOpsType(keyOpsType)), context.getKeyLength(), keyOpsType);
                JSONWebKey key = new JSONWebKey();
                key.setName(algorithm.getOutName());
                key.setDescr(algorithm.getDescription());
                key.setKid(result.getString("kid"));
                key.setUse(Use.SIGNATURE);
                key.setAlg(algorithm);
                key.setKty(signatureAlgorithm.getFamily().getKeyType());
                key.setExp(Long.valueOf(result.optLong("exp")));
                key.setCrv(signatureAlgorithm.getCurve());
                key.setN(result.optString("n"));
                key.setE(result.optString("e"));
                key.setX(result.optString("x"));
                key.setY(result.optString("y"));
                key.setKeyOpsType(Collections.singletonList(keyOpsType));
                JSONArray x5c = result.optJSONArray("x5c");
                key.setX5c(StringUtils.toList((JSONArray)x5c));
                jwks.getKeys().add(key);
                context.getTestPropFile().add(Cli.getKeyNameFromAlgorithm(algorithm) + "=" + result.getString("kid"));
            }
        }

        private static String getKeyNameFromAlgorithm(Algorithm algorithm) {
            String keyNamePrefix = Algorithm.RSA_OAEP.equals((Object)algorithm) || Algorithm.RSA_OAEP_256.equals((Object)algorithm) || Algorithm.ECDH_ES.equals((Object)algorithm) || Algorithm.ECDH_ES_PLUS_A128KW.equals((Object)algorithm) || Algorithm.ECDH_ES_PLUS_A192KW.equals((Object)algorithm) || Algorithm.ECDH_ES_PLUS_A256KW.equals((Object)algorithm) ? algorithm.name() : algorithm.getParamName();
            return keyNamePrefix + KeyGenerator.KEY_NAME_SUFFIX;
        }

        private void help() {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("KeyGenerator -sig_keys alg ... -enc_keys alg ... -expiration n_days [-expiration_hours n_hours] [-ox11 url] [-keystore path -keypasswd secret -dnname dn_name]", this.options);
            System.exit(0);
        }
    }
}

