/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client.uma.wrapper;

import io.jans.as.client.AuthorizationRequest;
import io.jans.as.client.AuthorizationResponse;
import io.jans.as.client.AuthorizeClient;
import io.jans.as.client.TokenClient;
import io.jans.as.client.TokenRequest;
import io.jans.as.client.TokenResponse;
import io.jans.as.client.uma.exception.UmaException;
import io.jans.as.model.common.AuthenticationMethod;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.common.Prompt;
import io.jans.as.model.common.ResponseType;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.AuthCryptoProvider;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.uma.UmaScopeType;
import io.jans.as.model.uma.wrapper.Token;
import io.jans.as.model.util.Util;
import io.jans.util.StringHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;

public class UmaClient {
    private UmaClient() {
    }

    public static Token requestPat(String tokenUrl, String clientKeyStoreFile, String clientKeyStorePassword, String clientId, String keyId) throws UmaException {
        TokenRequest tokenRequest = TokenRequest.builder().pat(new String[0]).grantType(GrantType.CLIENT_CREDENTIALS).build();
        return UmaClient.request(tokenUrl, clientKeyStoreFile, clientKeyStorePassword, clientId, keyId, tokenRequest);
    }

    @Deprecated
    public static Token requestPat(String authorizeUrl, String tokenUrl, String umaUserId, String umaUserSecret, String umaClientId, String umaClientSecret, String umaRedirectUri, String ... scopeArray) {
        return UmaClient.request(authorizeUrl, tokenUrl, umaUserId, umaUserSecret, umaClientId, umaClientSecret, umaRedirectUri, UmaScopeType.PROTECTION, scopeArray);
    }

    public static Token requestPat(String tokenUrl, String umaClientId, String umaClientSecret, String ... scopeArray) {
        return UmaClient.requestPat(tokenUrl, umaClientId, umaClientSecret, null, scopeArray);
    }

    public static Token requestPat(String tokenUrl, String umaClientId, String umaClientSecret, ClientHttpEngine engine, String ... scopeArray) {
        return UmaClient.request(tokenUrl, umaClientId, umaClientSecret, UmaScopeType.PROTECTION, engine, scopeArray);
    }

    @Deprecated
    public static Token request(String authorizeUrl, String tokenUrl, String umaUserId, String umaUserSecret, String umaClientId, String umaClientSecret, String umaRedirectUri, UmaScopeType type, String ... scopeArray) {
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        responseTypes.add(ResponseType.CODE);
        responseTypes.add(ResponseType.ID_TOKEN);
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add(type.getValue());
        if (scopeArray != null && scopeArray.length > 0) {
            scopes.addAll(Arrays.asList(scopeArray));
        }
        String state = UUID.randomUUID().toString();
        AuthorizationRequest request = new AuthorizationRequest(responseTypes, umaClientId, scopes, umaRedirectUri, null);
        request.setState(state);
        request.setAuthUsername(umaUserId);
        request.setAuthPassword(umaUserSecret);
        request.getPrompts().add(Prompt.NONE);
        AuthorizeClient authorizeClient = new AuthorizeClient(authorizeUrl);
        authorizeClient.setRequest(request);
        AuthorizationResponse response1 = authorizeClient.exec();
        String scope = response1.getScope();
        String authorizationCode = response1.getCode();
        if (Util.allNotBlank((String[])new String[]{authorizationCode})) {
            TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
            tokenRequest.setCode(authorizationCode);
            tokenRequest.setRedirectUri(umaRedirectUri);
            tokenRequest.setAuthUsername(umaClientId);
            tokenRequest.setAuthPassword(umaClientSecret);
            tokenRequest.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
            tokenRequest.setScope(scope);
            TokenClient tokenClient1 = new TokenClient(tokenUrl);
            tokenClient1.setRequest(tokenRequest);
            TokenResponse response2 = tokenClient1.exec();
            if (response2.getStatus() == 200) {
                String patToken = response2.getAccessToken();
                String patRefreshToken = response2.getRefreshToken();
                Integer expiresIn = response2.getExpiresIn();
                if (Util.allNotBlank((String[])new String[]{patToken, patRefreshToken})) {
                    return new Token(authorizationCode, patRefreshToken, patToken, scope, expiresIn);
                }
            }
        }
        return null;
    }

    public static Token request(String tokenUrl, String umaClientId, String umaClientSecret, UmaScopeType scopeType, ClientHttpEngine engine, String ... scopeArray) {
        TokenResponse response;
        StringBuilder scope = new StringBuilder(scopeType.getValue());
        if (scopeArray != null && scopeArray.length > 0) {
            for (String s : scopeArray) {
                scope.append(" ").append(s);
            }
        }
        TokenClient tokenClient = new TokenClient(tokenUrl);
        if (engine != null) {
            tokenClient.setExecutor(engine);
        }
        if ((response = tokenClient.execClientCredentialsGrant(scope.toString(), umaClientId, umaClientSecret)).getStatus() == 200) {
            String patToken = response.getAccessToken();
            Integer expiresIn = response.getExpiresIn();
            if (Util.allNotBlank((String[])new String[]{patToken})) {
                return new Token(null, null, patToken, scopeType.getValue(), expiresIn);
            }
        }
        return null;
    }

    public static Token requestWithClientSecretJwt(String tokenUrl, String umaClientId, String umaClientSecret, AuthenticationMethod authenticationMethod, SignatureAlgorithm signatureAlgorithm, String audience, UmaScopeType scopeType, String ... scopeArray) {
        StringBuilder scope = new StringBuilder(scopeType.getValue());
        if (scopeArray != null && scopeArray.length > 0) {
            for (String s : scopeArray) {
                scope.append(" ").append(s);
            }
        }
        TokenRequest request = new TokenRequest(GrantType.CLIENT_CREDENTIALS);
        request.setAuthUsername(umaClientId);
        request.setAuthPassword(umaClientSecret);
        request.setScope(scope.toString());
        request.setAuthenticationMethod(authenticationMethod);
        request.setAlgorithm(signatureAlgorithm);
        request.setAudience(audience);
        return UmaClient.request(tokenUrl, request);
    }

    public static Token request(String tokenUrl, TokenRequest tokenRequest) {
        if (tokenRequest.getGrantType() != GrantType.CLIENT_CREDENTIALS) {
            return null;
        }
        TokenClient tokenClient = new TokenClient(tokenUrl);
        tokenClient.setRequest(tokenRequest);
        TokenResponse response = tokenClient.exec();
        if (response.getStatus() == 200) {
            String patToken = response.getAccessToken();
            Integer expiresIn = response.getExpiresIn();
            if (Util.allNotBlank((String[])new String[]{patToken})) {
                return new Token(null, null, patToken, response.getScope(), expiresIn);
            }
        }
        return null;
    }

    private static Token request(String tokenUrl, String clientKeyStoreFile, String clientKeyStorePassword, String clientId, String keyId, TokenRequest tokenRequest) throws UmaException {
        AuthCryptoProvider cryptoProvider;
        try {
            cryptoProvider = new AuthCryptoProvider(clientKeyStoreFile, clientKeyStorePassword, null);
        }
        catch (Exception ex) {
            throw new UmaException("Failed to initialize crypto provider");
        }
        try {
            String tmpKeyId = keyId;
            if (StringHelper.isEmpty((String)keyId)) {
                tmpKeyId = cryptoProvider.getKeys().stream().filter(k -> k.contains("_sig_")).findFirst().orElse(null);
                if (StringHelper.isEmpty((String)tmpKeyId)) {
                    throw new UmaException("Unable to find a key in the keystore with use = sig");
                }
            } else if (keyId.contains("_enc_")) {
                throw new UmaException("Encryption keys not allowed. Supply a key having use = sig");
            }
            SignatureAlgorithm algorithm = cryptoProvider.getSignatureAlgorithm(tmpKeyId);
            tokenRequest.setAuthenticationMethod(AuthenticationMethod.PRIVATE_KEY_JWT);
            tokenRequest.setAuthUsername(clientId);
            tokenRequest.setCryptoProvider((AbstractCryptoProvider)cryptoProvider);
            tokenRequest.setAlgorithm(algorithm);
            tokenRequest.setKeyId(tmpKeyId);
            tokenRequest.setAudience(tokenUrl);
            return UmaClient.request(tokenUrl, tokenRequest);
        }
        catch (Exception ex) {
            throw new UmaException("Failed to obtain valid UMA PAT token", ex);
        }
    }
}

