/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client.ssa.validate;

import io.jans.as.client.BaseClient;
import io.jans.as.client.ssa.validate.SsaValidateRequest;
import io.jans.as.client.ssa.validate.SsaValidateResponse;
import jakarta.ws.rs.client.Invocation;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SsaValidateClient
extends BaseClient<SsaValidateRequest, SsaValidateResponse> {
    private static final Logger LOG = Logger.getLogger(SsaValidateClient.class);

    public SsaValidateClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "HEAD";
    }

    public SsaValidateResponse execSsaValidate(@NotNull String jti) {
        SsaValidateRequest ssaGetRequest = new SsaValidateRequest();
        ssaGetRequest.setJti(jti);
        this.setRequest(ssaGetRequest);
        return this.exec();
    }

    public SsaValidateResponse exec() {
        try {
            this.initClient();
            Invocation.Builder clientRequest = this.webTarget.request();
            this.applyCookies(clientRequest);
            clientRequest.header("Content-Type", (Object)((SsaValidateRequest)this.request).getContentType());
            clientRequest.header("jti", (Object)((SsaValidateRequest)this.request).getJti());
            this.clientResponse = clientRequest.build("HEAD").invoke();
            SsaValidateResponse res = new SsaValidateResponse(this.clientResponse);
            this.setResponse(res);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return (SsaValidateResponse)this.getResponse();
    }
}

