/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client.ssa.jwtssa;

import io.jans.as.client.BaseClient;
import io.jans.as.client.ssa.jwtssa.SsaGetJwtRequest;
import io.jans.as.client.ssa.jwtssa.SsaGetJwtResponse;
import jakarta.ws.rs.client.Invocation;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SsaGetJwtClient
extends BaseClient<SsaGetJwtRequest, SsaGetJwtResponse> {
    private static final Logger log = Logger.getLogger(SsaGetJwtClient.class);

    public SsaGetJwtClient(String url) {
        super(url + "/jwt");
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    public SsaGetJwtResponse execGetJwtSsa(@NotNull String accessToken, @NotNull String jti) {
        SsaGetJwtRequest ssaGetRequest = new SsaGetJwtRequest();
        ssaGetRequest.setJti(jti);
        ssaGetRequest.setAccessToken(accessToken);
        this.setRequest(ssaGetRequest);
        return this.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SsaGetJwtResponse exec() {
        try {
            this.initClient();
            String uriWithParams = this.getUrl() + "?" + ((SsaGetJwtRequest)this.getRequest()).getQueryString();
            Invocation.Builder clientRequest = this.resteasyClient.target(uriWithParams).request();
            this.applyCookies(clientRequest);
            clientRequest.header("Content-Type", (Object)((SsaGetJwtRequest)this.request).getContentType());
            if (StringUtils.isNotBlank((String)((SsaGetJwtRequest)this.request).getAccessToken())) {
                clientRequest.header("Authorization", (Object)"Bearer ".concat(((SsaGetJwtRequest)this.request).getAccessToken()));
            }
            this.clientResponse = clientRequest.build(this.getHttpMethod()).invoke();
            SsaGetJwtResponse res = new SsaGetJwtResponse(this.clientResponse);
            res.injectDataFromJson();
            this.setResponse(res);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return (SsaGetJwtResponse)this.getResponse();
    }
}

