/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client.ssa.get;

import io.jans.as.client.BaseResponseWithErrors;
import io.jans.as.client.ssa.get.SsaGetJson;
import io.jans.as.client.util.ClientUtil;
import io.jans.as.model.ssa.SsaErrorResponseType;
import io.jans.as.model.ssa.SsaRequestParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SsaGetResponse
extends BaseResponseWithErrors<SsaErrorResponseType> {
    private static final Logger LOG = Logger.getLogger(SsaGetResponse.class);
    private List<SsaGetJson> ssaList = new ArrayList<SsaGetJson>();

    public SsaGetResponse() {
    }

    public SsaGetResponse(Response clientResponse) {
        super(clientResponse);
    }

    public List<SsaGetJson> getSsaList() {
        return this.ssaList;
    }

    public void setSsaList(List<SsaGetJson> ssaList) {
        this.ssaList = ssaList;
    }

    @Override
    public SsaErrorResponseType fromString(String p_str) {
        return SsaErrorResponseType.fromString((String)p_str);
    }

    public void injectDataFromJson() {
        this.injectDataFromJson(this.entity);
    }

    @Override
    public void injectDataFromJson(String json) {
        if (StringUtils.isNotBlank((String)this.entity)) {
            try {
                JSONArray jsonArray = new JSONArray(this.entity);
                if (!jsonArray.isEmpty()) {
                    for (Object item : jsonArray) {
                        if (!(item instanceof JSONObject)) continue;
                        JSONObject ssaWrapper = (JSONObject)item;
                        SsaGetJson ssaGetJson = new SsaGetJson();
                        ssaGetJson.setJsonObject(ssaWrapper);
                        if (ssaWrapper.has(SsaRequestParam.SSA.getName())) {
                            JSONObject ssaJson = ssaWrapper.getJSONObject(SsaRequestParam.SSA.getName());
                            ssaGetJson.setJti(ClientUtil.stringOrNull(ssaJson, SsaRequestParam.JTI.getName()));
                        }
                        this.ssaList.add(ssaGetJson);
                    }
                }
            }
            catch (JSONException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

