/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client.ssa.get;

import io.jans.as.client.BaseClient;
import io.jans.as.client.ssa.get.SsaGetRequest;
import io.jans.as.client.ssa.get.SsaGetResponse;
import jakarta.ws.rs.client.Invocation;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SsaGetClient
extends BaseClient<SsaGetRequest, SsaGetResponse> {
    private static final Logger LOG = Logger.getLogger(SsaGetClient.class);

    public SsaGetClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    public SsaGetResponse execSsaGet(String accessToken, String jti, String orgId) {
        SsaGetRequest ssaGetRequest = new SsaGetRequest();
        ssaGetRequest.setAccessToken(accessToken);
        ssaGetRequest.setJti(jti);
        ssaGetRequest.setOrgId(orgId);
        this.setRequest(ssaGetRequest);
        return this.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SsaGetResponse exec() {
        try {
            this.initClient();
            String uriWithParams = this.getUrl() + "?" + ((SsaGetRequest)this.getRequest()).getQueryString();
            Invocation.Builder clientRequest = this.resteasyClient.target(uriWithParams).request();
            this.applyCookies(clientRequest);
            clientRequest.header("Content-Type", (Object)((SsaGetRequest)this.request).getContentType());
            if (StringUtils.isNotBlank((String)((SsaGetRequest)this.request).getAccessToken())) {
                clientRequest.header("Authorization", (Object)"Bearer ".concat(((SsaGetRequest)this.request).getAccessToken()));
            }
            this.clientResponse = clientRequest.buildGet().invoke();
            SsaGetResponse ssaGetResponse = new SsaGetResponse(this.clientResponse);
            ssaGetResponse.injectDataFromJson();
            this.setResponse(ssaGetResponse);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return (SsaGetResponse)this.getResponse();
    }
}

