/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client.fido.u2f;

import io.jans.as.client.fido.u2f.AuthenticationRequestService;
import io.jans.as.client.fido.u2f.RegistrationRequestService;
import io.jans.as.client.fido.u2f.U2fConfigurationService;
import io.jans.as.client.service.ClientFactory;
import io.jans.as.model.fido.u2f.U2fConfiguration;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.UriBuilder;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient43Engine;

public class FidoU2fClientFactory {
    private static final FidoU2fClientFactory instance = new FidoU2fClientFactory();
    private final ApacheHttpClient43Engine engine = ClientFactory.instance().createEngine();

    private FidoU2fClientFactory() {
    }

    public static FidoU2fClientFactory instance() {
        return instance;
    }

    public U2fConfigurationService createMetaDataConfigurationService(String u2fMetaDataUri) {
        ResteasyClient client = ((ResteasyClientBuilder)ClientBuilder.newBuilder()).httpEngine((ClientHttpEngine)this.engine).build();
        ResteasyWebTarget target = client.target(UriBuilder.fromPath((String)u2fMetaDataUri));
        return (U2fConfigurationService)target.proxy(U2fConfigurationService.class);
    }

    public AuthenticationRequestService createAuthenticationRequestService(U2fConfiguration metadataConfiguration) {
        ResteasyClient client = ((ResteasyClientBuilder)ClientBuilder.newBuilder()).httpEngine((ClientHttpEngine)this.engine).build();
        ResteasyWebTarget target = client.target(UriBuilder.fromPath((String)metadataConfiguration.getAuthenticationEndpoint()));
        return (AuthenticationRequestService)target.proxy(AuthenticationRequestService.class);
    }

    public RegistrationRequestService createRegistrationRequestService(U2fConfiguration metadataConfiguration) {
        ResteasyClient client = ((ResteasyClientBuilder)ClientBuilder.newBuilder()).httpEngine((ClientHttpEngine)this.engine).build();
        ResteasyWebTarget target = client.target(UriBuilder.fromPath((String)metadataConfiguration.getRegistrationEndpoint()));
        return (RegistrationRequestService)target.proxy(RegistrationRequestService.class);
    }
}

