/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client.ciba.fcm;

import io.jans.as.client.BaseClient;
import io.jans.as.client.ciba.fcm.FirebaseCloudMessagingRequest;
import io.jans.as.client.ciba.fcm.FirebaseCloudMessagingResponse;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class FirebaseCloudMessagingClient
extends BaseClient<FirebaseCloudMessagingRequest, FirebaseCloudMessagingResponse> {
    private static final Logger LOG = Logger.getLogger(FirebaseCloudMessagingClient.class);

    public FirebaseCloudMessagingClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "POST";
    }

    public FirebaseCloudMessagingResponse execFirebaseCloudMessaging(String key, String to, String title, String body, String clickAction) {
        this.setRequest(new FirebaseCloudMessagingRequest(key, to, title, body, clickAction));
        return this.exec();
    }

    public FirebaseCloudMessagingResponse exec() {
        this.initClient();
        return this._exec();
    }

    private FirebaseCloudMessagingResponse _exec() {
        try {
            Invocation.Builder clientRequest = this.webTarget.request();
            this.applyCookies(clientRequest);
            clientRequest.header("Content-Type", (Object)((FirebaseCloudMessagingRequest)this.getRequest()).getContentType());
            clientRequest.accept(new String[]{((FirebaseCloudMessagingRequest)this.getRequest()).getMediaType()});
            if (StringUtils.isNotBlank((String)((FirebaseCloudMessagingRequest)this.getRequest()).getKey())) {
                clientRequest.header("Authorization", (Object)("key=" + ((FirebaseCloudMessagingRequest)this.getRequest()).getKey()));
            }
            JSONObject requestBody = ((FirebaseCloudMessagingRequest)this.getRequest()).getJSONParameters();
            this.clientResponse = clientRequest.buildPost(Entity.json((Object)requestBody.toString(4))).invoke();
            this.setResponse(new FirebaseCloudMessagingResponse(this.clientResponse));
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return (FirebaseCloudMessagingResponse)this.getResponse();
    }
}

