/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client.builder;

import io.jans.as.client.ClientUtils;
import io.jans.as.client.RegisterClient;
import io.jans.as.client.RegisterRequest;
import io.jans.as.client.RegisterResponse;
import io.jans.as.client.builder.Builder;
import io.jans.as.model.common.AuthenticationMethod;
import io.jans.as.model.common.BackchannelTokenDeliveryMode;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.common.SubjectType;
import io.jans.as.model.crypto.signature.AsymmetricSignatureAlgorithm;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.register.ApplicationType;
import java.util.List;

public class RegistrationBuilder
implements Builder {
    private ApplicationType applicationType = ApplicationType.WEB;
    private SubjectType subjectType;
    private String clientName = "jans test app";
    private String jwks;
    private List<String> redirectUris;
    private String registrationEndpoint;
    private String sectorIdentifierUri;
    private String jwksUri;
    private String backchannelClientNotificationEndPoint;
    private BackchannelTokenDeliveryMode backchannelTokenDeliveryMode;
    private AsymmetricSignatureAlgorithm backchannekAuthRequestSigningAlgorithm;
    private AuthenticationMethod tokenEndpointAuthMethod;
    private Boolean backchannelUserCodeParameter;
    private SignatureAlgorithm tokenSignedResponseAlgorithm;
    private List<GrantType> grantTypeList;
    private SignatureAlgorithm tokenEndpointAuthSigningAlgorithm;
    private String registrationAccessToken;
    private boolean isUpdateMode;
    private boolean isReadMode;

    public RegistrationBuilder withRegistrationAccessToken(String registrationAccessToken) {
        this.registrationAccessToken = registrationAccessToken;
        return this;
    }

    public RegistrationBuilder withApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
        return this;
    }

    public RegistrationBuilder withClientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    public RegistrationBuilder withRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
        return this;
    }

    public RegistrationBuilder withJwks(String jwks) {
        this.jwks = jwks;
        return this;
    }

    public RegistrationBuilder withJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
        return this;
    }

    public RegistrationBuilder missingJwksUri() {
        this.jwksUri = null;
        return this;
    }

    public RegistrationBuilder withSectorIdentifierUri(String sectorIdentifierUri) {
        this.sectorIdentifierUri = sectorIdentifierUri;
        return this;
    }

    public RegistrationBuilder withGrantTypes(List<GrantType> grantTypeList) {
        this.grantTypeList = grantTypeList;
        return this;
    }

    public RegistrationBuilder withSubjectType(SubjectType subjectType) {
        this.subjectType = subjectType;
        return this;
    }

    public RegistrationBuilder withRegistrationEndpoint(String registrationEndpoint) {
        this.registrationEndpoint = registrationEndpoint;
        return this;
    }

    public RegistrationBuilder withBackchannelTokenDeliveryMode(BackchannelTokenDeliveryMode backchannelTokenDeliveryMode) {
        this.backchannelTokenDeliveryMode = backchannelTokenDeliveryMode;
        return this;
    }

    public RegistrationBuilder missingBackchannelTokenDeliveryMode() {
        this.backchannelTokenDeliveryMode = null;
        return this;
    }

    public RegistrationBuilder withBackchannelClientNotificationEndPoint(String backchannelClientNotificationEndPoint) {
        this.backchannelClientNotificationEndPoint = backchannelClientNotificationEndPoint;
        return this;
    }

    public RegistrationBuilder missingBackchannelClientNotificationEndPoint() {
        this.backchannelClientNotificationEndPoint = null;
        return this;
    }

    public RegistrationBuilder withBackchannelAuthRequestSigningAlgorithm(AsymmetricSignatureAlgorithm backchannekAuthRequestSigningAlgorithm) {
        this.backchannekAuthRequestSigningAlgorithm = backchannekAuthRequestSigningAlgorithm;
        return this;
    }

    public RegistrationBuilder withBackchannelUserCodeParameter(Boolean backchannelUserCodeParameter) {
        this.backchannelUserCodeParameter = backchannelUserCodeParameter;
        return this;
    }

    public RegistrationBuilder withTokenEndPointAuthMethod(AuthenticationMethod tokenEndPointAuthenticationMethod) {
        this.tokenEndpointAuthMethod = tokenEndPointAuthenticationMethod;
        return this;
    }

    public RegistrationBuilder missingTokenEndPointAuthMethod() {
        this.tokenEndpointAuthMethod = null;
        return this;
    }

    public RegistrationBuilder withTokenEndPointAuthSigningAlgorithm(SignatureAlgorithm tokenEndpointAuthSigningAlgorithm) {
        this.tokenEndpointAuthSigningAlgorithm = tokenEndpointAuthSigningAlgorithm;
        return this;
    }

    public RegistrationBuilder withTokenSignedResponseAlgorithm(SignatureAlgorithm tokenSignedResponseAlgorithm) {
        this.tokenSignedResponseAlgorithm = tokenSignedResponseAlgorithm;
        return this;
    }

    public RegistrationBuilder isUpdateMode() {
        this.isUpdateMode = true;
        this.isReadMode = false;
        return this;
    }

    public RegistrationBuilder isReadMode() {
        this.isReadMode = true;
        this.isUpdateMode = false;
        return this;
    }

    @Override
    public RegisterResponse execute() {
        RegisterRequest registerRequest = this.isReadMode || this.isUpdateMode ? new RegisterRequest(this.registrationAccessToken) : new RegisterRequest(this.applicationType, this.clientName, this.redirectUris);
        if (this.isUpdateMode) {
            registerRequest.setHttpMethod("PUT");
        }
        if (this.subjectType != null) {
            registerRequest.setSubjectType(this.subjectType);
        }
        if (this.jwksUri != null) {
            registerRequest.setJwksUri(this.jwksUri);
        }
        if (this.grantTypeList != null) {
            registerRequest.setGrantTypes(this.grantTypeList);
        }
        if (this.sectorIdentifierUri != null) {
            registerRequest.setSectorIdentifierUri(this.sectorIdentifierUri);
        }
        if (this.backchannelUserCodeParameter != null) {
            registerRequest.setBackchannelUserCodeParameter(this.backchannelUserCodeParameter);
        }
        if (this.backchannelTokenDeliveryMode != null) {
            registerRequest.setBackchannelTokenDeliveryMode(this.backchannelTokenDeliveryMode);
        }
        if (this.backchannelClientNotificationEndPoint != null) {
            registerRequest.setBackchannelClientNotificationEndpoint(this.backchannelClientNotificationEndPoint);
        }
        if (this.backchannekAuthRequestSigningAlgorithm != null) {
            registerRequest.setBackchannelAuthenticationRequestSigningAlg(this.backchannekAuthRequestSigningAlgorithm);
        }
        if (this.tokenEndpointAuthMethod != null) {
            registerRequest.setTokenEndpointAuthMethod(this.tokenEndpointAuthMethod);
        }
        if (this.tokenSignedResponseAlgorithm != null) {
            registerRequest.setIdTokenSignedResponseAlg(this.tokenSignedResponseAlgorithm);
        }
        if (this.tokenEndpointAuthSigningAlgorithm != null) {
            registerRequest.setTokenEndpointAuthSigningAlg(this.tokenEndpointAuthSigningAlgorithm);
        }
        if (this.jwks != null) {
            registerRequest.setJwks(this.jwks);
        }
        RegisterClient registerClient = new RegisterClient(this.registrationEndpoint);
        registerClient.setRequest(registerRequest);
        RegisterResponse response = registerClient.exec();
        ClientUtils.showClient(registerClient);
        return response;
    }
}

