/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.ClientAuthnRequest;
import io.jans.as.model.common.AuthenticationMethod;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.jwt.DPoP;
import io.jans.as.model.token.ClientAssertionType;
import io.jans.as.model.uma.UmaScopeType;
import io.jans.as.model.util.QueryBuilder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TokenRequest
extends ClientAuthnRequest {
    private GrantType grantType;
    private String code;
    private String redirectUri;
    private String username;
    private String password;
    private String scope;
    private String assertion;
    private String refreshToken;
    private String codeVerifier;
    private String authReqId;
    private String deviceCode;
    private String subjectToken;
    private String subjectTokenType;
    private String actorToken;
    private String actorTokenType;
    private String requestedTokenType;
    private DPoP dpop;

    public TokenRequest(GrantType grantType) {
        this.grantType = grantType;
        this.setContentType("application/x-www-form-urlencoded");
        this.setAuthenticationMethod(AuthenticationMethod.CLIENT_SECRET_BASIC);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder umaBuilder() {
        return new Builder().grantType(GrantType.CLIENT_CREDENTIALS);
    }

    public String getSubjectToken() {
        return this.subjectToken;
    }

    public void setSubjectToken(String subjectToken) {
        this.subjectToken = subjectToken;
    }

    public String getSubjectTokenType() {
        return this.subjectTokenType;
    }

    public void setSubjectTokenType(String subjectTokenType) {
        this.subjectTokenType = subjectTokenType;
    }

    public String getActorToken() {
        return this.actorToken;
    }

    public void setActorToken(String actorToken) {
        this.actorToken = actorToken;
    }

    public String getActorTokenType() {
        return this.actorTokenType;
    }

    public void setActorTokenType(String actorTokenType) {
        this.actorTokenType = actorTokenType;
    }

    public String getRequestedTokenType() {
        return this.requestedTokenType;
    }

    public void setRequestedTokenType(String requestedTokenType) {
        this.requestedTokenType = requestedTokenType;
    }

    public GrantType getGrantType() {
        return this.grantType;
    }

    public void setGrantType(GrantType grantType) {
        this.grantType = grantType;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCodeVerifier() {
        return this.codeVerifier;
    }

    public void setCodeVerifier(String codeVerifier) {
        this.codeVerifier = codeVerifier;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getAssertion() {
        return this.assertion;
    }

    public void setAssertion(String assertion) {
        this.assertion = assertion;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getAuthReqId() {
        return this.authReqId;
    }

    public void setAuthReqId(String authReqId) {
        this.authReqId = authReqId;
    }

    public String getDeviceCode() {
        return this.deviceCode;
    }

    public void setDeviceCode(String deviceCode) {
        this.deviceCode = deviceCode;
    }

    public DPoP getDpop() {
        return this.dpop;
    }

    public void setDpop(DPoP dpop) {
        this.dpop = dpop;
    }

    @Override
    public String getQueryString() {
        QueryBuilder builder = QueryBuilder.instance();
        builder.appendIfNotNull("grant_type", (Object)this.grantType);
        builder.append("code", this.code);
        builder.append("redirect_uri", this.redirectUri);
        builder.append("scope", this.scope);
        builder.append("username", this.username);
        builder.append("password", this.password);
        builder.append("assertion", this.assertion);
        builder.append("refresh_token", this.refreshToken);
        builder.append("auth_req_id", this.authReqId);
        builder.append("device_code", this.deviceCode);
        builder.append("audience", this.getAudience());
        builder.append("subject_token", this.subjectToken);
        builder.append("subject_token_type", this.subjectTokenType);
        builder.append("actor_token", this.actorToken);
        builder.append("actor_token_type", this.actorTokenType);
        builder.append("requested_token_type", this.requestedTokenType);
        this.appendClientAuthnToQuery(builder);
        for (String key : this.getCustomParameters().keySet()) {
            builder.append(key, this.getCustomParameters().get(key));
        }
        return builder.toString();
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (this.grantType != null) {
            parameters.put("grant_type", this.grantType.toString());
        }
        if (this.code != null && !this.code.isEmpty()) {
            parameters.put("code", this.code);
        }
        if (this.redirectUri != null && !this.redirectUri.isEmpty()) {
            parameters.put("redirect_uri", this.redirectUri);
        }
        if (this.username != null && !this.username.isEmpty()) {
            parameters.put("username", this.username);
        }
        if (StringUtils.isNotBlank((String)this.getAudience())) {
            parameters.put("audience", this.getAudience());
        }
        if (StringUtils.isNotBlank((String)this.subjectToken)) {
            parameters.put("subject_token", this.subjectToken);
        }
        if (StringUtils.isNotBlank((String)this.subjectTokenType)) {
            parameters.put("subject_token_type", this.subjectTokenType);
        }
        if (StringUtils.isNotBlank((String)this.actorToken)) {
            parameters.put("actor_token", this.actorToken);
        }
        if (StringUtils.isNotBlank((String)this.actorTokenType)) {
            parameters.put("actor_token_type", this.actorTokenType);
        }
        if (StringUtils.isNotBlank((String)this.requestedTokenType)) {
            parameters.put("requested_token_type", this.requestedTokenType);
        }
        if (this.password != null && !this.password.isEmpty()) {
            parameters.put("password", this.password);
        }
        if (this.scope != null && !this.scope.isEmpty()) {
            parameters.put("scope", this.scope);
        }
        if (this.assertion != null && !this.assertion.isEmpty()) {
            parameters.put("assertion", this.assertion);
        }
        if (this.refreshToken != null && !this.refreshToken.isEmpty()) {
            parameters.put("refresh_token", this.refreshToken);
        }
        if (this.getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_POST) {
            if (this.getAuthUsername() != null && !this.getAuthUsername().isEmpty()) {
                parameters.put("client_id", this.getAuthUsername());
            }
            if (this.getAuthPassword() != null && !this.getAuthPassword().isEmpty()) {
                parameters.put("client_secret", this.getAuthPassword());
            }
        } else if (this.getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_JWT || this.getAuthenticationMethod() == AuthenticationMethod.PRIVATE_KEY_JWT) {
            parameters.put("client_assertion_type", ClientAssertionType.JWT_BEARER.toString());
            parameters.put("client_assertion", this.getClientAssertion());
        }
        for (String key : this.getCustomParameters().keySet()) {
            parameters.put(key, this.getCustomParameters().get(key));
        }
        return parameters;
    }

    public static class Builder {
        private GrantType grantType;
        private String scope;

        public Builder grantType(GrantType grantType) {
            this.grantType = grantType;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder pat(String ... scopeArray) {
            StringBuilder scope = new StringBuilder(UmaScopeType.PROTECTION.getValue());
            if (scopeArray != null && scopeArray.length > 0) {
                for (String s : scopeArray) {
                    scope.append(" ").append(s);
                }
            }
            return this.scope(scope.toString());
        }

        public TokenRequest build() {
            TokenRequest request = new TokenRequest(this.grantType);
            request.setScope(this.scope);
            return request;
        }
    }
}

