/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseClient;
import io.jans.as.client.ClientAuthnEnabler;
import io.jans.as.client.ClientAuthnRequest;
import io.jans.as.client.TokenRequest;
import io.jans.as.client.TokenResponse;
import io.jans.as.model.common.GrantType;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Form;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TokenClient
extends BaseClient<TokenRequest, TokenResponse> {
    private static final Logger LOG = Logger.getLogger(TokenClient.class);

    public TokenClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "POST";
    }

    public TokenResponse execAuthorizationCode(String code, String redirectUri, String clientId, String clientSecret) {
        this.setRequest(new TokenRequest(GrantType.AUTHORIZATION_CODE));
        ((TokenRequest)this.getRequest()).setCode(code);
        ((TokenRequest)this.getRequest()).setRedirectUri(redirectUri);
        ((TokenRequest)this.getRequest()).setAuthUsername(clientId);
        ((TokenRequest)this.getRequest()).setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenResponse execResourceOwnerPasswordCredentialsGrant(String username, String password, String scope, String clientId, String clientSecret) {
        this.setRequest(new TokenRequest(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS));
        ((TokenRequest)this.getRequest()).setUsername(username);
        ((TokenRequest)this.getRequest()).setPassword(password);
        ((TokenRequest)this.getRequest()).setScope(scope);
        ((TokenRequest)this.getRequest()).setAuthUsername(clientId);
        ((TokenRequest)this.getRequest()).setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenResponse execClientCredentialsGrant(String scope, String clientId, String clientSecret) {
        this.setRequest(new TokenRequest(GrantType.CLIENT_CREDENTIALS));
        ((TokenRequest)this.getRequest()).setScope(scope);
        ((TokenRequest)this.getRequest()).setAuthUsername(clientId);
        ((TokenRequest)this.getRequest()).setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenResponse execExtensionGrant(String grantTypeUri, String assertion, String clientId, String clientSecret) {
        GrantType grantType = GrantType.fromString((String)grantTypeUri);
        this.setRequest(new TokenRequest(grantType));
        ((TokenRequest)this.getRequest()).setAssertion(assertion);
        ((TokenRequest)this.getRequest()).setAuthUsername(clientId);
        ((TokenRequest)this.getRequest()).setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenResponse execRefreshToken(String scope, String refreshToken, String clientId, String clientSecret) {
        this.setRequest(new TokenRequest(GrantType.REFRESH_TOKEN));
        ((TokenRequest)this.getRequest()).setScope(scope);
        ((TokenRequest)this.getRequest()).setRefreshToken(refreshToken);
        ((TokenRequest)this.getRequest()).setAuthUsername(clientId);
        ((TokenRequest)this.getRequest()).setAuthPassword(clientSecret);
        return this.exec();
    }

    public TokenResponse exec() {
        try {
            this.initClient();
            this.addFormParameterIfNotNull("grant_type", ((TokenRequest)this.getRequest()).getGrantType());
            this.addFormParameterIfNotBlank("code", ((TokenRequest)this.getRequest()).getCode());
            this.addFormParameterIfNotBlank("code_verifier", ((TokenRequest)this.getRequest()).getCodeVerifier());
            this.addFormParameterIfNotBlank("redirect_uri", ((TokenRequest)this.getRequest()).getRedirectUri());
            this.addFormParameterIfNotBlank("username", ((TokenRequest)this.getRequest()).getUsername());
            this.addFormParameterIfNotBlank("password", ((TokenRequest)this.getRequest()).getPassword());
            this.addFormParameterIfNotBlank("scope", ((TokenRequest)this.getRequest()).getScope());
            this.addFormParameterIfNotBlank("assertion", ((TokenRequest)this.getRequest()).getAssertion());
            this.addFormParameterIfNotBlank("refresh_token", ((TokenRequest)this.getRequest()).getRefreshToken());
            this.addFormParameterIfNotBlank("auth_req_id", ((TokenRequest)this.getRequest()).getAuthReqId());
            this.addFormParameterIfNotBlank("device_code", ((TokenRequest)this.getRequest()).getDeviceCode());
            this.addFormParameterIfNotBlank("audience", ((TokenRequest)this.getRequest()).getAudience());
            this.addFormParameterIfNotBlank("subject_token", ((TokenRequest)this.getRequest()).getSubjectToken());
            this.addFormParameterIfNotBlank("subject_token_type", ((TokenRequest)this.getRequest()).getSubjectTokenType());
            this.addFormParameterIfNotBlank("actor_token", ((TokenRequest)this.getRequest()).getActorToken());
            this.addFormParameterIfNotBlank("actor_token_type", ((TokenRequest)this.getRequest()).getActorTokenType());
            this.addFormParameterIfNotBlank("requested_token_type", ((TokenRequest)this.getRequest()).getRequestedTokenType());
            for (String key : ((TokenRequest)this.getRequest()).getCustomParameters().keySet()) {
                this.addFormParameterIfNotBlank(key, ((TokenRequest)this.getRequest()).getCustomParameters().get(key));
            }
            Invocation.Builder clientRequest = this.webTarget.request();
            this.applyCookies(clientRequest);
            new ClientAuthnEnabler(clientRequest, this.requestForm).exec((ClientAuthnRequest)this.request);
            clientRequest.header("Content-Type", (Object)((TokenRequest)this.request).getContentType());
            if (((TokenRequest)this.getRequest()).getDpop() != null) {
                clientRequest.header("DPoP", (Object)((TokenRequest)this.getRequest()).getDpop().getEncodedJwt());
            }
            this.clientResponse = clientRequest.buildPost(Entity.form((Form)this.requestForm)).invoke();
            TokenResponse tokenResponse = new TokenResponse(this.clientResponse);
            tokenResponse.injectDataFromJson();
            this.setResponse(tokenResponse);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return (TokenResponse)this.getResponse();
    }

    private void addFormParameterIfNotBlank(String paramName, String value) {
        if (StringUtils.isNotBlank((String)value)) {
            this.addFormParameterIfNotNull(paramName, value);
        }
    }

    private void addFormParameterIfNotNull(String paramName, Object value) {
        if (value != null) {
            this.requestForm.param(paramName, value.toString());
        }
    }
}

