/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import com.google.common.collect.Lists;
import io.jans.as.client.BaseResponseWithErrors;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.common.ResponseType;
import io.jans.as.model.register.RegisterErrorResponseType;
import io.jans.as.model.register.RegisterRequestParam;
import io.jans.as.model.register.RegisterResponseParam;
import io.jans.as.model.util.Util;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class RegisterResponse
extends BaseResponseWithErrors<RegisterErrorResponseType> {
    private static final Logger LOG = Logger.getLogger(RegisterResponse.class);
    private String clientId;
    private String clientSecret;
    private String registrationAccessToken;
    private String registrationClientUri;
    private Date clientIdIssuedAt;
    private Date clientSecretExpiresAt;
    private List<ResponseType> responseTypes;
    private List<GrantType> grantTypes;

    public RegisterResponse() {
    }

    public RegisterResponse(Response clientResponse) {
        super(clientResponse);
        this.setHeaders((MultivaluedMap<String, Object>)clientResponse.getMetadata());
        this.injectDataFromJson(this.entity);
    }

    @Override
    public RegisterErrorResponseType fromString(String string) {
        return RegisterErrorResponseType.fromString((String)string);
    }

    public void injectDataFromJson() {
        this.injectDataFromJson(this.getEntity());
    }

    public static RegisterResponse valueOf(String json) {
        RegisterResponse r = new RegisterResponse();
        r.injectDataFromJson(json);
        return r;
    }

    @Override
    public void injectDataFromJson(String json) {
        if (StringUtils.isBlank((String)json)) {
            return;
        }
        try {
            JSONObject jsonObj = new JSONObject(json);
            if (jsonObj.has(RegisterResponseParam.CLIENT_ID.toString())) {
                this.setClientId(jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString()));
                jsonObj.remove(RegisterResponseParam.CLIENT_ID.toString());
            }
            if (jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString())) {
                this.setClientSecret(jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString()));
                jsonObj.remove(RegisterResponseParam.CLIENT_SECRET.toString());
            }
            if (jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString())) {
                this.setRegistrationAccessToken(jsonObj.getString(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
                jsonObj.remove(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString());
            }
            if (jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString())) {
                this.setRegistrationClientUri(jsonObj.getString(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
                jsonObj.remove(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString());
            }
            if (jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString())) {
                long clientIdIssAt = jsonObj.getLong(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString());
                if (clientIdIssAt > 0L) {
                    this.setClientIdIssuedAt(new Date(clientIdIssAt * 1000L));
                }
                jsonObj.remove(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString());
            }
            if (jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString())) {
                long clientSecretExpAt = jsonObj.getLong(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString());
                if (clientSecretExpAt > 0L) {
                    this.setClientSecretExpiresAt(new Date(clientSecretExpAt * 1000L));
                }
                jsonObj.remove(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString());
            }
            if (jsonObj.has(RegisterRequestParam.RESPONSE_TYPES.toString())) {
                JSONArray responseTypesJsonArray = jsonObj.getJSONArray(RegisterRequestParam.RESPONSE_TYPES.toString());
                this.responseTypes = Util.asEnumList((JSONArray)responseTypesJsonArray, ResponseType.class);
            }
            if (jsonObj.has(RegisterRequestParam.GRANT_TYPES.toString())) {
                JSONArray grantTypesJsonArray = jsonObj.getJSONArray(RegisterRequestParam.GRANT_TYPES.toString());
                this.grantTypes = Util.asEnumList((JSONArray)grantTypesJsonArray, GrantType.class);
            }
            Iterator it = jsonObj.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                this.getClaimMap().put(key, Lists.newArrayList((Object[])new String[]{String.valueOf(jsonObj.get(key))}));
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getRegistrationAccessToken() {
        return this.registrationAccessToken;
    }

    public void setRegistrationAccessToken(String registrationAccessToken) {
        this.registrationAccessToken = registrationAccessToken;
    }

    public String getRegistrationClientUri() {
        return this.registrationClientUri;
    }

    public void setRegistrationClientUri(String registrationClientUri) {
        this.registrationClientUri = registrationClientUri;
    }

    public Date getClientIdIssuedAt() {
        return this.clientIdIssuedAt != null ? new Date(this.clientIdIssuedAt.getTime()) : null;
    }

    public void setClientIdIssuedAt(Date clientIdIssuedAt) {
        this.clientIdIssuedAt = clientIdIssuedAt != null ? new Date(clientIdIssuedAt.getTime()) : null;
    }

    public Date getClientSecretExpiresAt() {
        return this.clientSecretExpiresAt != null ? new Date(this.clientSecretExpiresAt.getTime()) : null;
    }

    public void setClientSecretExpiresAt(Date clientSecretExpiresAt) {
        this.clientSecretExpiresAt = clientSecretExpiresAt != null ? new Date(clientSecretExpiresAt.getTime()) : null;
    }

    public List<ResponseType> getResponseTypes() {
        if (this.responseTypes == null) {
            this.responseTypes = new ArrayList<ResponseType>();
        }
        return this.responseTypes;
    }

    public void setResponseTypes(List<ResponseType> responseTypes) {
        this.responseTypes = responseTypes;
    }

    public List<GrantType> getGrantTypes() {
        return this.grantTypes;
    }

    public void setGrantTypes(List<GrantType> grantTypes) {
        this.grantTypes = grantTypes;
    }
}

