/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseClient;
import io.jans.as.client.RegisterRequest;
import io.jans.as.client.RegisterResponse;
import io.jans.as.client.builder.RegistrationBuilder;
import io.jans.as.client.util.ClientUtil;
import io.jans.as.model.register.ApplicationType;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;

public class RegisterClient
extends BaseClient<RegisterRequest, RegisterResponse> {
    private static final Logger LOG = Logger.getLogger(RegisterClient.class);

    public RegisterClient(String url) {
        super(url);
    }

    public static RegistrationBuilder builder() {
        return new RegistrationBuilder();
    }

    @Override
    public String getHttpMethod() {
        if (this.getRequest() != null) {
            if (StringUtils.isNotBlank((String)((RegisterRequest)this.getRequest()).getHttpMethod())) {
                return ((RegisterRequest)this.getRequest()).getHttpMethod();
            }
            if (((RegisterRequest)this.getRequest()).getRegistrationAccessToken() != null) {
                return "GET";
            }
        }
        return "POST";
    }

    public RegisterResponse execRegister(ApplicationType applicationType, String clientName, List<String> redirectUri) {
        this.setRequest(new RegisterRequest(applicationType, clientName, redirectUri));
        return this.exec();
    }

    public RegisterResponse exec() {
        this.initClient();
        return this._exec();
    }

    @Deprecated
    public RegisterResponse exec(ClientHttpEngine engine) {
        this.resteasyClient = ((ResteasyClientBuilder)ClientBuilder.newBuilder()).httpEngine(engine).build();
        this.webTarget = this.resteasyClient.target(this.getUrl());
        return this._exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegisterResponse _exec() {
        try {
            Entity requestEntity = null;
            Invocation.Builder clientRequest = this.webTarget.request();
            this.applyCookies(clientRequest);
            if (this.getHttpMethod().equals("POST") || this.getHttpMethod().equals("PUT")) {
                clientRequest.header("Content-Type", (Object)((RegisterRequest)this.getRequest()).getContentType());
                clientRequest.accept(new String[]{((RegisterRequest)this.getRequest()).getMediaType()});
                if (StringUtils.isNotBlank((String)((RegisterRequest)this.getRequest()).getRegistrationAccessToken())) {
                    clientRequest.header("Authorization", (Object)("Bearer " + ((RegisterRequest)this.getRequest()).getRegistrationAccessToken()));
                }
                String bodyString = ((RegisterRequest)this.getRequest()).hasJwtRequestAsString() ? ((RegisterRequest)this.getRequest()).getJwtRequestAsString() : ClientUtil.toPrettyJson(((RegisterRequest)this.getRequest()).getJSONParameters());
                requestEntity = Entity.json((Object)bodyString);
            } else {
                clientRequest.accept(new String[]{"application/json"});
                if (StringUtils.isNotBlank((String)((RegisterRequest)this.getRequest()).getRegistrationAccessToken())) {
                    clientRequest.header("Authorization", (Object)("Bearer " + ((RegisterRequest)this.getRequest()).getRegistrationAccessToken()));
                }
            }
            this.clientResponse = this.getHttpMethod().equals("POST") ? clientRequest.buildPost(requestEntity).invoke() : (this.getHttpMethod().equals("PUT") ? clientRequest.buildPut(requestEntity).invoke() : (this.getHttpMethod().equals("DELETE") ? clientRequest.buildDelete().invoke() : clientRequest.buildGet().invoke()));
            this.setResponse(new RegisterResponse(this.clientResponse));
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return (RegisterResponse)this.getResponse();
    }
}

