/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseClient;
import io.jans.as.client.OpenIdConnectDiscoveryRequest;
import io.jans.as.client.OpenIdConnectDiscoveryResponse;
import io.jans.as.model.discovery.WebFingerLink;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OpenIdConnectDiscoveryClient
extends BaseClient<OpenIdConnectDiscoveryRequest, OpenIdConnectDiscoveryResponse> {
    private static final Logger LOG = Logger.getLogger(OpenIdConnectDiscoveryClient.class);
    private static final String MEDIA_TYPE = "application/json";
    private static final String SCHEMA = "https://";
    private static final String PATH = "/.well-known/webfinger";

    public OpenIdConnectDiscoveryClient(String resource) throws URISyntaxException {
        this.setRequest(new OpenIdConnectDiscoveryRequest(resource));
        this.setUrl(SCHEMA + ((OpenIdConnectDiscoveryRequest)this.getRequest()).getHost() + PATH);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    public OpenIdConnectDiscoveryResponse exec() {
        this.initClient();
        return this._exec();
    }

    @Deprecated
    public OpenIdConnectDiscoveryResponse exec(ClientHttpEngine engine) {
        this.resteasyClient = ((ResteasyClientBuilder)ClientBuilder.newBuilder()).httpEngine(engine).build();
        this.webTarget = this.resteasyClient.target(this.getUrl());
        return this._exec();
    }

    private OpenIdConnectDiscoveryResponse _exec() {
        OpenIdConnectDiscoveryResponse response = null;
        try {
            response = this._exec2();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return response;
    }

    private OpenIdConnectDiscoveryResponse _exec2() {
        if (StringUtils.isNotBlank((String)((OpenIdConnectDiscoveryRequest)this.getRequest()).getResource())) {
            this.addReqParam("resource", ((OpenIdConnectDiscoveryRequest)this.getRequest()).getResource());
        }
        this.addReqParam("rel", "http://openid.net/specs/connect/1.0/issuer");
        try {
            Invocation.Builder clientRequest = this.webTarget.request();
            this.applyCookies(clientRequest);
            clientRequest.accept(new String[]{MEDIA_TYPE});
            Response clientResponse1 = clientRequest.buildGet().invoke();
            int status = clientResponse1.getStatus();
            this.setResponse(new OpenIdConnectDiscoveryResponse(status));
            String entity = (String)clientResponse1.readEntity(String.class);
            ((OpenIdConnectDiscoveryResponse)this.getResponse()).setEntity(entity);
            ((OpenIdConnectDiscoveryResponse)this.getResponse()).setHeaders((MultivaluedMap<String, Object>)clientResponse1.getMetadata());
            if (StringUtils.isNotBlank((String)entity)) {
                JSONObject jsonObj = new JSONObject(entity);
                ((OpenIdConnectDiscoveryResponse)this.getResponse()).setSubject(jsonObj.getString("subject"));
                JSONArray linksJsonArray = jsonObj.getJSONArray("links");
                for (int i = 0; i < linksJsonArray.length(); ++i) {
                    WebFingerLink webFingerLink = new WebFingerLink();
                    webFingerLink.setRel(linksJsonArray.getJSONObject(i).getString("rel"));
                    webFingerLink.setHref(linksJsonArray.getJSONObject(i).getString("href"));
                    ((OpenIdConnectDiscoveryResponse)this.getResponse()).getLinks().add(webFingerLink);
                }
            }
        }
        catch (JSONException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return (OpenIdConnectDiscoveryResponse)this.getResponse();
    }
}

