/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BaseClient;
import io.jans.as.client.ClientInfoRequest;
import io.jans.as.client.ClientInfoResponse;
import io.jans.as.client.util.ClientUtil;
import io.jans.as.model.common.AuthorizationMethod;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientInfoClient
extends BaseClient<ClientInfoRequest, ClientInfoResponse> {
    private static final Logger LOG = Logger.getLogger(ClientInfoClient.class);

    public ClientInfoClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        if (((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == null || ((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD || ((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER) {
            return "POST";
        }
        return "GET";
    }

    public ClientInfoResponse execClientInfo(String accessToken) {
        this.setRequest(new ClientInfoRequest(accessToken));
        return this.exec();
    }

    public ClientInfoResponse exec() {
        this.initClient();
        return this.execInternal();
    }

    @Deprecated
    public ClientInfoResponse exec(ClientHttpEngine engine) {
        this.resteasyClient = ((ResteasyClientBuilder)ClientBuilder.newBuilder()).httpEngine(engine).build();
        this.webTarget = this.resteasyClient.target(this.getUrl());
        return this.execInternal();
    }

    private ClientInfoResponse execInternal() {
        Invocation.Builder clientRequest = this.prepareAuthorizatedClientRequest(((ClientInfoRequest)this.getRequest()).getAuthorizationMethod(), ((ClientInfoRequest)this.getRequest()).getAccessToken());
        try {
            this.clientResponse = ((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == null || ((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD || ((ClientInfoRequest)this.getRequest()).getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER ? clientRequest.buildPost(Entity.form((Form)this.requestForm)).invoke() : clientRequest.buildGet().invoke();
            this.setResponse(new ClientInfoResponse(this.clientResponse));
            ((ClientInfoResponse)this.getResponse()).setHeaders((MultivaluedMap<String, Object>)this.clientResponse.getMetadata());
            this.parseEntity(((ClientInfoResponse)this.getResponse()).getEntity());
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return (ClientInfoResponse)this.getResponse();
    }

    private void parseEntity(String entity) {
        if (StringUtils.isBlank((String)entity)) {
            return;
        }
        try {
            JSONObject jsonObj = new JSONObject(entity);
            Iterator iterator = jsonObj.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                ((ClientInfoResponse)this.getResponse()).getClaimMap().put(key, ClientUtil.extractListByKeyOptString(jsonObj, key));
            }
        }
        catch (JSONException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

