/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.BackchannelAuthenticationRequest;
import io.jans.as.client.BackchannelAuthenticationResponse;
import io.jans.as.client.BaseClient;
import io.jans.as.client.ClientAuthnEnabler;
import io.jans.as.client.ClientAuthnRequest;
import io.jans.as.model.common.AuthenticationMethod;
import io.jans.as.model.util.Util;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Form;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class BackchannelAuthenticationClient
extends BaseClient<BackchannelAuthenticationRequest, BackchannelAuthenticationResponse> {
    private static final Logger LOG = Logger.getLogger(BackchannelAuthenticationClient.class);

    public BackchannelAuthenticationClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        return "POST";
    }

    public BackchannelAuthenticationResponse exec() {
        BackchannelAuthenticationResponse response = null;
        try {
            this.initClient();
            response = this.execInternal();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return response;
    }

    private BackchannelAuthenticationResponse execInternal() throws Exception {
        String scopesAsString = Util.listAsString(((BackchannelAuthenticationRequest)this.getRequest()).getScope());
        String acrValuesAsString = Util.listAsString(((BackchannelAuthenticationRequest)this.getRequest()).getAcrValues());
        if (StringUtils.isNotBlank((String)scopesAsString)) {
            this.requestForm.param("scope", scopesAsString);
        }
        if (StringUtils.isNotBlank((String)((BackchannelAuthenticationRequest)this.getRequest()).getClientNotificationToken())) {
            this.requestForm.param("client_notification_token", ((BackchannelAuthenticationRequest)this.getRequest()).getClientNotificationToken());
        }
        if (StringUtils.isNotBlank((String)acrValuesAsString)) {
            this.requestForm.param("acr_values", acrValuesAsString);
        }
        if (StringUtils.isNotBlank((String)((BackchannelAuthenticationRequest)this.getRequest()).getLoginHintToken())) {
            this.requestForm.param("login_hint_token", ((BackchannelAuthenticationRequest)this.getRequest()).getLoginHintToken());
        }
        if (StringUtils.isNotBlank((String)((BackchannelAuthenticationRequest)this.getRequest()).getIdTokenHint())) {
            this.requestForm.param("id_token_hint", ((BackchannelAuthenticationRequest)this.getRequest()).getIdTokenHint());
        }
        if (StringUtils.isNotBlank((String)((BackchannelAuthenticationRequest)this.getRequest()).getLoginHint())) {
            this.requestForm.param("login_hint", ((BackchannelAuthenticationRequest)this.getRequest()).getLoginHint());
        }
        if (StringUtils.isNotBlank((String)((BackchannelAuthenticationRequest)this.getRequest()).getBindingMessage())) {
            this.requestForm.param("binding_message", ((BackchannelAuthenticationRequest)this.getRequest()).getBindingMessage());
        }
        if (StringUtils.isNotBlank((String)((BackchannelAuthenticationRequest)this.getRequest()).getUserCode())) {
            this.requestForm.param("user_code", ((BackchannelAuthenticationRequest)this.getRequest()).getUserCode());
        }
        if (((BackchannelAuthenticationRequest)this.getRequest()).getRequestedExpiry() != null) {
            this.requestForm.param("requested_expiry", ((BackchannelAuthenticationRequest)this.getRequest()).getRequestedExpiry().toString());
        }
        if (StringUtils.isNotBlank((String)((BackchannelAuthenticationRequest)this.getRequest()).getClientId())) {
            this.requestForm.param("client_id", ((BackchannelAuthenticationRequest)this.getRequest()).getClientId());
        }
        if (StringUtils.isNotBlank((String)((BackchannelAuthenticationRequest)this.getRequest()).getRequest())) {
            this.requestForm.param("request", ((BackchannelAuthenticationRequest)this.getRequest()).getRequest());
        }
        if (StringUtils.isNotBlank((String)((BackchannelAuthenticationRequest)this.getRequest()).getRequestUri())) {
            this.requestForm.param("request_uri", ((BackchannelAuthenticationRequest)this.getRequest()).getRequestUri());
        }
        Invocation.Builder clientRequest = this.webTarget.request();
        this.applyCookies(clientRequest);
        clientRequest.header("Content-Type", (Object)((BackchannelAuthenticationRequest)this.request).getContentType());
        if (((BackchannelAuthenticationRequest)this.request).getAuthenticationMethod() == AuthenticationMethod.CLIENT_SECRET_BASIC && ((BackchannelAuthenticationRequest)this.request).hasCredentials()) {
            clientRequest.header("Authorization", (Object)("Basic " + ((BackchannelAuthenticationRequest)this.request).getEncodedCredentials()));
        }
        new ClientAuthnEnabler(clientRequest, this.requestForm).exec((ClientAuthnRequest)this.getRequest());
        this.clientResponse = clientRequest.buildPost(Entity.form((Form)this.requestForm)).invoke();
        this.setResponse(new BackchannelAuthenticationResponse(this.clientResponse));
        if (StringUtils.isNotBlank((String)((BackchannelAuthenticationResponse)this.response).getEntity())) {
            JSONObject jsonObj = new JSONObject(((BackchannelAuthenticationResponse)this.response).getEntity());
            if (jsonObj.has("auth_req_id")) {
                ((BackchannelAuthenticationResponse)this.getResponse()).setAuthReqId(jsonObj.getString("auth_req_id"));
            }
            if (jsonObj.has("expires_in")) {
                ((BackchannelAuthenticationResponse)this.getResponse()).setExpiresIn(jsonObj.getInt("expires_in"));
            }
            if (jsonObj.has("interval")) {
                ((BackchannelAuthenticationResponse)this.getResponse()).setInterval(jsonObj.getInt("interval"));
            }
        }
        return (BackchannelAuthenticationResponse)this.getResponse();
    }
}

