/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.client;

import io.jans.as.client.AuthorizationRequest;
import io.jans.as.client.AuthorizationResponse;
import io.jans.as.client.BaseClient;
import io.jans.as.model.common.AuthorizationMethod;
import io.jans.as.model.common.Display;
import io.jans.as.model.common.HasParamName;
import io.jans.as.model.common.Prompt;
import io.jans.as.model.common.ResponseType;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Form;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;

public class AuthorizeClient
extends BaseClient<AuthorizationRequest, AuthorizationResponse> {
    private static final Logger LOG = Logger.getLogger(AuthorizeClient.class);

    public AuthorizeClient(String url) {
        super(url);
    }

    @Override
    public String getHttpMethod() {
        if (((AuthorizationRequest)this.request).getAuthorizationMethod() == null || ((AuthorizationRequest)this.request).getAuthorizationMethod() == AuthorizationMethod.AUTHORIZATION_REQUEST_HEADER_FIELD || ((AuthorizationRequest)this.request).getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER) {
            return "POST";
        }
        return "GET";
    }

    public AuthorizationResponse execAuthorizationCodeGrant(String clientId, List<String> scopes, String redirectUri, String nonce, String state, String req, String reqUri, Display display, List<Prompt> prompt) {
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        responseTypes.add(ResponseType.CODE);
        this.setRequest(new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce));
        ((AuthorizationRequest)this.getRequest()).setRedirectUri(redirectUri);
        ((AuthorizationRequest)this.getRequest()).setState(state);
        ((AuthorizationRequest)this.getRequest()).setRequest(req);
        ((AuthorizationRequest)this.getRequest()).setRedirectUri(reqUri);
        ((AuthorizationRequest)this.getRequest()).setDisplay(display);
        ((AuthorizationRequest)this.getRequest()).getPrompts().addAll(prompt);
        return this.exec();
    }

    @Deprecated
    public AuthorizationResponse execImplicitGrant(String clientId, List<String> scopes, String redirectUri, String nonce, String state, String req, String reqUri, Display display, List<Prompt> prompt) {
        ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
        responseTypes.add(ResponseType.TOKEN);
        this.setRequest(new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce));
        ((AuthorizationRequest)this.getRequest()).setRedirectUri(redirectUri);
        ((AuthorizationRequest)this.getRequest()).setState(state);
        ((AuthorizationRequest)this.getRequest()).setRequest(req);
        ((AuthorizationRequest)this.getRequest()).setRedirectUri(reqUri);
        ((AuthorizationRequest)this.getRequest()).setDisplay(display);
        ((AuthorizationRequest)this.getRequest()).getPrompts().addAll(prompt);
        return this.exec();
    }

    public AuthorizationResponse exec() {
        AuthorizationResponse response = null;
        try {
            this.initClient();
            response = this.exec_();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return response;
    }

    @Deprecated
    public AuthorizationResponse exec(ClientHttpEngine engine) {
        AuthorizationResponse response = null;
        try {
            this.resteasyClient = ((ResteasyClientBuilder)ClientBuilder.newBuilder()).httpEngine(engine).build();
            this.webTarget = this.resteasyClient.target(this.getUrl());
            response = this.exec_();
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return response;
    }

    private AuthorizationResponse exec_() throws Exception {
        String responseTypesAsString = ((AuthorizationRequest)this.getRequest()).getResponseTypesAsString();
        String scopesAsString = ((AuthorizationRequest)this.getRequest()).getScopesAsString();
        String promptsAsString = ((AuthorizationRequest)this.getRequest()).getPromptsAsString();
        String uiLocalesAsString = ((AuthorizationRequest)this.getRequest()).getUiLocalesAsString();
        String claimLocalesAsString = ((AuthorizationRequest)this.getRequest()).getClaimsLocalesAsString();
        String acrValuesAsString = ((AuthorizationRequest)this.getRequest()).getAcrValuesAsString();
        String claimsAsString = ((AuthorizationRequest)this.getRequest()).getClaimsAsString();
        this.addReqParam("response_type", responseTypesAsString);
        this.addReqParam("client_id", ((AuthorizationRequest)this.getRequest()).getClientId());
        this.addReqParam("scope", scopesAsString);
        this.addReqParam("redirect_uri", ((AuthorizationRequest)this.getRequest()).getRedirectUri());
        this.addReqParam("state", ((AuthorizationRequest)this.getRequest()).getState());
        this.addReqParam("response_mode", (HasParamName)((AuthorizationRequest)this.getRequest()).getResponseMode());
        this.addReqParam("nonce", ((AuthorizationRequest)this.getRequest()).getNonce());
        this.addReqParam("display", (HasParamName)((AuthorizationRequest)this.getRequest()).getDisplay());
        this.addReqParam("prompt", promptsAsString);
        if (((AuthorizationRequest)this.getRequest()).getMaxAge() != null) {
            this.addReqParam("max_age", ((AuthorizationRequest)this.getRequest()).getMaxAge().toString());
        }
        this.addReqParam("ui_locales", uiLocalesAsString);
        this.addReqParam("claims_locales", claimLocalesAsString);
        this.addReqParam("id_token_hint", ((AuthorizationRequest)this.getRequest()).getIdTokenHint());
        this.addReqParam("login_hint", ((AuthorizationRequest)this.getRequest()).getLoginHint());
        this.addReqParam("acr_values", acrValuesAsString);
        this.addReqParam("claims", claimsAsString);
        this.addReqParam("registration", ((AuthorizationRequest)this.getRequest()).getRegistration());
        this.addReqParam("request", ((AuthorizationRequest)this.getRequest()).getRequest());
        this.addReqParam("request_uri", ((AuthorizationRequest)this.getRequest()).getRequestUri());
        this.addReqParam("access_token", ((AuthorizationRequest)this.getRequest()).getAccessToken());
        this.addReqParam("custom_response_headers", ((AuthorizationRequest)this.getRequest()).getCustomResponseHeadersAsString());
        this.addReqParam("code_challenge", ((AuthorizationRequest)this.getRequest()).getCodeChallenge());
        this.addReqParam("code_challenge_method", ((AuthorizationRequest)this.getRequest()).getCodeChallengeMethod());
        if (((AuthorizationRequest)this.getRequest()).isRequestSessionId()) {
            this.addReqParam("request_session_id", Boolean.toString(((AuthorizationRequest)this.getRequest()).isRequestSessionId()));
        }
        this.addReqParam("session_id", ((AuthorizationRequest)this.getRequest()).getSessionId());
        for (String key : ((AuthorizationRequest)this.request).getCustomParameters().keySet()) {
            this.addReqParam(key, ((AuthorizationRequest)this.request).getCustomParameters().get(key));
        }
        Invocation.Builder clientRequest = this.webTarget.request();
        this.applyCookies(clientRequest);
        clientRequest.header("Content-Type", (Object)"application/x-www-form-urlencoded");
        if (((AuthorizationRequest)this.getRequest()).isUseNoRedirectHeader()) {
            clientRequest.header("X-Gluu-NoRedirect", (Object)"true");
        }
        if (((AuthorizationRequest)this.request).getAuthorizationMethod() != AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER && ((AuthorizationRequest)this.request).hasCredentials()) {
            clientRequest.header("Authorization", (Object)("Basic " + ((AuthorizationRequest)this.request).getEncodedCredentials()));
        }
        this.clientResponse = ((AuthorizationRequest)this.request).getAuthorizationMethod() == AuthorizationMethod.FORM_ENCODED_BODY_PARAMETER ? clientRequest.buildPost(Entity.form((Form)this.requestForm)).invoke() : clientRequest.buildGet().invoke();
        this.setResponse(new AuthorizationResponse(this.clientResponse));
        return (AuthorizationResponse)this.getResponse();
    }
}

