/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.testing;

import io.dropwizard.testing.ConfigOverride;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ConfigOverrideRandomPorts
extends ConfigOverride {
    private static final String SERVER_APPLICATION_CONNECTORS_PORT = "server.applicationConnectors[0].port";
    private static final String SERVER_ADMIN_CONNECTORS_PORT = "server.adminConnectors[0].port";
    private final String propertyPrefix;
    private @Nullable String applicationConnectorsPort = null;
    private @Nullable String adminConnectorsPort = null;

    ConfigOverrideRandomPorts(String propertyPrefix) {
        this.propertyPrefix = propertyPrefix.endsWith(".") ? propertyPrefix : propertyPrefix + ".";
    }

    @Override
    public void addToSystemProperties() {
        this.applicationConnectorsPort = System.setProperty(this.propertyPrefix + SERVER_APPLICATION_CONNECTORS_PORT, "0");
        this.adminConnectorsPort = System.setProperty(this.propertyPrefix + SERVER_ADMIN_CONNECTORS_PORT, "0");
    }

    @Override
    public void removeFromSystemProperties() {
        if (this.applicationConnectorsPort != null) {
            System.setProperty(this.propertyPrefix + SERVER_APPLICATION_CONNECTORS_PORT, this.applicationConnectorsPort);
        } else {
            System.clearProperty(this.propertyPrefix + SERVER_APPLICATION_CONNECTORS_PORT);
        }
        if (this.adminConnectorsPort != null) {
            System.setProperty(this.propertyPrefix + SERVER_ADMIN_CONNECTORS_PORT, this.adminConnectorsPort);
        } else {
            System.clearProperty(this.propertyPrefix + SERVER_ADMIN_CONNECTORS_PORT);
        }
    }
}

