/*
 * Decompiled with CFR 0.152.
 */
package cucumber.deps.com.thoughtworks.xstream.converters.extended;

import cucumber.deps.com.thoughtworks.xstream.converters.MarshallingContext;
import cucumber.deps.com.thoughtworks.xstream.converters.UnmarshallingContext;
import cucumber.deps.com.thoughtworks.xstream.converters.collections.CollectionConverter;
import cucumber.deps.com.thoughtworks.xstream.core.util.HierarchicalStreams;
import cucumber.deps.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import cucumber.deps.com.thoughtworks.xstream.io.HierarchicalStreamReader;
import cucumber.deps.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import cucumber.deps.com.thoughtworks.xstream.mapper.Mapper;

public class NamedCollectionConverter
extends CollectionConverter {
    private final String name;
    private final Class type;

    public NamedCollectionConverter(Mapper mapper, String itemName, Class itemType) {
        this(null, mapper, itemName, itemType);
    }

    public NamedCollectionConverter(Class type, Mapper mapper, String itemName, Class itemType) {
        super(mapper, type);
        this.name = itemName;
        this.type = itemType;
    }

    protected void writeItem(Object item, MarshallingContext context, HierarchicalStreamWriter writer) {
        String attributeName;
        Class itemType = item == null ? Mapper.Null.class : item.getClass();
        ExtendedHierarchicalStreamWriterHelper.startNode(writer, this.name, itemType);
        if (!itemType.equals(this.type) && (attributeName = this.mapper().aliasForSystemAttribute("class")) != null) {
            writer.addAttribute(attributeName, this.mapper().serializedClass(itemType));
        }
        if (item != null) {
            context.convertAnother(item);
        }
        writer.endNode();
    }

    protected Object readItem(HierarchicalStreamReader reader, UnmarshallingContext context, Object current) {
        Class itemType;
        String className = HierarchicalStreams.readClassAttribute(reader, this.mapper());
        Class clazz = itemType = className == null ? this.type : this.mapper().realClass(className);
        if (Mapper.Null.class.equals((Object)itemType)) {
            return null;
        }
        return context.convertAnother(current, itemType);
    }
}

