/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.nio.file;

import de.schlichtherle.truezip.fs.nio.file.FileEntry;
import de.schlichtherle.truezip.socket.IOPool;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class TempFilePool
implements IOPool<FileEntry> {
    private static final Path TEMP_DIR = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    static final TempFilePool INSTANCE = new TempFilePool(null, null);
    @Nullable
    private final Path dir;
    private final String name;

    TempFilePool(@CheckForNull Path dir, @CheckForNull String name) {
        this.dir = null != dir ? dir : TEMP_DIR;
        this.name = null != name ? name + "." : "tzp";
    }

    public Buffer allocate() throws IOException {
        return new Buffer(Files.createTempFile(this.dir, this.name, null, new FileAttribute[0]), this);
    }

    public void release(IOPool.Entry<FileEntry> resource) throws IOException {
        resource.release();
    }

    @NotThreadSafe
    private static final class Buffer
    extends FileEntry
    implements IOPool.Entry<FileEntry> {
        Buffer(Path file, TempFilePool pool) {
            super(file);
            assert (null != file);
            assert (null != pool);
            this.pool = pool;
        }

        @Override
        public void release() throws IOException {
            if (null == this.pool) {
                throw new IllegalStateException(this.getPath() + " (already released)");
            }
            this.pool(null);
        }

        private void pool(@CheckForNull TempFilePool newPool) throws IOException {
            TempFilePool oldPool = this.pool;
            this.pool = newPool;
            if (oldPool != newPool) {
                Files.deleteIfExists(this.getPath());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.pool(null);
            }
            finally {
                super.finalize();
            }
        }
    }
}

