/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.rep.InsufficientAcksException;
import com.sleepycat.je.rep.InsufficientReplicasException;
import com.sleepycat.je.rep.arbitration.Arbiter;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.node.FeederManager;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.stream.FeederTxns;
import com.sleepycat.je.rep.txn.MasterTxn;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.LoggerUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DurabilityQuorum {
    private final RepImpl repImpl;
    private final Logger logger;

    public DurabilityQuorum(RepImpl repImpl) {
        this.repImpl = repImpl;
        this.logger = LoggerUtils.getLogger(this.getClass());
    }

    public void ensureReplicasForCommit(MasterTxn txn, int insufficientReplicasTimeout) throws DatabaseException, InterruptedException, InsufficientReplicasException {
        RepNode repNode = this.repImpl.getRepNode();
        if (!repNode.isMaster()) {
            return;
        }
        Durability.ReplicaAckPolicy ackPolicy = txn.getDefaultDurability().getReplicaAck();
        int requiredReplicaAckCount = this.getCurrentRequiredAckCount(ackPolicy);
        if (this.logger.isLoggable(Level.FINE)) {
            LoggerUtils.fine(this.logger, this.repImpl, "Txn " + txn + ": checking that " + requiredReplicaAckCount + " feeders exist before starting commit");
        }
        if (requiredReplicaAckCount == 0) {
            return;
        }
        if (repNode.feederManager().awaitFeederReplicaConnections(requiredReplicaAckCount, insufficientReplicasTimeout)) {
            return;
        }
        if (!repNode.isMaster()) {
            return;
        }
        if (ackPolicy.equals((Object)Durability.ReplicaAckPolicy.SIMPLE_MAJORITY) && repNode.getArbiter().activateArbitration()) {
            return;
        }
        boolean includeArbiters = !ackPolicy.equals((Object)Durability.ReplicaAckPolicy.ALL);
        throw new InsufficientReplicasException((Locker)txn, ackPolicy, requiredReplicaAckCount, repNode.feederManager().activeAckReplicas(includeArbiters));
    }

    public boolean replicaAcksQualify(RepNodeImpl replica) {
        return replica.getType().isElectable();
    }

    public void ensureSufficientAcks(FeederTxns.TxnInfo txnInfo, int timeoutMs) throws InsufficientAcksException {
        int pendingAcks = txnInfo.getPendingAcks();
        if (pendingAcks == 0) {
            return;
        }
        MasterTxn txn = txnInfo.getTxn();
        int requiredAcks = this.getCurrentRequiredAckCount(txn.getCommitDurability().getReplicaAck());
        int requiredAckDelta = txn.getRequiredAckCount() - requiredAcks;
        if (requiredAckDelta >= pendingAcks) {
            return;
        }
        String dumpState = this.repImpl.dumpAckFeederState();
        FeederManager feederManager = this.repImpl.getRepNode().feederManager();
        int currentFeederCount = feederManager.getNumCurrentAckFeeders(txn.getCommitVLSN());
        if (currentFeederCount >= requiredAcks) {
            String msg = "txn " + txn.getId() + " commit vlsn:" + txnInfo.getCommitVLSN() + " acknowledged after explicit feeder check latch count:" + txnInfo.getPendingAcks() + " state:" + dumpState + " required acks:" + requiredAcks;
            LoggerUtils.info(this.logger, this.repImpl, msg);
            return;
        }
        if (this.repImpl.getRepNode().getArbiter().activationPossible()) {
            return;
        }
        throw new InsufficientAcksException(txn, pendingAcks, timeoutMs, dumpState);
    }

    public int getCurrentRequiredAckCount(Durability.ReplicaAckPolicy ackPolicy) {
        RepNode repNode = this.repImpl.getRepNode();
        int electableGroupSizeOverride = repNode.getElectionQuorum().getElectableGroupSizeOverride();
        if (electableGroupSizeOverride > 0) {
            return ackPolicy.minAckNodes(electableGroupSizeOverride) - 1;
        }
        Arbiter arbiter = repNode.getArbiter();
        if (arbiter.isApplicable(ackPolicy)) {
            return arbiter.getAckCount(ackPolicy);
        }
        return ackPolicy.minAckNodes(repNode.getGroup().getAckGroupSize()) - 1;
    }
}

